/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.postoffice.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.impl.BindingsImpl;
import org.apache.activemq.artemis.core.server.Bindable;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.RefsOperation;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.selector.filter.Filterable;
import org.apache.activemq.artemis.tests.unit.core.postoffice.impl.fakes.FakeQueue;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BindingsImplTest
extends ActiveMQTestBase {
    @Test
    public void testGetNextBindingWithLoadBalancingOnDemand() throws Exception {
        FakeRemoteBinding fake = new FakeRemoteBinding(SimpleString.of((String)"a"));
        fake.filter = null;
        fake.messageLoadBalancingType = MessageLoadBalancingType.ON_DEMAND;
        BindingsImpl bind = new BindingsImpl(null, null, (StorageManager)new NullStorageManager(1000));
        bind.addBinding((Binding)fake);
        bind.route((Message)new CoreMessage(0L, 100), (RoutingContext)new RoutingContextImpl((Transaction)new FakeTransaction()));
        Assertions.assertEquals((int)1, (int)fake.routedCount.get());
    }

    @Test
    public void testGetNextBindingWithLoadBalancingOff() throws Exception {
        FakeRemoteBinding fake = new FakeRemoteBinding(SimpleString.of((String)"a"));
        fake.filter = null;
        fake.messageLoadBalancingType = MessageLoadBalancingType.OFF;
        BindingsImpl bind = new BindingsImpl(null, null, (StorageManager)new NullStorageManager(1000));
        bind.addBinding((Binding)fake);
        bind.route((Message)new CoreMessage(0L, 100), (RoutingContext)new RoutingContextImpl((Transaction)new FakeTransaction()));
        Assertions.assertEquals((int)0, (int)fake.routedCount.get());
    }

    @Test
    public void testGetNextBindingWithLoadBalancingOffWithRedistribution() throws Exception {
        FakeRemoteBinding fake = new FakeRemoteBinding(SimpleString.of((String)"a"));
        fake.filter = null;
        fake.messageLoadBalancingType = MessageLoadBalancingType.OFF_WITH_REDISTRIBUTION;
        BindingsImpl bind = new BindingsImpl(null, null, (StorageManager)new NullStorageManager(1000));
        bind.addBinding((Binding)fake);
        bind.route((Message)new CoreMessage(0L, 100), (RoutingContext)new RoutingContextImpl((Transaction)new FakeTransaction()));
        Assertions.assertEquals((int)0, (int)fake.routedCount.get());
    }

    @Test
    public void testRemoveWhileRouting() throws Exception {
        for (int i = 0; i < 500; ++i) {
            this.internalTest(true);
        }
    }

    @Test
    public void testRemoveWhileRedistributing() throws Exception {
        for (int i = 0; i < 500; ++i) {
            this.internalTest(false);
        }
    }

    private void internalTest(boolean route) throws Exception {
        FakeBinding fake = new FakeBinding(SimpleString.of((String)"a"));
        BindingsImpl bind = new BindingsImpl(null, null, (StorageManager)new NullStorageManager(1000));
        bind.addBinding((Binding)fake);
        bind.addBinding((Binding)new FakeBinding(SimpleString.of((String)"a")));
        bind.addBinding((Binding)new FakeBinding(SimpleString.of((String)"a")));
        Thread t = new Thread(() -> BindingsImplTest.lambda$internalTest$0((Bindings)bind, fake));
        FakeQueue queue = new FakeQueue(SimpleString.of((String)"a"));
        t.start();
        for (int i = 0; i < 100; ++i) {
            if (route) {
                bind.route((Message)new CoreMessage((long)i, 100), (RoutingContext)new RoutingContextImpl((Transaction)new FakeTransaction()));
                continue;
            }
            bind.redistribute((Message)new CoreMessage((long)i, 100), (Queue)queue, (RoutingContext)new RoutingContextImpl((Transaction)new FakeTransaction()));
        }
    }

    private static /* synthetic */ void lambda$internalTest$0(Bindings bind, FakeBinding fake) {
        try {
            bind.removeBindingByUniqueName(fake.getUniqueName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final class FakeRemoteBinding
    extends FakeBinding
    implements RemoteQueueBinding {
        MessageLoadBalancingType messageLoadBalancingType;

        FakeRemoteBinding(SimpleString name) {
            super(name);
        }

        public boolean isLocal() {
            return false;
        }

        public int consumerCount() {
            return 0;
        }

        public Queue getQueue() {
            return null;
        }

        public void addConsumer(SimpleString filterString) throws Exception {
        }

        public void removeConsumer(SimpleString filterString) throws Exception {
        }

        public void reset() {
        }

        public void disconnect() {
        }

        public void connect() {
        }

        public long getRemoteQueueID() {
            return 0L;
        }

        public void setFilter(Filter filter) {
        }

        public MessageLoadBalancingType getMessageLoadBalancingType() {
            return this.messageLoadBalancingType;
        }
    }

    private final class FakeTransaction
    implements Transaction {
        private FakeTransaction() {
        }

        public Object getProtocolData() {
            return null;
        }

        public boolean isAsync() {
            return false;
        }

        public Transaction setAsync(boolean async) {
            return null;
        }

        public void setProtocolData(Object data) {
        }

        public void afterWired(Runnable runnable) {
        }

        public void afterStore(TransactionOperation sync) {
        }

        public void addOperation(TransactionOperation sync) {
        }

        public boolean isEffective() {
            return false;
        }

        public boolean hasTimedOut(long currentTime, int defaultTimeout) {
            return false;
        }

        public void commit() throws Exception {
        }

        public boolean tryRollback() {
            return true;
        }

        public void commit(boolean onePhase) throws Exception {
        }

        public long getCreateTime() {
            return 0L;
        }

        public long getID() {
            return 0L;
        }

        public Object getProperty(int index) {
            return null;
        }

        public boolean isContainsPersistent() {
            return false;
        }

        public Transaction.State getState() {
            return null;
        }

        public Xid getXid() {
            return null;
        }

        public void markAsRollbackOnly(ActiveMQException exception) {
        }

        public void prepare() throws Exception {
        }

        public void putProperty(int index, Object property) {
        }

        public void removeOperation(TransactionOperation sync) {
        }

        public void resume() {
        }

        public void rollback() throws Exception {
        }

        public void setState(Transaction.State state) {
        }

        public void suspend() {
        }

        public Set<Queue> getDistinctQueues() {
            return Collections.emptySet();
        }

        public void setContainsPersistent() {
        }

        public void setTimeout(int timeout) {
        }

        public List<TransactionOperation> getAllOperations() {
            return null;
        }

        public void setWaitBeforeCommit(boolean waitBeforeCommit) {
        }

        public RefsOperation createRefsOperation(Queue queue, AckReason reason) {
            return null;
        }

        public boolean hasTimedOut() {
            return false;
        }
    }

    private class FakeBinding
    implements Binding {
        Filter filter;
        AtomicInteger routedCount;
        final SimpleString name;
        final SimpleString uniqueName;

        public void close() throws Exception {
        }

        public void unproposed(SimpleString groupID) {
        }

        FakeBinding(SimpleString name) {
            this.filter = new FakeFilter();
            this.routedCount = new AtomicInteger();
            this.uniqueName = SimpleString.of((String)UUID.randomUUID().toString());
            this.name = name;
        }

        public SimpleString getAddress() {
            return null;
        }

        public Bindable getBindable() {
            return null;
        }

        public SimpleString getClusterName() {
            return null;
        }

        public int getDistance() {
            return 0;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public Long getID() {
            return 0L;
        }

        public SimpleString getRoutingName() {
            return this.name;
        }

        public BindingType getType() {
            return null;
        }

        public SimpleString getUniqueName() {
            return this.uniqueName;
        }

        public boolean isExclusive() {
            return false;
        }

        public boolean isHighAcceptPriority(Message message) {
            return false;
        }

        public void route(Message message, RoutingContext context) throws Exception {
            this.routedCount.incrementAndGet();
        }

        public String toManagementString() {
            return null;
        }

        public boolean isConnected() {
            return true;
        }

        public void routeWithAck(Message message, RoutingContext context) {
        }
    }

    private final class FakeFilter
    implements Filter {
        private FakeFilter() {
        }

        public SimpleString getFilterString() {
            return null;
        }

        public boolean match(Message message) {
            return false;
        }

        public boolean match(Map<String, String> map) {
            return false;
        }

        public boolean match(Filterable filterable) {
            return false;
        }
    }
}

