/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.remoting;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.unit.core.remoting.server.impl.fake.FakeAcceptorFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AcceptorsTest
extends ActiveMQTestBase {
    @Test
    public void testMultipleAcceptorsWithSameHostPortDifferentName() throws Exception {
        String acceptorFactoryClass = FakeAcceptorFactory.class.getName();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("host", "localhost");
        params.put("port", 5445);
        HashSet<TransportConfiguration> tcs = new HashSet<TransportConfiguration>();
        tcs.add(new TransportConfiguration(acceptorFactoryClass, params, "Acceptor1"));
        tcs.add(new TransportConfiguration(acceptorFactoryClass, params, "Acceptor2"));
        ConfigurationImpl config = this.createBasicConfig();
        config.setAcceptorConfigurations(tcs);
        ActiveMQServer server = this.createServer((Configuration)config);
        server.start();
        this.waitForServerToStart(server);
        Assertions.assertNotNull((Object)server.getRemotingService().getAcceptor("Acceptor1"));
        Assertions.assertNotNull((Object)server.getRemotingService().getAcceptor("Acceptor2"));
    }
}

