/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.util;

import io.netty.util.collection.LongObjectHashMap;
import java.lang.invoke.MethodHandles;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.collections.LinkedListImpl;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.artemis.utils.collections.NodeStore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedListTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private int scans = 0;
    private LinkedListImpl<Integer> list;
    Comparator<Integer> integerComparator = (o1, o2) -> {
        logger.trace("Compare {} and {}", o1, o2);
        if (o1.intValue() == o2.intValue()) {
            logger.trace("Return 0");
            return 0;
        }
        if (o2 > o1) {
            logger.trace("o2 is greater than, returning 1");
            return 1;
        }
        logger.trace("o2 is lower than, returning -1");
        return -1;
    };

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.list = new LinkedListImpl<Integer>(this.integerComparator){

            protected boolean addSortedScan(Integer e) {
                ++LinkedListTest.this.scans;
                return super.addSortedScan((Object)e);
            }
        };
    }

    @Test
    public void addSorted() {
        Assertions.assertEquals((int)0, (int)this.scans);
        this.list.addSorted((Object)1);
        this.list.addSorted((Object)3);
        this.list.addSorted((Object)2);
        this.list.addSorted((Object)0);
        Assertions.assertEquals((int)0, (int)this.scans);
        this.validateOrder(null);
        Assertions.assertEquals((int)4, (int)this.list.size());
    }

    @Test
    public void addSortedCachedLast() {
        Assertions.assertEquals((int)0, (int)this.scans);
        this.list.addSorted((Object)5);
        this.list.addSorted((Object)1);
        this.list.addSorted((Object)3);
        this.list.addSorted((Object)4);
        this.list.addSorted((Object)2);
        this.list.addSorted((Object)10);
        this.list.addSorted((Object)20);
        this.list.addSorted((Object)19);
        this.list.addSorted((Object)7);
        this.list.addSorted((Object)8);
        Assertions.assertEquals((int)0, (int)this.scans);
        Assertions.assertEquals((int)1, (int)((Integer)this.list.poll()));
        this.list.addSorted((Object)9);
        Assertions.assertEquals((int)1, (int)this.scans);
        this.printDebug();
        this.validateOrder(null);
    }

    @Test
    public void scanDirectionalTest() {
        this.list.addSorted((Object)9);
        Assertions.assertEquals((int)1, (int)this.list.size());
        this.list.addSorted((Object)5);
        Assertions.assertEquals((int)2, (int)this.list.size());
        this.list.addSorted((Object)6);
        Assertions.assertEquals((int)3, (int)this.list.size());
        this.list.addSorted((Object)2);
        Assertions.assertEquals((int)4, (int)this.list.size());
        this.list.addSorted((Object)7);
        Assertions.assertEquals((int)5, (int)this.list.size());
        this.list.addSorted((Object)4);
        Assertions.assertEquals((int)6, (int)this.list.size());
        this.list.addSorted((Object)8);
        Assertions.assertEquals((int)7, (int)this.list.size());
        this.list.addSorted((Object)1);
        Assertions.assertEquals((int)8, (int)this.list.size());
        this.list.addSorted((Object)10);
        Assertions.assertEquals((int)9, (int)this.list.size());
        this.list.addSorted((Object)3);
        Assertions.assertEquals((int)10, (int)this.list.size());
        this.printDebug();
        this.validateOrder(null);
    }

    private void printDebug() {
        if (logger.isDebugEnabled()) {
            logger.debug("**** list output:");
            LinkedListIterator integerIterator = this.list.iterator();
            while (integerIterator.hasNext()) {
                logger.debug("list {}", integerIterator.next());
            }
            integerIterator.close();
        }
    }

    @Test
    public void randomSorted() {
        int elements = 10000;
        HashSet<Integer> values = new HashSet<Integer>();
        for (int i = 0; i < elements; ++i) {
            int value;
            while (values.contains(value = RandomUtil.randomInt())) {
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Adding {}", (Object)value);
            }
            values.add(value);
            this.list.addSorted((Object)value);
        }
        Assertions.assertEquals((int)values.size(), (int)this.list.size());
        this.validateOrder(values);
        Assertions.assertEquals((int)0, (int)values.size());
    }

    private void validateOrder(HashSet<Integer> values) {
        Integer previous = null;
        LinkedListIterator integerIterator = this.list.iterator();
        while (integerIterator.hasNext()) {
            Integer value = (Integer)integerIterator.next();
            logger.debug("Reading {}", (Object)value);
            if (previous != null) {
                Assertions.assertTrue((this.integerComparator.compare(previous, value) > 0 ? (byte)1 : 0) != 0, (String)(value + " should be > " + previous));
                Assertions.assertTrue((value > previous ? (byte)1 : 0) != 0, (String)(value + " should be > " + previous));
            }
            if (values != null) {
                values.remove(value);
            }
            previous = value;
        }
        integerIterator.close();
    }

    @Test
    public void testAddAndRemove() {
        LinkedListImpl objs = new LinkedListImpl();
        for (int i = 0; i < 100; ++i) {
            ObservableNode o = new ObservableNode(null, i);
            objs.addTail((Object)o);
        }
        try (LinkedListIterator iter = objs.iterator();){
            for (int i = 0; i < 500; ++i) {
                for (int add = 0; add < 1000; ++add) {
                    ObservableNode o = new ObservableNode(null, add);
                    objs.addTail((Object)o);
                    Assertions.assertNotNull(o.publicPrev(), (String)"prev");
                    Assertions.assertNull(o.publicNext(), (String)"next");
                }
                for (int remove = 0; remove < 1000; ++remove) {
                    ObservableNode next = (ObservableNode)((Object)iter.next());
                    Assertions.assertNotNull((Object)((Object)next));
                    Assertions.assertNotNull(next.publicPrev(), (String)"prev");
                    Assertions.assertNotNull(next.publicNext(), (String)"next");
                    iter.remove();
                    Assertions.assertNull(next.publicPrev(), (String)"prev");
                    Assertions.assertNull(next.publicNext(), (String)"next");
                }
                Assertions.assertEquals((int)100, (int)objs.size());
            }
            while (iter.hasNext()) {
                ObservableNode next = (ObservableNode)((Object)iter.next());
                Assertions.assertNotNull((Object)((Object)next));
                iter.remove();
                Assertions.assertNull(next.publicPrev(), (String)"prev");
                Assertions.assertNull(next.publicNext(), (String)"next");
            }
        }
        Assertions.assertEquals((int)0, (int)objs.size());
    }

    @Test
    public void testAddAndRemoveWithIDs() {
        this.internalAddWithID(true);
    }

    @Test
    public void testAddAndRemoveWithIDsDeferredSupplier() {
        this.internalAddWithID(false);
    }

    private void internalAddWithID(boolean deferSupplier) {
        for (int sid = 1; sid <= 2; ++sid) {
            int i;
            LinkedListImpl objs = new LinkedListImpl();
            objs.clearID();
            String serverID = sid == 1 ? null : "" + sid;
            ListNodeStore nodeStore = new ListNodeStore();
            if (!deferSupplier) {
                objs.setNodeStore((NodeStore)nodeStore);
            }
            for (i = 1; i <= 1000; ++i) {
                ObservableNode o = new ObservableNode(serverID, i);
                objs.addTail((Object)o);
            }
            Assertions.assertEquals((int)1000, (int)objs.size());
            if (deferSupplier) {
                Assertions.assertEquals((int)0, (int)nodeStore.size());
                objs.setNodeStore((NodeStore)nodeStore);
            } else {
                objs.clearID();
                Assertions.assertEquals((int)0, (int)nodeStore.size());
                nodeStore = new ListNodeStore();
                objs.setNodeStore((NodeStore)nodeStore);
                Assertions.assertEquals((int)1000, (int)objs.size());
            }
            Assertions.assertEquals((int)1000, (int)nodeStore.size());
            for (i = 1; i <= 1000; i += 2) {
                objs.removeWithID(serverID, (long)i);
            }
            Assertions.assertEquals((int)500, (int)objs.size());
            Assertions.assertEquals((int)500, (int)nodeStore.size());
            LinkedListIterator iterator = objs.iterator();
            int i2 = 2;
            while (iterator.hasNext()) {
                ObservableNode value = (ObservableNode)((Object)iterator.next());
                Assertions.assertEquals((int)i2, (int)value.id);
                i2 += 2;
            }
            for (i2 = 2; i2 <= 1000; i2 += 2) {
                Assertions.assertNotNull((Object)objs.removeWithID(serverID, (long)i2));
            }
            Assertions.assertEquals((int)0, (int)nodeStore.size());
            Assertions.assertEquals((int)0, (int)objs.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRaceRemovingID() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        int elements = 1000;
        try {
            LinkedListImpl objs = new LinkedListImpl();
            ListNodeStore nodeStore = new ListNodeStore();
            objs.setNodeStore((NodeStore)nodeStore);
            String serverID = RandomUtil.randomString();
            for (int i = 0; i < elements; ++i) {
                objs.addHead((Object)new ObservableNode(serverID, i));
            }
            Assertions.assertEquals((int)elements, (int)objs.size());
            CyclicBarrier barrier = new CyclicBarrier(2);
            CountDownLatch latch = new CountDownLatch(2);
            AtomicInteger errors = new AtomicInteger(0);
            executor.execute(() -> {
                try {
                    barrier.await(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    for (int i = 0; i < elements; ++i) {
                        objs.removeWithID(serverID, (long)i);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    latch.countDown();
                }
            });
            executor.execute(() -> {
                LinkedListIterator iterator = objs.iterator();
                try {
                    barrier.await(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    while (iterator.hasNext()) {
                        Object value = iterator.next();
                        iterator.remove();
                    }
                }
                catch (Exception e) {
                    if (e instanceof NoSuchElementException) {
                    } else {
                        e.printStackTrace();
                        errors.incrementAndGet();
                    }
                }
                finally {
                    latch.countDown();
                }
            });
            Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
            Assertions.assertEquals((int)0, (int)objs.size());
            Assertions.assertEquals((int)0, (int)errors.get());
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testAddHeadAndRemove() {
        ObservableNode obj;
        LinkedListImpl objs = new LinkedListImpl();
        for (int i = 0; i < 1001; ++i) {
            ObservableNode o = new ObservableNode(null, i);
            objs.addHead((Object)o);
        }
        Assertions.assertEquals((int)1001, (int)objs.size());
        int countLoop = 0;
        try (LinkedListIterator iter = objs.iterator();){
            int removed = 0;
            for (countLoop = 0; countLoop <= 1000; ++countLoop) {
                obj = (ObservableNode)((Object)iter.next());
                Assertions.assertNotNull((Object)((Object)obj));
                if (countLoop != 500 && countLoop != 1000) continue;
                Assertions.assertNotNull(obj.publicPrev(), (String)"prev");
                iter.remove();
                Assertions.assertNull(obj.publicPrev(), (String)"prev");
                Assertions.assertNull(obj.publicNext(), (String)"next");
                ++removed;
            }
            Assertions.assertEquals((int)(1001 - removed), (int)objs.size());
        }
        int expectedSize = objs.size();
        try (LinkedListIterator iter = objs.iterator();){
            countLoop = 0;
            while (iter.hasNext()) {
                obj = (ObservableNode)((Object)iter.next());
                Assertions.assertNotNull((Object)((Object)obj));
                ++countLoop;
            }
            Assertions.assertEquals((int)expectedSize, (int)countLoop);
        }
        objs.clear();
    }

    @Test
    public void testAddTail() {
        int i;
        int num = 10;
        Assertions.assertEquals((int)0, (int)this.list.size());
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
            Assertions.assertEquals((int)(i + 1), (int)this.list.size());
        }
        for (i = 0; i < num; ++i) {
            Assertions.assertEquals((int)i, (int)((Integer)this.list.poll()));
            Assertions.assertEquals((int)(num - i - 1), (int)this.list.size());
        }
    }

    @Test
    public void testPeek() {
        Assertions.assertEquals((int)0, (int)this.list.size());
        Assertions.assertNull((Object)this.list.peek());
        this.list.addTail((Object)10);
        Assertions.assertEquals((int)10, (int)((Integer)this.list.peek()));
        Assertions.assertEquals((int)10, (int)((Integer)this.list.poll()));
        Assertions.assertNull((Object)this.list.peek());
        this.list.addTail((Object)12);
        Assertions.assertEquals((int)12, (int)((Integer)this.list.peek()));
        this.list.addHead((Object)5);
        Assertions.assertEquals((int)5, (int)((Integer)this.list.peek()));
        this.list.poll();
        Assertions.assertEquals((int)12, (int)((Integer)this.list.peek()));
        this.list.poll();
        Assertions.assertNull((Object)this.list.peek());
    }

    @Test
    public void testAddHead() {
        int i;
        int num = 10;
        Assertions.assertEquals((int)0, (int)this.list.size());
        for (i = 0; i < num; ++i) {
            this.list.addHead((Object)i);
            Assertions.assertEquals((int)(i + 1), (int)this.list.size());
        }
        for (i = num - 1; i >= 0; --i) {
            Assertions.assertEquals((int)i, (int)((Integer)this.list.poll()));
            Assertions.assertEquals((int)i, (int)this.list.size());
        }
    }

    @Test
    public void testAddHeadAndTail() {
        int i;
        int num = 10;
        for (i = 0; i < num; ++i) {
            this.list.addHead((Object)i);
        }
        for (i = num; i < num * 2; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = num * 2; i < num * 3; ++i) {
            this.list.addHead((Object)i);
        }
        for (i = num * 3; i < num * 4; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = num * 3 - 1; i >= num * 2; --i) {
            Assertions.assertEquals((int)i, (int)((Integer)this.list.poll()));
        }
        for (i = num - 1; i >= 0; --i) {
            Assertions.assertEquals((int)i, (int)((Integer)this.list.poll()));
        }
        for (i = num; i < num * 2; ++i) {
            Assertions.assertEquals((int)i, (int)((Integer)this.list.poll()));
        }
        for (i = num * 3; i < num * 4; ++i) {
            Assertions.assertEquals((int)i, (int)((Integer)this.list.poll()));
        }
    }

    @Test
    public void testPoll() {
        int i;
        int num = 10;
        Assertions.assertNull((Object)this.list.poll());
        Assertions.assertNull((Object)this.list.poll());
        Assertions.assertNull((Object)this.list.poll());
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = 0; i < num; ++i) {
            Assertions.assertEquals((int)i, (int)((Integer)this.list.poll()));
        }
        Assertions.assertNull((Object)this.list.poll());
        Assertions.assertNull((Object)this.list.poll());
        Assertions.assertNull((Object)this.list.poll());
        for (i = num; i < num * 2; ++i) {
            this.list.addHead((Object)i);
        }
        for (i = num * 2 - 1; i >= num; --i) {
            Assertions.assertEquals((int)i, (int)((Integer)this.list.poll()));
        }
        Assertions.assertNull((Object)this.list.poll());
        Assertions.assertNull((Object)this.list.poll());
        Assertions.assertNull((Object)this.list.poll());
    }

    @Test
    public void testIterateNoElements() {
        LinkedListIterator iter = this.list.iterator();
        Assertions.assertNotNull((Object)iter);
        this.assertNoSuchElementIsThrown((LinkedListIterator<Integer>)iter);
        try {
            iter.remove();
            Assertions.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateIteratorBeforeAddElements() {
        int num = 10;
        LinkedListIterator iter = this.list.iterator();
        Assertions.assertNotNull((Object)iter);
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        this.testIterate1(num, (LinkedListIterator<Integer>)iter);
    }

    @Test
    public void testCreateIteratorAfterAddElements() {
        int num = 10;
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        LinkedListIterator iter = this.list.iterator();
        Assertions.assertNotNull((Object)iter);
        this.testIterate1(num, (LinkedListIterator<Integer>)iter);
    }

    @Test
    public void testIterateThenAddMoreAndIterateAgain() {
        int i;
        int num = 10;
        for (int i2 = 0; i2 < num; ++i2) {
            this.list.addTail((Object)i2);
        }
        LinkedListIterator iter = this.list.iterator();
        Assertions.assertNotNull((Object)iter);
        for (i = 0; i < num; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
        }
        Assertions.assertFalse((boolean)iter.hasNext());
        this.assertNoSuchElementIsThrown((LinkedListIterator<Integer>)iter);
        for (i = num; i < num * 2; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = num; i < num * 2; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
        }
        Assertions.assertFalse((boolean)iter.hasNext());
        this.assertNoSuchElementIsThrown((LinkedListIterator<Integer>)iter);
        for (i = num * 2; i < num * 3; ++i) {
            this.list.addHead((Object)i);
        }
        iter = this.list.iterator();
        for (i = num * 3 - 1; i >= num * 2; --i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
        }
        for (i = 0; i < num * 2; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    private void testIterate1(int num, LinkedListIterator<Integer> iter) {
        for (int i = 0; i < num; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
        }
        Assertions.assertFalse((boolean)iter.hasNext());
        this.assertNoSuchElementIsThrown(iter);
    }

    private void assertNoSuchElementIsThrown(LinkedListIterator<Integer> iter) {
        try {
            iter.next();
            Assertions.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveAll() {
        int num = 10;
        LinkedListIterator iter = this.list.iterator();
        try {
            iter.remove();
            Assertions.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        Assertions.assertEquals((int)num, (int)this.list.size());
        try {
            iter.remove();
            Assertions.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException i) {
            // empty catch block
        }
        for (int i = 0; i < num; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
            iter.remove();
            Assertions.assertEquals((int)(num - i - 1), (int)this.list.size());
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRemoveOdd() {
        int i;
        int num = 10;
        LinkedListIterator iter = this.list.iterator();
        try {
            iter.remove();
            Assertions.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        for (int i2 = 0; i2 < num; ++i2) {
            this.list.addTail((Object)i2);
        }
        try {
            iter.remove();
            Assertions.fail((String)"Should throw NoSuchElementException");
        }
        catch (NoSuchElementException i2) {
            // empty catch block
        }
        int size = num;
        for (i = 0; i < num; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
            if (i % 2 == 0) {
                iter.remove();
                --size;
            }
            Assertions.assertEquals((int)this.list.size(), (int)size);
        }
        iter = this.list.iterator();
        for (i = 0; i < num; ++i) {
            if (i % 2 != 1) continue;
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRemoveHead1() {
        int i;
        int num = 10;
        LinkedListIterator iter = this.list.iterator();
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        iter.next();
        iter.remove();
        for (i = 1; i < num; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRemoveHead2() {
        int num = 10;
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        LinkedListIterator iter = this.list.iterator();
        iter.next();
        iter.remove();
        iter = this.list.iterator();
        for (int i = 1; i < num; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRemoveHead3() {
        int i;
        int num = 10;
        LinkedListIterator iter = this.list.iterator();
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = 0; i < num; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
            iter.remove();
        }
        for (i = num; i < num * 2; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = num; i < num * 2; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
            iter.remove();
        }
    }

    @Test
    public void testRemoveTail1() {
        int i;
        int num = 10;
        LinkedListIterator iter = this.list.iterator();
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = 0; i < num; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
        }
        Assertions.assertFalse((boolean)iter.hasNext());
        iter.remove();
        iter = this.list.iterator();
        for (i = 0; i < num - 1; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRemoveMiddle() {
        int i;
        int num = 10;
        for (int i2 = 0; i2 < num; ++i2) {
            this.list.addTail((Object)i2);
        }
        LinkedListIterator iter = this.list.iterator();
        for (i = 0; i < num / 2; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
        }
        iter.remove();
        iter = this.list.iterator();
        for (i = 0; i < num; ++i) {
            if (i == num / 2 - 1) continue;
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRemoveTail2() {
        int num = 10;
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        LinkedListIterator iter = this.list.iterator();
        for (int i = 0; i < num; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
        }
        Assertions.assertFalse((boolean)iter.hasNext());
        iter.remove();
        try {
            iter.remove();
            Assertions.fail((String)"Should throw exception");
        }
        catch (NoSuchElementException i) {
            // empty catch block
        }
        iter = this.list.iterator();
        for (int i = 0; i < num - 1; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
        }
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRemoveTail3() {
        int i;
        int num = 10;
        LinkedListIterator iter = this.list.iterator();
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = 0; i < num; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
        }
        Assertions.assertFalse((boolean)iter.hasNext());
        iter.remove();
        for (i = num; i < num * 2; ++i) {
            this.list.addTail((Object)i);
        }
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((int)8, (int)((Integer)iter.next()));
        for (i = num; i < num * 2; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
        }
    }

    @Test
    public void testRemoveHeadAndTail1() {
        LinkedListIterator iter = this.list.iterator();
        int num = 10;
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
            iter.remove();
        }
    }

    @Test
    public void testRemoveHeadAndTail2() {
        LinkedListIterator iter = this.list.iterator();
        int num = 10;
        for (int i = 0; i < num; ++i) {
            this.list.addHead((Object)i);
            Assertions.assertEquals((int)1, (int)this.list.size());
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
            iter.remove();
        }
    }

    @Test
    public void testRemoveHeadAndTail3() {
        LinkedListIterator iter = this.list.iterator();
        int num = 10;
        for (int i = 0; i < num; ++i) {
            if (i % 2 == 0) {
                this.list.addHead((Object)i);
            } else {
                this.list.addTail((Object)i);
            }
            Assertions.assertEquals((int)1, (int)this.list.size());
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
            iter.remove();
        }
    }

    @Test
    public void testRemoveInTurn() {
        int i;
        LinkedListIterator iter = this.list.iterator();
        int num = 10;
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = 0; i < num; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
            iter.remove();
        }
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertEquals((int)0, (int)this.list.size());
    }

    @Test
    public void testRemoveLastNudgeNoReplay() {
        for (int i = 1; i < 3; ++i) {
            this.doTestRemoveLastNudgeNoReplay(i);
        }
    }

    private void doTestRemoveLastNudgeNoReplay(int num) {
        int i;
        LinkedListIterator iter = this.list.iterator();
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = 0; i < num; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
        }
        LinkedListIterator pruneIterator = this.list.iterator();
        while (pruneIterator.hasNext()) {
            int v = (Integer)pruneIterator.next();
            if (v != num - 1) continue;
            pruneIterator.remove();
        }
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertEquals((int)(num - 1), (int)this.list.size());
    }

    @Test
    public void testGCNepotismPoll() {
        ObservableNode node;
        int count = 100;
        LinkedListImpl list = new LinkedListImpl();
        for (int i = 0; i < 100; ++i) {
            ObservableNode node2 = new ObservableNode(null, i);
            Assertions.assertNull(node2.publicPrev());
            Assertions.assertNull(node2.publicNext());
            list.addTail((Object)node2);
            Assertions.assertNotNull(node2.publicPrev());
        }
        int removed = 0;
        while ((node = (ObservableNode)((Object)list.poll())) != null) {
            Assertions.assertNull(node.publicPrev());
            Assertions.assertNull(node.publicNext());
            ++removed;
        }
        Assertions.assertEquals((int)100, (int)removed);
        Assertions.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testGCNepotismClear() {
        int count = 100;
        ObservableNode[] nodes = new ObservableNode[100];
        LinkedListImpl list = new LinkedListImpl();
        for (int i = 0; i < 100; ++i) {
            ObservableNode node = new ObservableNode(null, i);
            Assertions.assertNull(node.publicPrev());
            Assertions.assertNull(node.publicNext());
            nodes[i] = node;
            list.addTail((Object)node);
            Assertions.assertNotNull(node.publicPrev());
        }
        list.clear();
        for (ObservableNode node : nodes) {
            Assertions.assertNull(node.publicPrev());
            Assertions.assertNull(node.publicNext());
        }
        Assertions.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testClear() {
        int i;
        int num = 10;
        for (int i2 = 0; i2 < num; ++i2) {
            this.list.addTail((Object)i2);
        }
        Assertions.assertEquals((int)num, (int)this.list.size());
        this.list.clear();
        Assertions.assertEquals((int)0, (int)this.list.size());
        Assertions.assertNull((Object)this.list.poll());
        LinkedListIterator iter = this.list.iterator();
        Assertions.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        Assertions.assertEquals((int)num, (int)this.list.size());
        iter = this.list.iterator();
        for (i = 0; i < num; ++i) {
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((int)i, (int)((Integer)iter.next()));
        }
        Assertions.assertFalse((boolean)iter.hasNext());
        for (i = 0; i < num; ++i) {
            Assertions.assertEquals((int)i, (int)((Integer)this.list.poll()));
        }
        Assertions.assertNull((Object)this.list.poll());
        Assertions.assertEquals((int)0, (int)this.list.size());
    }

    @Test
    public void testMultipleIterators1() {
        int num = 10;
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        LinkedListIterator iter1 = this.list.iterator();
        LinkedListIterator iter2 = this.list.iterator();
        LinkedListIterator iter3 = this.list.iterator();
        int i = 0;
        while (i < num) {
            Assertions.assertTrue((boolean)iter1.hasNext());
            Assertions.assertEquals((int)i++, (int)((Integer)iter1.next()));
            iter1.remove();
            if (i == 10) break;
            Assertions.assertTrue((boolean)iter2.hasNext());
            Assertions.assertEquals((int)i++, (int)((Integer)iter2.next()));
            iter2.remove();
            Assertions.assertTrue((boolean)iter3.hasNext());
            Assertions.assertEquals((int)i++, (int)((Integer)iter3.next()));
            iter3.remove();
        }
    }

    @Test
    public void testRepeat() {
        int num = 10;
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        LinkedListIterator iter = this.list.iterator();
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((int)0, (int)((Integer)iter.next()));
        iter.repeat();
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((int)0, (int)((Integer)iter.next()));
        iter.next();
        iter.next();
        iter.next();
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((int)4, (int)((Integer)iter.next()));
        iter.repeat();
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((int)4, (int)((Integer)iter.next()));
        iter.next();
        iter.next();
        iter.next();
        iter.next();
        Assertions.assertEquals((int)9, (int)((Integer)iter.next()));
        Assertions.assertFalse((boolean)iter.hasNext());
        iter.repeat();
        Assertions.assertTrue((boolean)iter.hasNext());
        Assertions.assertEquals((int)9, (int)((Integer)iter.next()));
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRepeatAndRemove() {
        int num = 10;
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        LinkedListIterator iter1 = this.list.iterator();
        LinkedListIterator iter2 = this.list.iterator();
        Assertions.assertTrue((boolean)iter1.hasNext());
        Assertions.assertEquals((int)0, (int)((Integer)iter1.next()));
        Assertions.assertTrue((boolean)iter2.hasNext());
        Assertions.assertEquals((int)0, (int)((Integer)iter2.next()));
        iter2.remove();
        iter1.repeat();
        Assertions.assertTrue((boolean)iter1.hasNext());
        Assertions.assertEquals((int)1, (int)((Integer)iter1.next()));
        iter1.next();
        iter1.next();
        iter1.next();
        iter1.next();
        iter1.next();
        iter1.next();
        iter1.next();
        iter1.next();
        Assertions.assertEquals((int)9, (int)((Integer)iter1.next()));
        iter2.next();
        iter2.next();
        iter2.next();
        iter2.next();
        iter2.next();
        iter2.next();
        iter2.next();
        iter2.next();
        Assertions.assertEquals((int)9, (int)((Integer)iter2.next()));
        iter1.remove();
        iter2.repeat();
        Assertions.assertEquals((int)8, (int)((Integer)iter2.next()));
    }

    @Test
    public void testMultipleIterators2() {
        int num = 10;
        for (int i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        LinkedListIterator iter1 = this.list.iterator();
        LinkedListIterator iter2 = this.list.iterator();
        LinkedListIterator iter3 = this.list.iterator();
        LinkedListIterator iter4 = this.list.iterator();
        LinkedListIterator iter5 = this.list.iterator();
        Assertions.assertTrue((boolean)iter1.hasNext());
        Assertions.assertTrue((boolean)iter2.hasNext());
        Assertions.assertTrue((boolean)iter3.hasNext());
        Assertions.assertTrue((boolean)iter4.hasNext());
        Assertions.assertTrue((boolean)iter5.hasNext());
        Assertions.assertEquals((int)0, (int)((Integer)iter2.next()));
        Assertions.assertTrue((boolean)iter2.hasNext());
        Assertions.assertEquals((int)1, (int)((Integer)iter2.next()));
        Assertions.assertEquals((int)0, (int)((Integer)iter1.next()));
        iter1.remove();
        Assertions.assertTrue((boolean)iter1.hasNext());
        Assertions.assertEquals((int)1, (int)((Integer)iter1.next()));
        Assertions.assertEquals((int)1, (int)((Integer)iter3.next()));
        Assertions.assertEquals((int)1, (int)((Integer)iter4.next()));
        Assertions.assertEquals((int)1, (int)((Integer)iter5.next()));
        Assertions.assertTrue((boolean)iter4.hasNext());
        Assertions.assertEquals((int)2, (int)((Integer)iter4.next()));
        Assertions.assertEquals((int)3, (int)((Integer)iter4.next()));
        Assertions.assertEquals((int)4, (int)((Integer)iter4.next()));
        Assertions.assertEquals((int)5, (int)((Integer)iter4.next()));
        Assertions.assertEquals((int)6, (int)((Integer)iter4.next()));
        Assertions.assertEquals((int)7, (int)((Integer)iter4.next()));
        Assertions.assertEquals((int)8, (int)((Integer)iter4.next()));
        Assertions.assertEquals((int)9, (int)((Integer)iter4.next()));
        Assertions.assertFalse((boolean)iter4.hasNext());
        Assertions.assertTrue((boolean)iter5.hasNext());
        Assertions.assertEquals((int)2, (int)((Integer)iter5.next()));
        Assertions.assertEquals((int)3, (int)((Integer)iter5.next()));
        Assertions.assertEquals((int)4, (int)((Integer)iter5.next()));
        Assertions.assertEquals((int)5, (int)((Integer)iter5.next()));
        Assertions.assertEquals((int)6, (int)((Integer)iter5.next()));
        Assertions.assertTrue((boolean)iter3.hasNext());
        Assertions.assertEquals((int)2, (int)((Integer)iter3.next()));
        Assertions.assertEquals((int)3, (int)((Integer)iter3.next()));
        Assertions.assertEquals((int)4, (int)((Integer)iter3.next()));
        Assertions.assertTrue((boolean)iter2.hasNext());
        Assertions.assertEquals((int)2, (int)((Integer)iter2.next()));
        Assertions.assertEquals((int)3, (int)((Integer)iter2.next()));
        Assertions.assertEquals((int)4, (int)((Integer)iter2.next()));
        Assertions.assertTrue((boolean)iter1.hasNext());
        Assertions.assertEquals((int)2, (int)((Integer)iter1.next()));
        Assertions.assertEquals((int)3, (int)((Integer)iter1.next()));
        Assertions.assertEquals((int)4, (int)((Integer)iter1.next()));
        iter2.remove();
        Assertions.assertEquals((int)5, (int)((Integer)iter2.next()));
        iter2.remove();
        Assertions.assertTrue((boolean)iter1.hasNext());
        Assertions.assertEquals((int)6, (int)((Integer)iter1.next()));
        Assertions.assertTrue((boolean)iter2.hasNext());
        Assertions.assertEquals((int)6, (int)((Integer)iter2.next()));
        Assertions.assertTrue((boolean)iter3.hasNext());
        Assertions.assertEquals((int)6, (int)((Integer)iter3.next()));
        iter5.remove();
        Assertions.assertTrue((boolean)iter5.hasNext());
        Assertions.assertEquals((int)7, (int)((Integer)iter5.next()));
        Assertions.assertTrue((boolean)iter1.hasNext());
        Assertions.assertEquals((int)7, (int)((Integer)iter1.next()));
        Assertions.assertTrue((boolean)iter2.hasNext());
        Assertions.assertEquals((int)7, (int)((Integer)iter2.next()));
        Assertions.assertTrue((boolean)iter3.hasNext());
        Assertions.assertEquals((int)7, (int)((Integer)iter3.next()));
        Assertions.assertTrue((boolean)iter5.hasNext());
        Assertions.assertEquals((int)8, (int)((Integer)iter5.next()));
        Assertions.assertTrue((boolean)iter5.hasNext());
        Assertions.assertEquals((int)9, (int)((Integer)iter5.next()));
        Assertions.assertFalse((boolean)iter5.hasNext());
        iter5.remove();
        iter4.remove();
        this.list.addTail((Object)10);
        Assertions.assertTrue((boolean)iter5.hasNext());
        Assertions.assertEquals((int)7, (int)((Integer)iter5.next()));
        Assertions.assertTrue((boolean)iter5.hasNext());
        Assertions.assertEquals((int)10, (int)((Integer)iter5.next()));
        Assertions.assertTrue((boolean)iter4.hasNext());
        Assertions.assertEquals((int)7, (int)((Integer)iter4.next()));
        Assertions.assertTrue((boolean)iter4.hasNext());
        Assertions.assertEquals((int)10, (int)((Integer)iter4.next()));
        Assertions.assertTrue((boolean)iter3.hasNext());
        Assertions.assertEquals((int)10, (int)((Integer)iter3.next()));
        Assertions.assertTrue((boolean)iter2.hasNext());
        Assertions.assertEquals((int)10, (int)((Integer)iter2.next()));
        Assertions.assertTrue((boolean)iter1.hasNext());
        Assertions.assertEquals((int)10, (int)((Integer)iter1.next()));
    }

    @Test
    public void testGetElement() {
        int i;
        for (i = 0; i < 100; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = 0; i < 100; ++i) {
            Assertions.assertEquals((int)i, (int)((Integer)this.list.get(i)));
        }
        boolean expectedException = false;
        try {
            this.list.get(100);
        }
        catch (IndexOutOfBoundsException e) {
            expectedException = true;
        }
        Assertions.assertTrue((boolean)expectedException);
    }

    @Test
    public void testResizing() {
        int i;
        int numIters = 1000;
        LinkedList<LinkedListIterator> iters = new LinkedList<LinkedListIterator>();
        int num = 10;
        for (i = 0; i < num; ++i) {
            this.list.addTail((Object)i);
        }
        for (i = 0; i < numIters; ++i) {
            LinkedListIterator iter = this.list.iterator();
            iters.add(iter);
            for (int j = 0; j < num / 2; ++j) {
                Assertions.assertTrue((boolean)iter.hasNext());
                Assertions.assertEquals((int)j, (int)((Integer)iter.next()));
            }
        }
        Assertions.assertEquals((int)numIters, (int)this.list.numIters());
        boolean b = false;
        for (LinkedListIterator iter : iters) {
            if (b) {
                iter.close();
            }
            b = !b;
        }
        Assertions.assertEquals((int)(numIters / 2), (int)this.list.numIters());
        b = true;
        for (LinkedListIterator iter : iters) {
            if (b) {
                iter.close();
            }
            b = !b;
        }
        Assertions.assertEquals((int)0, (int)this.list.numIters());
    }

    private static final class ObservableNode
    extends LinkedListImpl.Node<ObservableNode> {
        public String serverID;
        public int id;

        ObservableNode(String serverID, int id) {
            this.id = id;
            this.serverID = serverID;
        }

        public LinkedListImpl.Node<ObservableNode> publicNext() {
            return this.next();
        }

        public LinkedListImpl.Node<ObservableNode> publicPrev() {
            return this.prev();
        }
    }

    static class ListNodeStore
    implements NodeStore<ObservableNode> {
        LongObjectHashMap<LinkedListImpl.Node<ObservableNode>> nodeLongObjectHashMap = new LongObjectHashMap();
        HashMap<Object, LongObjectHashMap<LinkedListImpl.Node<ObservableNode>>> mapList = new HashMap();

        ListNodeStore() {
        }

        public void storeNode(ObservableNode element, LinkedListImpl.Node<ObservableNode> node) {
            LongObjectHashMap<LinkedListImpl.Node<ObservableNode>> map = this.getNodesMap(element.serverID);
            map.put((long)element.id, node);
        }

        public LinkedListImpl.Node<ObservableNode> getNode(String listID, long id) {
            LongObjectHashMap<LinkedListImpl.Node<ObservableNode>> map = this.getNodesMap(listID);
            if (map == null) {
                return null;
            }
            return (LinkedListImpl.Node)map.get(id);
        }

        public void removeNode(ObservableNode element, LinkedListImpl.Node<ObservableNode> node) {
            LongObjectHashMap<LinkedListImpl.Node<ObservableNode>> map = this.getNodesMap(element.serverID);
            if (map != null) {
                map.remove((long)element.id);
            }
        }

        private LongObjectHashMap<LinkedListImpl.Node<ObservableNode>> getNodesMap(String listID) {
            if (listID == null) {
                return this.nodeLongObjectHashMap;
            }
            LongObjectHashMap theMap = this.mapList.get(listID);
            if (theMap == null) {
                theMap = new LongObjectHashMap();
                this.mapList.put(listID, (LongObjectHashMap<LinkedListImpl.Node<ObservableNode>>)theMap);
            }
            return theMap;
        }

        public void clear() {
            this.nodeLongObjectHashMap.clear();
            this.mapList.clear();
        }

        public int size() {
            int size = 0;
            for (LongObjectHashMap<LinkedListImpl.Node<ObservableNode>> list : this.mapList.values()) {
                size = list.size();
            }
            return this.nodeLongObjectHashMap.size() + size;
        }
    }
}

