/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.util;

import java.util.HashSet;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UUIDTest
extends ActiveMQTestBase {
    static final int MANY_TIMES = 100000;

    @Test
    public void testManyUUIDs() throws Exception {
        HashSet<String> uuidsSet = new HashSet<String>();
        UUIDGenerator gen = UUIDGenerator.getInstance();
        for (int i = 0; i < this.getTimes(); ++i) {
            uuidsSet.add(gen.generateStringUUID());
        }
        Assertions.assertEquals((int)this.getTimes(), (int)uuidsSet.size());
    }

    protected int getTimes() {
        return 100000;
    }

    @Test
    public void testStringToUuidConversion() {
        UUIDGenerator gen = UUIDGenerator.getInstance();
        for (int i = 0; i < 100000; ++i) {
            UUID uuid = gen.generateUUID();
            String uuidString = uuid.toString();
            byte[] data2 = UUID.stringToBytes((String)uuidString);
            UUID uuid2 = new UUID(1, data2);
            UUIDTest.assertEqualsByteArrays(uuid.asBytes(), data2);
            Assertions.assertEquals((Object)uuid, (Object)uuid2, (String)uuidString);
            Assertions.assertEquals((Object)uuidString, (Object)uuid2.toString(), (String)uuidString);
        }
    }
}

