/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.util;

import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jmx {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private static <C, T> Optional<T> queryControl(JMXServiceURL serviceURI, ObjectName objectName, ThrowableFunction<C, T> queryControl, Class<C> controlClass, Function<Throwable, T> onThrowable) {
        Optional<T> optional;
        block8: {
            JMXConnector jmx = JMXConnectorFactory.connect(serviceURI);
            try {
                C control = MBeanServerInvocationHandler.newProxyInstance(jmx.getMBeanServerConnection(), objectName, controlClass, false);
                optional = Optional.ofNullable(queryControl.apply(control));
                if (jmx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jmx != null) {
                        try {
                            jmx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    return Optional.ofNullable(onThrowable.apply(t));
                }
            }
            jmx.close();
        }
        return optional;
    }

    public static Optional<Boolean> isReplicaSync(JMXServiceURL serviceURI, ObjectNameBuilder builder) throws Exception {
        return Jmx.queryControl(serviceURI, builder.getActiveMQServerObjectName(), ActiveMQServerControl::isReplicaSync, ActiveMQServerControl.class, throwable -> null);
    }

    public static Optional<Boolean> isBackup(JMXServiceURL serviceURI, ObjectNameBuilder builder) throws Exception {
        return Jmx.queryControl(serviceURI, builder.getActiveMQServerObjectName(), ActiveMQServerControl::isBackup, ActiveMQServerControl.class, throwable -> null);
    }

    public static Optional<String> getNodeID(JMXServiceURL serviceURI, ObjectNameBuilder builder) throws Exception {
        return Jmx.queryControl(serviceURI, builder.getActiveMQServerObjectName(), ActiveMQServerControl::getNodeID, ActiveMQServerControl.class, throwable -> null);
    }

    public static Optional<Long> getActivationSequence(JMXServiceURL serviceURI, ObjectNameBuilder builder) throws Exception {
        return Jmx.queryControl(serviceURI, builder.getActiveMQServerObjectName(), ActiveMQServerControl::getActivationSequence, ActiveMQServerControl.class, throwable -> null);
    }

    public static Optional<Boolean> isActive(JMXServiceURL serviceURI, ObjectNameBuilder builder) throws Exception {
        return Jmx.queryControl(serviceURI, builder.getActiveMQServerObjectName(), ActiveMQServerControl::isActive, ActiveMQServerControl.class, throwable -> null);
    }

    public static Optional<String> listNetworkTopology(JMXServiceURL serviceURI, ObjectNameBuilder builder) throws Exception {
        return Jmx.queryControl(serviceURI, builder.getActiveMQServerObjectName(), ActiveMQServerControl::listNetworkTopology, ActiveMQServerControl.class, throwable -> null);
    }

    public static Map<String, Pair<String, String>> decodeNetworkTopologyJson(String networkTopologyJson) {
        if (networkTopologyJson == null || networkTopologyJson.isEmpty()) {
            return Collections.emptyMap();
        }
        JsonArray nodeIDs = JsonLoader.readArray((Reader)new StringReader(networkTopologyJson));
        int nodeCount = nodeIDs.size();
        HashMap<String, Pair<String, String>> networkTopology = new HashMap<String, Pair<String, String>>(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            JsonObject nodePair = nodeIDs.getJsonObject(i);
            try {
                String nodeID = nodePair.getString("nodeID");
                String primary = nodePair.getString("primary") == null ? nodePair.getString("live") : nodePair.getString("primary");
                String backup = nodePair.getString("backup", null);
                networkTopology.put(nodeID, (Pair<String, String>)new Pair((Object)primary, (Object)backup));
                continue;
            }
            catch (Exception e) {
                logger.warn("Error on {}", (Object)nodePair, (Object)e);
            }
        }
        return networkTopology;
    }

    private static long countMembers(Map<String, Pair<String, String>> networkTopology) {
        long count = networkTopology.values().stream().map(Pair::getA).filter(primary -> primary != null && !primary.isEmpty()).count();
        return count;
    }

    private static long countNodes(Map<String, Pair<String, String>> networkTopology) {
        long count = networkTopology.values().stream().flatMap(pair -> Stream.of((String)pair.getA(), (String)pair.getB())).filter(primaryOrBackup -> primaryOrBackup != null && !primaryOrBackup.isEmpty()).count();
        return count;
    }

    public static boolean validateNetworkTopology(String networkTopologyJson, Predicate<Map<String, Pair<String, String>>> checkTopology) {
        Map<String, Pair<String, String>> networkTopology = Jmx.decodeNetworkTopologyJson(networkTopologyJson);
        return checkTopology.test(networkTopology);
    }

    public static String backupOf(String nodeID, Map<String, Pair<String, String>> networkTopology) {
        return (String)networkTopology.get(nodeID).getB();
    }

    public static String primaryOf(String nodeID, Map<String, Pair<String, String>> networkTopology) {
        return (String)networkTopology.get(nodeID).getA();
    }

    public static Predicate<Map<String, Pair<String, String>>> containsExactNodeIds(String ... nodeID) {
        Objects.requireNonNull(nodeID);
        return topology -> {
            if (topology.size() != nodeID.length) return false;
            if (!Stream.of(nodeID).allMatch(topology::containsKey)) return false;
            return true;
        };
    }

    public static Predicate<Map<String, Pair<String, String>>> withMembers(int count) {
        return topology -> Jmx.countMembers(topology) == (long)count;
    }

    public static Predicate<Map<String, Pair<String, String>>> withNodes(int count) {
        return topology -> Jmx.countNodes(topology) == (long)count;
    }

    public static Predicate<Map<String, Pair<String, String>>> withBackup(String nodeId, Predicate<String> compare) {
        return topology -> compare.test(Jmx.backupOf(nodeId, topology));
    }

    public static Predicate<Map<String, Pair<String, String>>> withPrimary(String nodeId, Predicate<String> compare) {
        return topology -> compare.test(Jmx.primaryOf(nodeId, topology));
    }

    @FunctionalInterface
    public static interface ThrowableFunction<T, R> {
        public R apply(T var1) throws Throwable;
    }
}

