/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.client;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.util.UnmodifiableProxy;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.message.Message;

public class AmqpMessage {
    private final AmqpReceiver receiver;
    private final Message message;
    private final Delivery delivery;
    private Map<Symbol, Object> deliveryAnnotationsMap;
    private Map<Symbol, Object> messageAnnotationsMap;
    private Map<String, Object> applicationPropertiesMap;

    public AmqpMessage() {
        this.receiver = null;
        this.delivery = null;
        this.message = Proton.message();
    }

    public AmqpMessage(Message message) {
        this(null, message, null);
    }

    public AmqpMessage(AmqpReceiver receiver, Message message, Delivery delivery) {
        this.receiver = receiver;
        this.message = message;
        this.delivery = delivery;
        if (message.getMessageAnnotations() != null) {
            this.messageAnnotationsMap = message.getMessageAnnotations().getValue();
        }
        if (message.getApplicationProperties() != null) {
            this.applicationPropertiesMap = message.getApplicationProperties().getValue();
        }
        if (message.getDeliveryAnnotations() != null) {
            this.deliveryAnnotationsMap = message.getDeliveryAnnotations().getValue();
        }
    }

    public Delivery getWrappedDelivery() {
        if (this.delivery != null) {
            return UnmodifiableProxy.deliveryProxy(this.delivery);
        }
        return null;
    }

    public Message getWrappedMessage() {
        return this.message;
    }

    public AmqpReceiver getAmqpReceiver() {
        return this.receiver;
    }

    public void accept() throws Exception {
        this.accept(true);
    }

    public void accept(boolean settle) throws Exception {
        if (this.receiver == null) {
            throw new IllegalStateException("Can't accept non-received message.");
        }
        this.receiver.accept(this.delivery, settle);
    }

    public void accept(AmqpSession txnSession) throws Exception {
        this.accept(txnSession, true);
    }

    public void accept(AmqpSession txnSession, boolean settle) throws Exception {
        if (this.receiver == null) {
            throw new IllegalStateException("Can't accept non-received message.");
        }
        this.receiver.accept(this.delivery, txnSession, settle);
    }

    public void modified(Boolean deliveryFailed, Boolean undeliverableHere) throws Exception {
        if (this.receiver == null) {
            throw new IllegalStateException("Can't modify non-received message.");
        }
        this.receiver.modified(this.delivery, deliveryFailed, undeliverableHere);
    }

    public void release() throws Exception {
        if (this.receiver == null) {
            throw new IllegalStateException("Can't release non-received message.");
        }
        this.receiver.release(this.delivery);
    }

    public void reject() throws Exception {
        if (this.receiver == null) {
            throw new IllegalStateException("Can't release non-received message.");
        }
        this.receiver.reject(this.delivery);
    }

    public void setAddress(String address) {
        this.checkReadOnly();
        this.lazyCreateProperties();
        this.getWrappedMessage().setAddress(address);
    }

    public String getAddress() {
        if (this.message.getProperties() == null) {
            return null;
        }
        return this.message.getProperties().getTo();
    }

    public void setReplyToAddress(String address) {
        this.checkReadOnly();
        this.lazyCreateProperties();
        this.getWrappedMessage().setReplyTo(address);
    }

    public String getReplyToAddress() {
        if (this.message.getProperties() == null) {
            return null;
        }
        return this.message.getProperties().getReplyTo();
    }

    public void setMessageId(String messageId) {
        this.checkReadOnly();
        this.lazyCreateProperties();
        this.getWrappedMessage().setMessageId((Object)messageId);
    }

    public String getMessageId() {
        if (this.message.getProperties() == null || this.message.getProperties().getMessageId() == null) {
            return null;
        }
        return this.message.getProperties().getMessageId().toString();
    }

    public Object getRawMessageId() {
        if (this.message.getProperties() == null) {
            return null;
        }
        return this.message.getProperties().getMessageId();
    }

    public void setRawMessageId(Object messageId) {
        this.checkReadOnly();
        this.lazyCreateProperties();
        this.getWrappedMessage().setMessageId(messageId);
    }

    public void setCorrelationId(String correlationId) {
        this.checkReadOnly();
        this.lazyCreateProperties();
        this.getWrappedMessage().setCorrelationId((Object)correlationId);
    }

    public String getCorrelationId() {
        if (this.message.getProperties() == null || this.message.getProperties().getCorrelationId() == null) {
            return null;
        }
        return this.message.getProperties().getCorrelationId().toString();
    }

    public Object getRawCorrelationId() {
        if (this.message.getProperties() == null) {
            return null;
        }
        return this.message.getProperties().getCorrelationId();
    }

    public void setRawCorrelationId(Object correlationId) {
        this.checkReadOnly();
        this.lazyCreateProperties();
        this.getWrappedMessage().setCorrelationId(correlationId);
    }

    public void setGroupId(String groupId) {
        this.checkReadOnly();
        this.lazyCreateProperties();
        this.getWrappedMessage().setGroupId(groupId);
    }

    public String getGroupId() {
        if (this.message.getProperties() == null) {
            return null;
        }
        return this.message.getProperties().getGroupId();
    }

    public void setSubject(String subject) {
        this.checkReadOnly();
        this.lazyCreateProperties();
        this.getWrappedMessage().setSubject(subject);
    }

    public String getSubject() {
        if (this.message.getProperties() == null) {
            return null;
        }
        return this.message.getProperties().getSubject();
    }

    public void setDurable(boolean durable) {
        this.checkReadOnly();
        this.lazyCreateHeader();
        this.getWrappedMessage().setDurable(durable);
    }

    public boolean isDurable() {
        if (this.message.getHeader() == null || this.message.getHeader().getDurable() == null) {
            return false;
        }
        return this.message.getHeader().getDurable();
    }

    public int getDeliveryCount() {
        if (this.message.getHeader() == null || this.message.getHeader().getDeliveryCount() == null) {
            return 0;
        }
        return this.message.getHeader().getDeliveryCount().intValue();
    }

    public void setPriority(short priority) {
        this.checkReadOnly();
        this.lazyCreateHeader();
        this.getWrappedMessage().setPriority(priority);
    }

    public short getPriority() {
        return this.getWrappedMessage().getPriority();
    }

    public void setTimeToLive(long timeToLive) {
        this.checkReadOnly();
        this.lazyCreateHeader();
        this.getWrappedMessage().setTtl(timeToLive);
    }

    public long getTimeToLive() {
        return this.getWrappedMessage().getTtl();
    }

    public void setAbsoluteExpiryTime(long absoluteExpiryTime) {
        this.checkReadOnly();
        this.lazyCreateProperties();
        this.getWrappedMessage().setExpiryTime(absoluteExpiryTime);
    }

    public long getAbsoluteExpiryTime() {
        return this.getWrappedMessage().getExpiryTime();
    }

    public void setCreationTime(long creationTime) {
        this.checkReadOnly();
        this.lazyCreateProperties();
        this.getWrappedMessage().setCreationTime(creationTime);
    }

    public long getCreationTime() {
        return this.getWrappedMessage().getCreationTime();
    }

    public void setApplicationProperty(String key, Object value) {
        this.checkReadOnly();
        this.lazyCreateApplicationProperties();
        this.applicationPropertiesMap.put(key, value);
    }

    public Object getApplicationProperty(String key) {
        if (this.applicationPropertiesMap == null) {
            return null;
        }
        return this.applicationPropertiesMap.get(key);
    }

    public void setMessageAnnotation(String key, Object value) {
        this.checkReadOnly();
        this.lazyCreateMessageAnnotations();
        this.messageAnnotationsMap.put(Symbol.valueOf((String)key), value);
    }

    public Object getMessageAnnotation(String key) {
        if (this.messageAnnotationsMap == null) {
            return null;
        }
        return this.messageAnnotationsMap.get(Symbol.valueOf((String)key));
    }

    public void setDeliveryAnnotation(String key, Object value) {
        this.checkReadOnly();
        this.lazyCreateDeliveryAnnotations();
        this.deliveryAnnotationsMap.put(Symbol.valueOf((String)key), value);
    }

    public Object getDeliveryAnnotation(String key) {
        if (this.deliveryAnnotationsMap == null) {
            return null;
        }
        return this.deliveryAnnotationsMap.get(Symbol.valueOf((String)key));
    }

    public void setText(String value) throws IllegalStateException {
        this.checkReadOnly();
        AmqpValue body = new AmqpValue((Object)value);
        this.getWrappedMessage().setBody((Section)body);
    }

    public String getText() throws NoSuchElementException {
        AmqpValue value;
        Section body = this.getWrappedMessage().getBody();
        if (body instanceof AmqpValue && (value = (AmqpValue)body).getValue() instanceof String) {
            return (String)value.getValue();
        }
        throw new NoSuchElementException("Message does not contain a String body");
    }

    public void setBytes(byte[] bytes) throws IllegalStateException {
        this.checkReadOnly();
        Data body = new Data(new Binary(bytes));
        this.getWrappedMessage().setBody((Section)body);
    }

    public void setDescribedType(DescribedType described) throws IllegalStateException {
        this.checkReadOnly();
        AmqpValue body = new AmqpValue((Object)described);
        this.getWrappedMessage().setBody((Section)body);
    }

    public DescribedType getDescribedType() throws NoSuchElementException {
        DescribedType result = null;
        if (this.getWrappedMessage().getBody() == null) {
            return null;
        }
        if (this.getWrappedMessage().getBody() instanceof AmqpValue) {
            AmqpValue value = (AmqpValue)this.getWrappedMessage().getBody();
            if (value.getValue() == null) {
                result = null;
            } else if (value.getValue() instanceof DescribedType) {
                result = (DescribedType)value.getValue();
            } else {
                throw new NoSuchElementException("Message does not contain a DescribedType body");
            }
        }
        return result;
    }

    private void checkReadOnly() throws IllegalStateException {
        if (this.delivery != null) {
            throw new IllegalStateException("Message is read only.");
        }
    }

    private void lazyCreateMessageAnnotations() {
        if (this.messageAnnotationsMap == null) {
            this.messageAnnotationsMap = new HashMap<Symbol, Object>();
            this.message.setMessageAnnotations(new MessageAnnotations(this.messageAnnotationsMap));
        }
    }

    private void lazyCreateDeliveryAnnotations() {
        if (this.deliveryAnnotationsMap == null) {
            this.deliveryAnnotationsMap = new HashMap<Symbol, Object>();
            this.message.setDeliveryAnnotations(new DeliveryAnnotations(this.deliveryAnnotationsMap));
        }
    }

    private void lazyCreateApplicationProperties() {
        if (this.applicationPropertiesMap == null) {
            this.applicationPropertiesMap = new HashMap<String, Object>();
            this.message.setApplicationProperties(new ApplicationProperties(this.applicationPropertiesMap));
        }
    }

    private void lazyCreateHeader() {
        if (this.message.getHeader() == null) {
            this.message.setHeader(new Header());
        }
    }

    private void lazyCreateProperties() {
        if (this.message.getProperties() == null) {
            this.message.setProperties(new Properties());
        }
    }

    public void settle() {
        this.delivery.settle();
    }
}

