/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.client.util;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.transport.amqp.client.util.AsyncResult;
import org.apache.activemq.transport.amqp.client.util.ClientFutureSynchronization;
import org.apache.activemq.transport.amqp.client.util.IOExceptionSupport;

public class ClientFuture
implements AsyncResult {
    private final AtomicBoolean completer = new AtomicBoolean();
    private final CountDownLatch latch = new CountDownLatch(1);
    private final ClientFutureSynchronization synchronization;
    private volatile Throwable error;

    public ClientFuture() {
        this(null);
    }

    public ClientFuture(ClientFutureSynchronization synchronization) {
        this.synchronization = synchronization;
    }

    @Override
    public boolean isComplete() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public void onFailure(Throwable result) {
        if (this.completer.compareAndSet(false, true)) {
            this.error = result;
            if (this.synchronization != null) {
                this.synchronization.onPendingFailure(this.error);
            }
            this.latch.countDown();
        }
    }

    @Override
    public void onSuccess() {
        if (this.completer.compareAndSet(false, true)) {
            if (this.synchronization != null) {
                this.synchronization.onPendingSuccess();
            }
            this.latch.countDown();
        }
    }

    public void sync(long amount, TimeUnit unit) throws IOException {
        try {
            this.latch.await(amount, unit);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw IOExceptionSupport.create(e);
        }
        this.failOnError();
    }

    public void sync() throws IOException {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw IOExceptionSupport.create(e);
        }
        this.failOnError();
    }

    private void failOnError() throws IOException {
        Throwable cause = this.error;
        if (cause != null) {
            throw IOExceptionSupport.create(cause);
        }
    }
}

