/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.activemq.transport.netty.NettyTcpTransport;
import org.apache.activemq.transport.netty.NettyTransportListener;
import org.apache.activemq.transport.netty.NettyTransportOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWSTransport
extends NettyTcpTransport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String AMQP_SUB_PROTOCOL = "amqp";

    public NettyWSTransport(URI remoteLocation, NettyTransportOptions options) {
        this(null, remoteLocation, options);
    }

    public NettyWSTransport(NettyTransportListener listener, URI remoteLocation, NettyTransportOptions options) {
        super(listener, remoteLocation, options);
    }

    @Override
    public void sendVoidPromise(ByteBuf output) throws IOException {
        this.writeAndFlush(output, this.channel.voidPromise(), BinaryWebSocketFrame::new);
    }

    @Override
    public ChannelFuture send(ByteBuf output) throws IOException {
        return this.writeAndFlush(output, this.channel.newPromise(), BinaryWebSocketFrame::new);
    }

    @Override
    protected ChannelInboundHandlerAdapter createChannelHandler() {
        return new NettyWebSocketTransportHandler();
    }

    @Override
    protected void addAdditionalHandlers(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(8192)});
    }

    @Override
    protected void handleConnected(Channel channel) throws Exception {
        logger.trace("Channel has become active, awaiting WebSocket handshake! Channel is {}", (Object)channel);
    }

    private class NettyWebSocketTransportHandler
    extends NettyTcpTransport.NettyDefaultHandler<Object> {
        private final WebSocketClientHandshaker handshaker;

        NettyWebSocketTransportHandler() {
            this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)NettyWSTransport.this.getRemoteLocation(), (WebSocketVersion)WebSocketVersion.V13, (String)NettyWSTransport.this.options.getWsSubProtocol(), (boolean)true, (HttpHeaders)new DefaultHttpHeaders(), (int)NettyWSTransport.this.getMaxFrameSize());
        }

        @Override
        public void channelActive(ChannelHandlerContext context) throws Exception {
            this.handshaker.handshake(context.channel());
            super.channelActive(context);
        }

        protected void channelRead0(ChannelHandlerContext ctx, Object message) throws Exception {
            logger.trace("New data read: incoming: {}", message);
            Channel ch = ctx.channel();
            if (!this.handshaker.isHandshakeComplete()) {
                this.handshaker.finishHandshake(ch, (FullHttpResponse)message);
                logger.trace("WebSocket Client connected! {}", (Object)ctx.channel());
                NettyWSTransport.super.handleConnected(ch);
                return;
            }
            if (message instanceof FullHttpResponse) {
                FullHttpResponse response = (FullHttpResponse)message;
                throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(StandardCharsets.UTF_8) + ")");
            }
            WebSocketFrame frame = (WebSocketFrame)message;
            if (frame instanceof TextWebSocketFrame) {
                TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
                logger.warn("WebSocket Client received message: {}", (Object)textFrame.text());
                ctx.fireExceptionCaught((Throwable)new IOException("Received invalid frame over WebSocket."));
            } else if (frame instanceof BinaryWebSocketFrame) {
                BinaryWebSocketFrame binaryFrame = (BinaryWebSocketFrame)frame;
                logger.trace("WebSocket Client received data: {} bytes", (Object)binaryFrame.content().readableBytes());
                NettyWSTransport.this.listener.onData(binaryFrame.content());
            } else if (frame instanceof ContinuationWebSocketFrame) {
                ContinuationWebSocketFrame continuationFrame = (ContinuationWebSocketFrame)frame;
                logger.trace("WebSocket Client received data continuation: {} bytes", (Object)continuationFrame.content().readableBytes());
                NettyWSTransport.this.listener.onData(continuationFrame.content());
            } else if (frame instanceof PingWebSocketFrame) {
                logger.trace("WebSocket Client received ping, response with pong");
                ch.write((Object)new PongWebSocketFrame(frame.content()));
            } else if (frame instanceof CloseWebSocketFrame) {
                logger.trace("WebSocket Client received closing");
                ch.close();
            }
        }
    }
}

