/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Extension;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.annotation.AnnotationIndexUtils;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.weld.WeldLogger;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.BeanDeploymentModule;
import org.jboss.as.weld.deployment.ExplicitBeanArchiveMetadata;
import org.jboss.as.weld.deployment.ExplicitBeanArchiveMetadataContainer;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.discovery.AnnotationType;
import org.jboss.as.weld.ejb.EjbDescriptorImpl;
import org.jboss.as.weld.services.bootstrap.WeldJaxwsInjectionServices;
import org.jboss.as.weld.services.bootstrap.WeldJpaInjectionServices;
import org.jboss.as.weld.util.Indices;
import org.jboss.as.weld.util.Utils;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.modules.Module;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.injection.spi.JaxwsInjectionServices;
import org.jboss.weld.injection.spi.JpaInjectionServices;

public class BeanArchiveProcessor
implements DeploymentUnitProcessor {
    private static final DotName EXTENSION_NAME = DotName.createSimple((String)Extension.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        WeldLogger.DEPLOYMENT_LOGGER.processingWeldDeployment(deploymentUnit.getName());
        Map indexes = AnnotationIndexUtils.getAnnotationIndexes((DeploymentUnit)deploymentUnit);
        HashMap<ResourceRoot, BeanDeploymentArchiveImpl> bdaMap = new HashMap<ResourceRoot, BeanDeploymentArchiveImpl>();
        Components components = new Components(deploymentUnit, indexes);
        ResourceRootHandler handler = new ResourceRootHandler(deploymentUnit, components, indexes);
        for (ResourceRoot resourceRoot : deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS)) {
            if (!ModuleRootMarker.isModuleRoot((ResourceRoot)resourceRoot) || SubDeploymentMarker.isSubDeployment((ResourceRoot)resourceRoot) || Utils.isClassesRoot(resourceRoot)) continue;
            handler.handleResourceRoot(bdaMap, resourceRoot);
        }
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            handler.handleResourceRoot(bdaMap, handler.deploymentResourceRoot);
        }
        if (!bdaMap.containsKey(handler.deploymentResourceRoot)) {
            BeanDeploymentArchiveImpl bda = new BeanDeploymentArchiveImpl(Collections.emptySet(), BeansXml.EMPTY_BEANS_XML, handler.module, Utils.getDeploymentUnitId(deploymentUnit), BeanDeploymentArchiveImpl.BeanArchiveType.SYNTHETIC, true);
            WeldLogger.DEPLOYMENT_LOGGER.beanArchiveDiscovered(bda);
            bdaMap.put(handler.deploymentResourceRoot, bda);
        }
        deploymentUnit.putAttachment(WeldAttachments.DEPLOYMENT_ROOT_BEAN_DEPLOYMENT_ARCHIVE, bdaMap.get(handler.deploymentResourceRoot));
        for (Map.Entry entry : components.componentDescriptions.entries()) {
            BeanDeploymentArchiveImpl bda = (BeanDeploymentArchiveImpl)bdaMap.get(entry.getKey());
            String id = null;
            id = bda != null ? bda.getId() : ((BeanDeploymentArchiveImpl)deploymentUnit.getAttachment(WeldAttachments.DEPLOYMENT_ROOT_BEAN_DEPLOYMENT_ARCHIVE)).getId();
            ((ComponentDescription)entry.getValue()).setBeanDeploymentArchiveId(id);
        }
        WeldJpaInjectionServices jpaInjectionServices = new WeldJpaInjectionServices(deploymentUnit);
        WeldJaxwsInjectionServices jaxwsInjectionServices = new WeldJaxwsInjectionServices(deploymentUnit);
        BeanDeploymentModule bdm = new BeanDeploymentModule(bdaMap.values());
        bdm.addService(JpaInjectionServices.class, jpaInjectionServices);
        bdm.addService(JaxwsInjectionServices.class, jaxwsInjectionServices);
        deploymentUnit.putAttachment(WeldAttachments.BEAN_DEPLOYMENT_MODULE, (Object)bdm);
    }

    public void undeploy(DeploymentUnit context) {
        context.removeAttachment(WeldAttachments.BEAN_DEPLOYMENT_MODULE);
        context.removeAttachment(WeldAttachments.DEPLOYMENT_ROOT_BEAN_DEPLOYMENT_ARCHIVE);
    }

    private static class ResourceRootHandler {
        private final DeploymentUnit deploymentUnit;
        private final Module module;
        private final Map<ResourceRoot, Index> indexes;
        private final Components components;
        private final DeploymentReflectionIndex reflectionIndex;
        private final ResourceRoot deploymentResourceRoot;
        private final ResourceRoot classesResourceRoot;
        private final ExplicitBeanArchiveMetadataContainer explicitBeanArchives;
        private final Set<AnnotationType> beanDefiningAnnotations;

        private ResourceRootHandler(DeploymentUnit deploymentUnit, Components components, Map<ResourceRoot, Index> indexes) {
            this.deploymentUnit = deploymentUnit;
            this.explicitBeanArchives = (ExplicitBeanArchiveMetadataContainer)deploymentUnit.getAttachment(ExplicitBeanArchiveMetadataContainer.ATTACHMENT_KEY);
            this.module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
            this.indexes = indexes;
            this.components = components;
            this.reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
            this.deploymentResourceRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            this.classesResourceRoot = (ResourceRoot)deploymentUnit.getAttachment(WeldAttachments.CLASSES_RESOURCE_ROOT);
            this.beanDefiningAnnotations = (Set)Utils.getRootDeploymentUnit(deploymentUnit).getAttachment(WeldAttachments.BEAN_DEFINING_ANNOTATIONS);
        }

        private void handleResourceRoot(Map<ResourceRoot, BeanDeploymentArchiveImpl> bdaMap, ResourceRoot resourceRoot) throws DeploymentUnitProcessingException {
            BeanDeploymentArchiveImpl bda = this.processResourceRoot(resourceRoot);
            if (bda != null) {
                bdaMap.put(resourceRoot, bda);
            }
        }

        private BeanDeploymentArchiveImpl processResourceRoot(ResourceRoot resourceRoot) throws DeploymentUnitProcessingException {
            ExplicitBeanArchiveMetadata metadata = null;
            if (this.explicitBeanArchives != null) {
                metadata = this.explicitBeanArchives.getBeanArchiveMetadata().get(resourceRoot);
            }
            BeanDeploymentArchiveImpl bda = null;
            if (metadata == null || metadata.getBeansXml().getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.ANNOTATED)) {
                Index index = null;
                index = resourceRoot == this.deploymentResourceRoot && this.classesResourceRoot != null ? this.indexes.get(this.classesResourceRoot) : this.indexes.get(resourceRoot);
                if (index == null) {
                    return null;
                }
                if (metadata == null && !index.getAllKnownImplementors(EXTENSION_NAME).isEmpty()) {
                    return null;
                }
                Set<String> beans = this.getImplicitBeanClasses(index);
                if (beans.isEmpty() && this.components.ejbComponentDescriptions.get((Object)resourceRoot).isEmpty()) {
                    return null;
                }
                BeansXml beansXml = null;
                if (metadata != null) {
                    beansXml = metadata.getBeansXml();
                }
                boolean isRootBda = resourceRoot.equals(this.deploymentResourceRoot);
                bda = new BeanDeploymentArchiveImpl(beans, beansXml, this.module, resourceRoot.getRoot().getPathName(), BeanDeploymentArchiveImpl.BeanArchiveType.IMPLICIT, isRootBda);
                WeldLogger.DEPLOYMENT_LOGGER.beanArchiveDiscovered(bda);
            } else {
                if (metadata.getBeansXml().getBeanDiscoveryMode().equals((Object)BeanDiscoveryMode.NONE)) {
                    return null;
                }
                boolean isRootBda = metadata.isDeploymentRoot();
                bda = this.createExplicitBeanDeploymentArchive(this.indexes.get(metadata.getResourceRoot()), metadata, isRootBda);
                WeldLogger.DEPLOYMENT_LOGGER.beanArchiveDiscovered(bda);
            }
            Collection ejbComponents = this.components.ejbComponentDescriptions.get((Object)resourceRoot);
            for (EJBComponentDescription ejb : ejbComponents) {
                bda.addEjbDescriptor(new EjbDescriptorImpl(ejb, bda, this.reflectionIndex));
                bda.addBeanClass(ejb.getComponentClassName());
            }
            return bda;
        }

        private Set<String> getImplicitBeanClasses(Index index) {
            HashSet<String> implicitBeanClasses = new HashSet<String>();
            for (AnnotationType beanDefiningAnnotation : this.beanDefiningAnnotations) {
                List annotationInstances = index.getAnnotations(beanDefiningAnnotation.getName());
                implicitBeanClasses.addAll(Lists.transform(Indices.getAnnotatedClasses(annotationInstances), Indices.CLASS_INFO_TO_FQCN));
            }
            return implicitBeanClasses;
        }

        private BeanDeploymentArchiveImpl createExplicitBeanDeploymentArchive(Index index, ExplicitBeanArchiveMetadata beanArchiveMetadata, boolean root) throws DeploymentUnitProcessingException {
            HashSet<String> classNames = new HashSet<String>();
            if (index != null) {
                classNames.addAll(Collections2.transform((Collection)index.getKnownClasses(), Indices.CLASS_INFO_TO_FQCN));
            }
            String beanArchiveId = null;
            beanArchiveId = beanArchiveMetadata.getResourceRoot() == null ? Utils.getDeploymentUnitId(this.deploymentUnit) : beanArchiveMetadata.getResourceRoot().getRoot().getPathName();
            return new BeanDeploymentArchiveImpl(classNames, beanArchiveMetadata.getBeansXml(), this.module, beanArchiveId, BeanDeploymentArchiveImpl.BeanArchiveType.EXPLICIT, root);
        }
    }

    private static class Components {
        private final Multimap<ResourceRoot, ComponentDescription> componentDescriptions = HashMultimap.create();
        private final Multimap<ResourceRoot, EJBComponentDescription> ejbComponentDescriptions = HashMultimap.create();

        public Components(DeploymentUnit deploymentUnit, Map<ResourceRoot, Index> indexes) {
            for (ComponentDescription component : ((EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION)).getComponentDescriptions()) {
                ResourceRoot resourceRoot = null;
                DotName componentClassName = DotName.createSimple((String)component.getComponentClassName());
                for (Map.Entry<ResourceRoot, Index> entry : indexes.entrySet()) {
                    Index index = entry.getValue();
                    if (index == null || index.getClassByName(componentClassName) == null) continue;
                    resourceRoot = entry.getKey();
                    break;
                }
                if (resourceRoot == null || Utils.isClassesRoot(resourceRoot)) {
                    resourceRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
                }
                this.componentDescriptions.put((Object)resourceRoot, (Object)component);
                if (!(component instanceof EJBComponentDescription)) continue;
                this.ejbComponentDescriptions.put((Object)resourceRoot, (Object)((EJBComponentDescription)component));
            }
        }
    }
}

