/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.weld.CdiAnnotations;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.discovery.AnnotationType;
import org.jboss.as.weld.util.Indices;
import org.jboss.jandex.DotName;

public class BeanDefiningAnnotationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() != null) {
            return;
        }
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        ImmutableSet.Builder beanDefiningAnnotations = ImmutableSet.builder();
        beanDefiningAnnotations.addAll(CdiAnnotations.BUILT_IN_SCOPES);
        beanDefiningAnnotations.addAll(this.getAnnotationsAnnotatedWith(index, CdiAnnotations.NORM_SCOPE.getDotName()));
        beanDefiningAnnotations.addAll(this.getAnnotationsAnnotatedWith(index, CdiAnnotations.SCOPE));
        deploymentUnit.putAttachment(WeldAttachments.BEAN_DEFINING_ANNOTATIONS, (Object)beanDefiningAnnotations.build());
    }

    private Collection<AnnotationType> getAnnotationsAnnotatedWith(CompositeIndex index, DotName annotationName) {
        return Collections2.transform((Collection)Collections2.filter(Indices.getAnnotatedClasses(index.getAnnotations(annotationName)), Indices.ANNOTATION_PREDICATE), AnnotationType.FOR_CLASSINFO);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

