/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.ejb.TimerService;
import javax.ejb.spi.HandleDelegate;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.weld.WeldLogger;
import org.jboss.as.weld.WeldMessages;
import org.jboss.as.weld.services.bootstrap.AbstractResourceInjectionServices;
import org.jboss.as.weld.util.ResourceInjectionUtilities;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.injection.spi.helpers.SimpleResourceReference;
import org.omg.CORBA.ORB;

public class WeldResourceInjectionServices
extends AbstractResourceInjectionServices
implements ResourceInjectionServices {
    private static final String USER_TRANSACTION_LOCATION = "java:comp/UserTransaction";
    private static final String USER_TRANSACTION_CLASS_NAME = "javax.transaction.UserTransaction";
    private static final String HANDLE_DELEGATE_CLASS_NAME = "javax.ejb.spi.HandleDelegate";
    private static final String TIMER_SERVICE_CLASS_NAME = "javax.ejb.TimerService";
    private static final String ORB_CLASS_NAME = "org.omg.CORBA.ORB";
    private final Context context;

    protected static String getEJBResourceName(InjectionPoint injectionPoint, String proposedName) {
        if (injectionPoint.getType() instanceof Class) {
            Class type = (Class)injectionPoint.getType();
            if (USER_TRANSACTION_CLASS_NAME.equals(type.getName())) {
                return USER_TRANSACTION_LOCATION;
            }
            if (HANDLE_DELEGATE_CLASS_NAME.equals(type.getName())) {
                WeldLogger.ROOT_LOGGER.injectionTypeNotValue(HandleDelegate.class, injectionPoint.getMember());
                return proposedName;
            }
            if (ORB_CLASS_NAME.equals(type.getName())) {
                WeldLogger.ROOT_LOGGER.injectionTypeNotValue(ORB.class, injectionPoint.getMember());
                return proposedName;
            }
            if (TIMER_SERVICE_CLASS_NAME.equals(type.getName())) {
                WeldLogger.ROOT_LOGGER.injectionTypeNotValue(TimerService.class, injectionPoint.getMember());
                return proposedName;
            }
        }
        return proposedName;
    }

    public WeldResourceInjectionServices(ServiceRegistry serviceRegistry, EEModuleDescription moduleDescription) {
        super(serviceRegistry, moduleDescription);
        try {
            this.context = new InitialContext();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getResourceName(InjectionPoint injectionPoint) {
        Resource resource = (Resource)ResourceInjectionUtilities.getResourceAnnotated(injectionPoint).getAnnotation(Resource.class);
        String mappedName = resource.mappedName();
        String lookup = resource.lookup();
        if (!lookup.isEmpty()) {
            return lookup;
        }
        if (!mappedName.isEmpty()) {
            return mappedName;
        }
        String proposedName = ResourceInjectionUtilities.getResourceName(injectionPoint);
        return WeldResourceInjectionServices.getEJBResourceName(injectionPoint, proposedName);
    }

    public ResourceReferenceFactory<Object> registerResourceInjectionPoint(final InjectionPoint injectionPoint) {
        String result = this.getResourceName(injectionPoint);
        if (this.isKnownNamespace(result)) {
            return this.handleServiceLookup(result, injectionPoint);
        }
        return new ResourceReferenceFactory<Object>(){

            public ResourceReference<Object> createResource() {
                return new SimpleResourceReference(WeldResourceInjectionServices.this.resolveResource(injectionPoint));
            }
        };
    }

    public ResourceReferenceFactory<Object> registerResourceInjectionPoint(final String jndiName, final String mappedName) {
        String result = ResourceInjectionUtilities.getResourceName(jndiName, mappedName);
        if (this.isKnownNamespace(result)) {
            return this.handleServiceLookup(result, null);
        }
        return new ResourceReferenceFactory<Object>(){

            public ResourceReference<Object> createResource() {
                return new SimpleResourceReference(WeldResourceInjectionServices.this.resolveResource(jndiName, mappedName));
            }
        };
    }

    private boolean isKnownNamespace(String name) {
        return name.startsWith("java:global") || name.startsWith("java:app") || name.startsWith("java:module") || name.startsWith("java:comp") || name.startsWith("java:jboss");
    }

    public void cleanup() {
    }

    @Override
    protected ContextNames.BindInfo getBindInfo(String result) {
        return ContextNames.bindInfoForEnvEntry((String)this.moduleDescription.getApplicationName(), (String)this.moduleDescription.getModuleName(), (String)this.moduleDescription.getModuleName(), (boolean)false, (String)result);
    }

    public Object resolveResource(InjectionPoint injectionPoint) {
        if (!injectionPoint.getAnnotated().isAnnotationPresent(Resource.class)) {
            throw WeldMessages.MESSAGES.annotationNotFound(Resource.class, injectionPoint.getMember());
        }
        if (injectionPoint.getMember() instanceof Method && ((Method)injectionPoint.getMember()).getParameterTypes().length != 1) {
            throw WeldMessages.MESSAGES.injectionPointNotAJavabean((Method)injectionPoint.getMember());
        }
        String name = this.getResourceName(injectionPoint);
        try {
            return this.context.lookup(name);
        }
        catch (NamingException e) {
            throw WeldMessages.MESSAGES.coundNotFindResource(name, e);
        }
    }

    public Object resolveResource(String jndiName, String mappedName) {
        String name = ResourceInjectionUtilities.getResourceName(jndiName, mappedName);
        try {
            return this.context.lookup(name);
        }
        catch (NamingException e) {
            throw WeldMessages.MESSAGES.coundNotFindResource(name, e);
        }
    }
}

