/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.api.jms;

import javax.jms.Queue;
import javax.jms.Topic;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.jms.JMSFactoryType;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.client.HornetQJMSConnectionFactory;
import org.hornetq.jms.client.HornetQQueueConnectionFactory;
import org.hornetq.jms.client.HornetQTopicConnectionFactory;
import org.hornetq.jms.client.HornetQXAConnectionFactory;
import org.hornetq.jms.client.HornetQXAQueueConnectionFactory;
import org.hornetq.jms.client.HornetQXATopicConnectionFactory;

public class HornetQJMSClient {
    public static HornetQConnectionFactory createConnectionFactoryWithHA(DiscoveryGroupConfiguration groupConfiguration, JMSFactoryType jmsFactoryType) {
        HornetQConnectionFactory factory = null;
        if (jmsFactoryType.equals((Object)JMSFactoryType.CF)) {
            factory = new HornetQJMSConnectionFactory(true, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.QUEUE_CF)) {
            factory = new HornetQQueueConnectionFactory(true, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.TOPIC_CF)) {
            factory = new HornetQTopicConnectionFactory(true, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.XA_CF)) {
            factory = new HornetQXAConnectionFactory(true, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.QUEUE_XA_CF)) {
            factory = new HornetQXAQueueConnectionFactory(true, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.TOPIC_XA_CF)) {
            factory = new HornetQXATopicConnectionFactory(true, groupConfiguration);
        }
        return factory;
    }

    public static HornetQConnectionFactory createConnectionFactoryWithoutHA(DiscoveryGroupConfiguration groupConfiguration, JMSFactoryType jmsFactoryType) {
        HornetQConnectionFactory factory = null;
        if (jmsFactoryType.equals((Object)JMSFactoryType.CF)) {
            factory = new HornetQJMSConnectionFactory(false, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.QUEUE_CF)) {
            factory = new HornetQQueueConnectionFactory(false, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.TOPIC_CF)) {
            factory = new HornetQTopicConnectionFactory(false, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.XA_CF)) {
            factory = new HornetQXAConnectionFactory(false, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.QUEUE_XA_CF)) {
            factory = new HornetQXAQueueConnectionFactory(false, groupConfiguration);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.TOPIC_XA_CF)) {
            factory = new HornetQXATopicConnectionFactory(false, groupConfiguration);
        }
        return factory;
    }

    public static HornetQConnectionFactory createConnectionFactoryWithHA(JMSFactoryType jmsFactoryType, TransportConfiguration ... initialServers) {
        HornetQConnectionFactory factory = null;
        if (jmsFactoryType.equals((Object)JMSFactoryType.CF)) {
            factory = new HornetQJMSConnectionFactory(true, initialServers);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.QUEUE_CF)) {
            factory = new HornetQQueueConnectionFactory(true, initialServers);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.TOPIC_CF)) {
            factory = new HornetQTopicConnectionFactory(true, initialServers);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.XA_CF)) {
            factory = new HornetQXAConnectionFactory(true, initialServers);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.QUEUE_XA_CF)) {
            factory = new HornetQXAQueueConnectionFactory(true, initialServers);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.TOPIC_XA_CF)) {
            factory = new HornetQXATopicConnectionFactory(true, initialServers);
        }
        return factory;
    }

    public static HornetQConnectionFactory createConnectionFactoryWithoutHA(JMSFactoryType jmsFactoryType, TransportConfiguration ... transportConfigurations) {
        HornetQConnectionFactory factory = null;
        if (jmsFactoryType.equals((Object)JMSFactoryType.CF)) {
            factory = new HornetQJMSConnectionFactory(false, transportConfigurations);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.QUEUE_CF)) {
            factory = new HornetQQueueConnectionFactory(false, transportConfigurations);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.TOPIC_CF)) {
            factory = new HornetQTopicConnectionFactory(false, transportConfigurations);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.XA_CF)) {
            factory = new HornetQXAConnectionFactory(false, transportConfigurations);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.QUEUE_XA_CF)) {
            factory = new HornetQXAQueueConnectionFactory(false, transportConfigurations);
        } else if (jmsFactoryType.equals((Object)JMSFactoryType.TOPIC_XA_CF)) {
            factory = new HornetQXATopicConnectionFactory(false, transportConfigurations);
        }
        return factory;
    }

    public static Topic createTopic(String name) {
        return HornetQDestination.createTopic(name);
    }

    public static Queue createQueue(String name) {
        return HornetQDestination.createQueue(name);
    }

    private HornetQJMSClient() {
    }
}

