/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl;

import java.util.EnumSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQInterruptedException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.core.client.HornetQClientLogger;
import org.hornetq.core.client.HornetQClientMessageBundle;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.CommandConfirmationHandler;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.wireformat.HornetQExceptionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.PacketsConfirmedMessage;
import org.hornetq.spi.core.protocol.RemotingConnection;

public final class ChannelImpl
implements Channel {
    private static final boolean isTrace = HornetQClientLogger.LOGGER.isTraceEnabled();
    private volatile long id;
    private ChannelHandler handler;
    private Packet response;
    private final Queue<Packet> resendCache;
    private volatile int firstStoredCommandID;
    private final AtomicInteger lastConfirmedCommandID = new AtomicInteger(-1);
    private volatile CoreRemotingConnection connection;
    private volatile boolean closed;
    private final Lock lock = new ReentrantLock();
    private final Condition sendCondition = this.lock.newCondition();
    private final Condition failoverCondition = this.lock.newCondition();
    private final Object sendLock = new Object();
    private final Object sendBlockingLock = new Object();
    private boolean failingOver;
    private final int confWindowSize;
    private int receivedBytes;
    private CommandConfirmationHandler commandConfirmationHandler;
    private volatile boolean transferring;
    private final List<Interceptor> interceptors;

    public ChannelImpl(CoreRemotingConnection connection, long id, int confWindowSize, List<Interceptor> interceptors) {
        this.connection = connection;
        this.id = id;
        this.confWindowSize = confWindowSize;
        this.resendCache = confWindowSize != -1 ? new ConcurrentLinkedQueue<Packet>() : null;
        this.interceptors = interceptors;
    }

    @Override
    public boolean supports(byte packetType) {
        int version = this.connection.getClientVersion();
        switch (packetType) {
            case 114: {
                return version >= 122;
            }
        }
        return true;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public int getLastConfirmedCommandID() {
        return this.lastConfirmedCommandID.get();
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    @Override
    public int getConfirmationWindowSize() {
        return this.confWindowSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnBlocking() {
        this.lock.lock();
        try {
            this.response = new HornetQExceptionMessage(HornetQClientMessageBundle.BUNDLE.unblockingACall());
            this.sendCondition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean sendAndFlush(Packet packet) {
        return this.send(packet, true, false);
    }

    @Override
    public boolean send(Packet packet) {
        return this.send(packet, false, false);
    }

    @Override
    public boolean sendBatched(Packet packet) {
        return this.send(packet, false, true);
    }

    @Override
    public void setTransferring(boolean transferring) {
        this.transferring = transferring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(Packet packet, boolean flush, boolean batch) {
        if (ChannelImpl.invokeInterceptors(packet, this.interceptors, this.connection) != null) {
            return false;
        }
        Object object = this.sendLock;
        synchronized (object) {
            packet.setChannelID(this.id);
            if (isTrace) {
                HornetQClientLogger.LOGGER.trace("Sending packet nonblocking " + packet + " on channeID=" + this.id);
            }
            HornetQBuffer buffer = packet.encode(this.connection);
            this.lock.lock();
            try {
                if (this.failingOver) {
                    try {
                        this.failoverCondition.await(10000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        throw new HornetQInterruptedException(e);
                    }
                }
                if (this.transferring) {
                    throw new IllegalStateException("Cannot send a packet while channel is doing failover");
                }
                if (this.resendCache != null && packet.isRequiresConfirmations()) {
                    this.resendCache.add(packet);
                }
            }
            finally {
                this.lock.unlock();
            }
            if (isTrace) {
                HornetQClientLogger.LOGGER.trace("Writing buffer for channelID=" + this.id);
            }
            this.connection.getTransportConnection().write(buffer, flush, batch);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Packet sendBlocking(Packet packet, byte expectedPacket) throws HornetQException {
        String interceptionResult = ChannelImpl.invokeInterceptors(packet, this.interceptors, this.connection);
        if (interceptionResult != null) {
            throw HornetQClientMessageBundle.BUNDLE.interceptorRejectedPacket(interceptionResult);
        }
        if (this.closed) {
            throw HornetQClientMessageBundle.BUNDLE.connectionDestroyed();
        }
        if (this.connection.getBlockingCallTimeout() == -1L) {
            throw new IllegalStateException("Cannot do a blocking call timeout on a server side connection");
        }
        Object object = this.sendBlockingLock;
        synchronized (object) {
            packet.setChannelID(this.id);
            HornetQBuffer buffer = packet.encode(this.connection);
            this.lock.lock();
            try {
                long now;
                if (this.failingOver) {
                    try {
                        if (this.connection.getBlockingCallFailoverTimeout() < 0L) {
                            while (this.failingOver) {
                                this.failoverCondition.await();
                            }
                        } else if (!this.failoverCondition.await(this.connection.getBlockingCallFailoverTimeout(), TimeUnit.MILLISECONDS)) {
                            HornetQClientLogger.LOGGER.debug("timed-out waiting for failover condition");
                        }
                    }
                    catch (InterruptedException e) {
                        throw new HornetQInterruptedException(e);
                    }
                }
                this.response = null;
                if (this.resendCache != null && packet.isRequiresConfirmations()) {
                    this.resendCache.add(packet);
                }
                this.connection.getTransportConnection().write(buffer, false, false);
                long start = System.currentTimeMillis();
                for (long toWait = this.connection.getBlockingCallTimeout(); !this.closed && (this.response == null || this.response.getType() != 20 && this.response.getType() != expectedPacket) && toWait > 0L; toWait -= now - start) {
                    try {
                        this.sendCondition.await(toWait, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        throw new HornetQInterruptedException(e);
                    }
                    if (this.response != null && this.response.getType() != 20 && this.response.getType() != expectedPacket) {
                        HornetQClientLogger.LOGGER.packetOutOfOrder(this.response, new Exception("trace"));
                    }
                    if (this.closed) break;
                    now = System.currentTimeMillis();
                    start = now;
                }
                if (this.response == null) {
                    throw HornetQClientMessageBundle.BUNDLE.timedOutSendingPacket(packet.getType());
                }
                if (this.response.getType() == 20) {
                    HornetQExceptionMessage mem = (HornetQExceptionMessage)this.response;
                    HornetQException e = mem.getException();
                    e.fillInStackTrace();
                    throw e;
                }
            }
            finally {
                this.lock.unlock();
            }
            return this.response;
        }
    }

    public static String invokeInterceptors(Packet packet, List<Interceptor> interceptors, RemotingConnection connection) {
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors) {
                try {
                    boolean callNext = interceptor.intercept(packet, connection);
                    if (HornetQClientLogger.LOGGER.isDebugEnabled()) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("Invocation of interceptor ").append(interceptor.getClass().getName()).append(" on ").append(packet).append(" returned ").append(callNext);
                        HornetQClientLogger.LOGGER.debug(msg.toString());
                    }
                    if (callNext) continue;
                    return interceptor.getClass().getName();
                }
                catch (Throwable e) {
                    HornetQClientLogger.LOGGER.errorCallingInterceptor(e, interceptor);
                }
            }
        }
        return null;
    }

    @Override
    public void setCommandConfirmationHandler(CommandConfirmationHandler handler) {
        if (this.confWindowSize < 0) {
            String msg = "You can't set confirmationHandler on a connection with confirmation-window-size < 0. Look at the documentation for more information.";
            throw new IllegalStateException("You can't set confirmationHandler on a connection with confirmation-window-size < 0. Look at the documentation for more information.");
        }
        this.commandConfirmationHandler = handler;
    }

    @Override
    public void setHandler(ChannelHandler handler) {
        this.handler = handler;
    }

    @Override
    public ChannelHandler getHandler() {
        return this.handler;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (!this.connection.isDestroyed() && !this.connection.removeChannel(this.id)) {
            throw HornetQClientMessageBundle.BUNDLE.noChannelToClose(this.id);
        }
        if (this.failingOver) {
            this.unlock();
        }
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferConnection(CoreRemotingConnection newConnection) {
        Object object = this.connection.getTransferLock();
        synchronized (object) {
            this.connection.removeChannel(this.id);
            CoreRemotingConnection rnewConnection = newConnection;
            rnewConnection.putChannel(this.id, this);
            this.connection = rnewConnection;
            this.transferring = true;
        }
    }

    @Override
    public void replayCommands(int otherLastConfirmedCommandID) {
        if (this.resendCache != null) {
            if (isTrace) {
                HornetQClientLogger.LOGGER.trace("Replaying commands on channelID=" + this.id);
            }
            this.clearUpTo(otherLastConfirmedCommandID);
            for (Packet packet : this.resendCache) {
                this.doWrite(packet);
            }
        }
    }

    @Override
    public void lock() {
        this.lock.lock();
        this.failingOver = true;
        this.lock.unlock();
    }

    @Override
    public void unlock() {
        this.lock.lock();
        this.failingOver = false;
        this.failoverCondition.signalAll();
        this.lock.unlock();
    }

    @Override
    public CoreRemotingConnection getConnection() {
        return this.connection;
    }

    @Override
    public synchronized void flushConfirmations() {
        if (this.resendCache != null && this.receivedBytes != 0) {
            this.receivedBytes = 0;
            PacketsConfirmedMessage confirmed = new PacketsConfirmedMessage(this.lastConfirmedCommandID.get());
            confirmed.setChannelID(this.id);
            this.doWrite(confirmed);
        }
    }

    @Override
    public void confirm(Packet packet) {
        if (this.resendCache != null && packet.isRequiresConfirmations()) {
            this.lastConfirmedCommandID.incrementAndGet();
            this.receivedBytes += packet.getPacketSize();
            if (this.receivedBytes >= this.confWindowSize) {
                this.receivedBytes = 0;
                PacketsConfirmedMessage confirmed = new PacketsConfirmedMessage(this.lastConfirmedCommandID.get());
                confirmed.setChannelID(this.id);
                this.doWrite(confirmed);
            }
        }
    }

    @Override
    public void clearCommands() {
        if (this.resendCache != null) {
            this.lastConfirmedCommandID.set(-1);
            this.firstStoredCommandID = 0;
            this.resendCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePacket(Packet packet) {
        if (packet.getType() == 22) {
            if (this.resendCache != null) {
                PacketsConfirmedMessage msg = (PacketsConfirmedMessage)packet;
                this.clearUpTo(msg.getCommandID());
            }
            if (!this.connection.isClient()) {
                this.handler.handlePacket(packet);
            }
            return;
        }
        if (packet.isResponse()) {
            this.confirm(packet);
            this.lock.lock();
            try {
                this.response = packet;
                this.sendCondition.signal();
            }
            finally {
                this.lock.unlock();
            }
        } else if (this.handler != null) {
            this.handler.handlePacket(packet);
        }
    }

    private void doWrite(Packet packet) {
        HornetQBuffer buffer = packet.encode(this.connection);
        this.connection.getTransportConnection().write(buffer, false, false);
    }

    private void clearUpTo(int lastReceivedCommandID) {
        int numberToClear = 1 + lastReceivedCommandID - this.firstStoredCommandID;
        if (numberToClear == -1) {
            throw HornetQClientMessageBundle.BUNDLE.invalidCommandID(lastReceivedCommandID);
        }
        int sizeToFree = 0;
        for (int i = 0; i < numberToClear; ++i) {
            Packet packet = this.resendCache.poll();
            if (packet == null) {
                HornetQClientLogger.LOGGER.cannotFindPacketToClear(lastReceivedCommandID, this.firstStoredCommandID);
                this.firstStoredCommandID = lastReceivedCommandID + 1;
                return;
            }
            if (packet.getType() != 22) {
                sizeToFree += packet.getPacketSize();
            }
            if (this.commandConfirmationHandler == null) continue;
            this.commandConfirmationHandler.commandConfirmed(packet);
        }
        this.firstStoredCommandID += numberToClear;
    }

    public String toString() {
        return "Channel[id=" + CHANNEL_ID.idToString(this.id) + ", handler=" + this.handler + "]";
    }

    public static enum CHANNEL_ID {
        PING(0L),
        SESSION(1L),
        REPLICATION(2L),
        USER(10L);

        public final long id;

        private CHANNEL_ID(long id) {
            this.id = id;
        }

        protected static String idToString(long code) {
            for (CHANNEL_ID channel : EnumSet.allOf(CHANNEL_ID.class)) {
                if (channel.id != code) continue;
                return channel.toString();
            }
            return Long.toString(code);
        }
    }
}

