/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import javax.security.auth.callback.CallbackHandler;
import org.jboss.ejb.client.DefaultCallbackHandler;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Property;
import org.xnio.Sequence;

public class RemotingConnectionUtil {
    private static final String JBOSS_SASL_LOCAL_USER_QUIET_AUTH_PROP = "jboss.sasl.local-user.quiet-auth";

    public static OptionMap addSilentLocalAuthOptionsIfApplicable(CallbackHandler callbackHandler, OptionMap connectionCreationOptions) {
        if (!(callbackHandler instanceof DefaultCallbackHandler)) {
            return connectionCreationOptions;
        }
        Sequence<Property> existingSaslProps = connectionCreationOptions.get(Options.SASL_PROPERTIES);
        if (existingSaslProps != null) {
            for (Property prop : existingSaslProps) {
                if (!prop.getKey().equals(JBOSS_SASL_LOCAL_USER_QUIET_AUTH_PROP)) continue;
                return connectionCreationOptions;
            }
            existingSaslProps.add(Property.of(JBOSS_SASL_LOCAL_USER_QUIET_AUTH_PROP, "true"));
            return connectionCreationOptions;
        }
        OptionMap.Builder updatedConnectionOptsBuilder = OptionMap.builder().addAll(connectionCreationOptions);
        updatedConnectionOptsBuilder.set(Options.SASL_PROPERTIES, Sequence.of(new Property[]{Property.of(JBOSS_SASL_LOCAL_USER_QUIET_AUTH_PROP, "true")}));
        return updatedConnectionOptsBuilder.getMap();
    }
}

