/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.Digest;
import org.jgroups.util.StateTransferResult;
import org.jgroups.util.Util;

@MBean(description="State transfer protocol based on byte array transfer")
public class STATE_TRANSFER
extends Protocol {
    private long start;
    private long stop;
    private final AtomicInteger num_state_reqs = new AtomicInteger(0);
    private final AtomicLong num_bytes_sent = new AtomicLong(0L);
    private double avg_state_size = 0.0;
    private Address local_addr = null;
    private final List<Address> members = new ArrayList<Address>();
    private final Set<Address> state_requesters = new HashSet<Address>();
    private volatile boolean waiting_for_state_response = false;
    private boolean flushProtocolInStack = false;
    @ManagedAttribute(description="whether or not the barrier is closed")
    protected AtomicBoolean barrier_closed = new AtomicBoolean(false);

    @ManagedAttribute
    public int getNumberOfStateRequests() {
        return this.num_state_reqs.get();
    }

    @ManagedAttribute
    public long getNumberOfStateBytesSent() {
        return this.num_bytes_sent.get();
    }

    @ManagedAttribute
    public double getAverageStateSize() {
        return this.avg_state_size;
    }

    @Override
    public List<Integer> requiredDownServices() {
        ArrayList<Integer> retval = new ArrayList<Integer>();
        retval.add(39);
        retval.add(42);
        return retval;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_state_reqs.set(0);
        this.num_bytes_sent.set(0L);
        this.avg_state_size = 0.0;
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void start() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("state_transfer", Boolean.TRUE);
        map.put("protocol_class", this.getClass().getName());
        this.up_prot.up(new Event(56, map));
    }

    @Override
    public void stop() {
        super.stop();
        this.waiting_for_state_response = false;
    }

    @ManagedOperation(description="Closes BARRIER and suspends STABLE")
    public void closeBarrierAndSuspendStable() {
        if (!this.isDigestNeeded() || !this.barrier_closed.compareAndSet(false, true)) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": sending down CLOSE_BARRIER and SUSPEND_STABLE");
        }
        this.down_prot.down(new Event(76));
        this.down_prot.down(new Event(65));
    }

    @ManagedOperation(description="Opens BARRIER and resumes STABLE")
    public void openBarrierAndResumeStable() {
        if (!this.isDigestNeeded() || !this.barrier_closed.compareAndSet(true, false)) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": sending down OPEN_BARRIER and RESUME_STABLE");
        }
        this.down_prot.down(new Event(77));
        this.down_prot.down(new Event(66));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                StateHeader hdr = (StateHeader)msg.getHeader(this.id);
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        this.handleStateReq(msg.getSrc());
                        break;
                    }
                    case 2: {
                        this.closeBarrierAndSuspendStable();
                        try {
                            this.handleStateRsp(hdr, msg.getBuffer());
                            break;
                        }
                        catch (Throwable t) {
                            this.handleException(t);
                            break;
                        }
                        finally {
                            this.openBarrierAndResumeStable();
                        }
                    }
                    case 3: {
                        this.handleException((Throwable)msg.getObject());
                        break;
                    }
                    default: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error("type " + hdr.type + " not known in StateHeader");
                    }
                }
                return null;
            }
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 56: {
                Map config = (Map)evt.getArg();
                if (config == null || !config.containsKey("state_transfer")) break;
                this.log.error("Protocol stack cannot contain two state transfer protocols. Remove either one of them");
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 19: {
                Address target;
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                if (info.target == null) {
                    target = this.determineCoordinator();
                } else {
                    target = info.target;
                    if (target.equals(this.local_addr)) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error(this.local_addr + ": cannot fetch state from myself !");
                        }
                        target = null;
                    }
                }
                if (target == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(this.local_addr + ": first member (no state)");
                    }
                    this.up_prot.up(new Event(20, new StateTransferInfo()));
                } else {
                    Message state_req = new Message(target).putHeader(this.id, new StateHeader(1));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(this.local_addr + ": asking " + target + " for state");
                    }
                    this.waiting_for_state_response = true;
                    this.start = System.currentTimeMillis();
                    this.down_prot.down(new Event(1, state_req));
                }
                return null;
            }
            case 56: {
                Map config = (Map)evt.getArg();
                if (config == null || !config.containsKey("flush_supported")) break;
                this.flushProtocolInStack = true;
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    private boolean isDigestNeeded() {
        return !this.flushProtocolInStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address determineCoordinator() {
        List<Address> list = this.members;
        synchronized (list) {
            for (Address member : this.members) {
                if (this.local_addr.equals(member)) continue;
                return member;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleViewChange(View v) {
        Address old_coord;
        List<Address> new_members = v.getMembers();
        boolean send_up_exception = false;
        Collection<Address> collection = this.members;
        synchronized (collection) {
            old_coord = !this.members.isEmpty() ? this.members.get(0) : null;
            this.members.clear();
            this.members.addAll(new_members);
            if (this.waiting_for_state_response && old_coord != null && !this.members.contains(old_coord)) {
                send_up_exception = true;
            }
        }
        if (send_up_exception) {
            if (this.log.isWarnEnabled()) {
                this.log.warn(this.local_addr + ": discovered that the state provider (" + old_coord + ") left");
            }
            this.waiting_for_state_response = false;
            EOFException ex = new EOFException("state provider " + old_coord + " left");
            this.up_prot.up(new Event(20, new StateTransferResult(ex)));
            this.openBarrierAndResumeStable();
        }
        collection = this.state_requesters;
        synchronized (collection) {
            boolean was_empty = this.state_requesters.isEmpty();
            this.state_requesters.removeAll(new_members);
            if (!was_empty && this.state_requesters.isEmpty()) {
                this.openBarrierAndResumeStable();
            }
        }
    }

    protected void handleException(Throwable exception) {
        this.openBarrierAndResumeStable();
        this.up_prot.up(new Event(20, new StateTransferResult(exception)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStateReq(Address requester) {
        if (requester == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.local_addr + ": received state request from " + requester);
        }
        Set<Address> set = this.state_requesters;
        synchronized (set) {
            if (this.state_requesters.isEmpty()) {
                this.closeBarrierAndSuspendStable();
            }
            this.state_requesters.add(requester);
            Digest digest = null;
            try {
                if (this.isDigestNeeded()) {
                    digest = (Digest)this.down_prot.down(new Event(39));
                }
                this.getStateFromApplication(requester, digest);
            }
            catch (Throwable t) {
                this.sendException(requester, t);
            }
            finally {
                if (this.state_requesters.remove(requester) && this.state_requesters.isEmpty()) {
                    this.openBarrierAndResumeStable();
                }
            }
        }
    }

    protected void getStateFromApplication(Address requester, Digest digest) {
        StateTransferInfo rsp = (StateTransferInfo)this.up_prot.up(new Event(17));
        byte[] state = rsp.state;
        if (this.stats) {
            this.num_state_reqs.incrementAndGet();
            if (state != null) {
                this.num_bytes_sent.addAndGet(state.length);
            }
            this.avg_state_size = this.num_bytes_sent.doubleValue() / this.num_state_reqs.doubleValue();
        }
        Message state_rsp = new Message(requester, state).putHeader(this.id, new StateHeader(2, digest));
        if (this.log.isTraceEnabled()) {
            int length;
            int n = length = state != null ? state.length : 0;
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": sending state to " + state_rsp.getDest() + " (size=" + Util.printBytes(length) + ")");
            }
        }
        this.down_prot.down(new Event(1, state_rsp));
    }

    protected void sendException(Address requester, Throwable exception) {
        try {
            Message ex_msg = new Message(requester, exception).putHeader(this.getId(), new StateHeader(3));
            this.down(new Event(1, ex_msg));
        }
        catch (Throwable t) {
            this.log.error(this.local_addr + ": failed sending exception " + exception.toString() + " to " + requester);
        }
    }

    private void handleStateRsp(StateHeader hdr, byte[] state) {
        Digest tmp_digest = hdr.my_digest;
        boolean digest_needed = this.isDigestNeeded();
        this.waiting_for_state_response = false;
        if (digest_needed && tmp_digest != null) {
            this.down_prot.down(new Event(42, tmp_digest));
        }
        this.stop = System.currentTimeMillis();
        this.log.debug(this.local_addr + ": received state, size=" + (state == null ? "0" : Util.printBytes(state.length)) + ", time=" + (this.stop - this.start) + " milliseconds");
        StateTransferResult result = new StateTransferResult(state);
        this.up_prot.up(new Event(20, result));
    }

    public static class StateHeader
    extends Header {
        public static final byte STATE_REQ = 1;
        public static final byte STATE_RSP = 2;
        public static final byte STATE_EX = 3;
        protected byte type = 0;
        protected Digest my_digest;

        public StateHeader() {
        }

        public StateHeader(byte type) {
            this.type = type;
        }

        public StateHeader(byte type, Digest digest) {
            this.type = type;
            this.my_digest = digest;
        }

        public int getType() {
            return this.type;
        }

        public Digest getDigest() {
            return this.my_digest;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("type=").append(StateHeader.type2Str(this.type));
            if (this.my_digest != null) {
                sb.append(", digest=").append(this.my_digest);
            }
            return sb.toString();
        }

        static String type2Str(int t) {
            switch (t) {
                case 1: {
                    return "STATE_REQ";
                }
                case 2: {
                    return "STATE_RSP";
                }
                case 3: {
                    return "STATE_EX";
                }
            }
            return "<unknown>";
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            Util.writeStreamable(this.my_digest, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            this.my_digest = (Digest)Util.readStreamable(Digest.class, in);
        }

        @Override
        public int size() {
            int retval = 1;
            ++retval;
            if (this.my_digest != null) {
                retval = (int)((long)retval + this.my_digest.serializedSize());
            }
            return retval;
        }
    }
}

