/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.logging.Handler;
import org.jboss.as.logging.Target;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="JBAS")
public interface LoggingMessages {
    public static final LoggingMessages MESSAGES = (LoggingMessages)Messages.getBundle(LoggingMessages.class);

    @Message(id=11530, value="Could not access %s.")
    public String cannotAccessClass(@Cause Throwable var1, String var2);

    @Message(id=11531, value="Failed to instantiate class '%s' for %s '%s'")
    public IllegalArgumentException cannotInstantiateClass(@Cause Throwable var1, String var2, String var3, String var4);

    @Message(id=11532, value="Failed to load module '%s' for %s '%s'")
    public IllegalArgumentException cannotLoadModule(@Cause Throwable var1, String var2, String var3, String var4);

    @Message(id=11533, value="Can not unassign handler. Handler %s is not assigned.")
    public String cannotUnassignHandler(String var1);

    @Message(id=11534, value="Class '%s' could not be found.")
    public String classNotFound(@Cause Throwable var1, String var2);

    @Message(id=11535, value="The encoding value '%s' is invalid.")
    public IllegalArgumentException failedToSetHandlerEncoding(@Cause Throwable var1, String var2);

    @Message(id=11536, value="Handler %s is already assigned.")
    public String handlerAlreadyDefined(String var1);

    @Message(id=11537, value="Handler %s not found.")
    public IllegalArgumentException handlerNotFound(String var1);

    @Message(id=11538, value="Filter %s is invalid")
    public String invalidFilter(String var1);

    @Message(id=11539, value="Log level %s is invalid.")
    public String invalidLogLevel(String var1);

    @Message(id=11540, value="Overflow action %s is invalid.")
    public String invalidOverflowAction(String var1);

    @Message(id=11541, value="Invalid size %s")
    public String invalidSize(String var1);

    @Message(id=11542, value="Invalid value for target name. Valid names include: %s")
    public String invalidTargetName(EnumSet<Target> var1);

    @Message(id=11544, value="Value type key '%s' is invalid. Valid value type keys are; %s")
    public String invalidValueTypeKey(String var1, Collection<String> var2);

    @Message(id=11548, value="Logger '%s' was not found.")
    public String loggerNotFound(String var1);

    @Message(id=11545, value="Missing required nested filter element")
    public String missingRequiredNestedFilterElement();

    @Message(id=11547, value="Unknown parameter type (%s) for property '%s' on '%s'")
    public IllegalArgumentException unknownParameterType(Class<?> var1, String var2, Class<?> var3);

    @Message(id=11552, value="An absolute path (%s) cannot be specified for relative-to.")
    public String invalidRelativeTo(String var1);

    @Message(id=11553, value="An absolute path (%2$s) cannot be used when a relative-to path (%1$s) is being used.")
    public String invalidPath(String var1, String var2);

    @Message(id=11554, value="The suffix (%s) is invalid. A suffix must be a valid date format and not contain seconds or milliseconds.")
    public String invalidSuffix(String var1);

    @Message(id=11555, value="Failed to configure logging using '%s' configuration file.")
    public DeploymentUnitProcessingException failedToConfigureLogging(@Cause Throwable var1, String var2);

    @Message(id=11556, value="Error occurred while searching for logging configuration files.")
    public DeploymentUnitProcessingException errorProcessingLoggingConfiguration(@Cause Throwable var1);

    @Message(id=11557, value="Handler %s is attached to the following handlers and cannot be removed; %s")
    public String handlerAttachedToHandlers(String var1, Collection<String> var2);

    @Message(id=11558, value="Handler %s is attached to the following loggers and cannot be removed; %s")
    public String handlerAttachedToLoggers(String var1, Collection<String> var2);

    @Message(id=11559, value="Cannot add handler (%s) to itself")
    public String cannotAddHandlerToSelf(String var1);

    @Message(id=11560, value="The handler is closed, cannot publish to a closed handler")
    public IllegalStateException handlerClosed();

    @Message(id=-1, value="Cannot set property '%s' on a closed handler with value '%s'.")
    public IllegalStateException handlerClosed(String var1, String var2);

    @Message(id=11561, value="Configuration for handler '%s' could not be found.")
    public String handlerConfigurationNotFound(String var1);

    @Message(id=11562, value="Configuration for logger '%s' could not be found.")
    public String loggerConfigurationNotFound(String var1);

    @Message(id=11563, value="The path manager service does not appear to be started.")
    public IllegalStateException pathManagerServiceNotStarted();

    @Message(id=11564, value="Method %s on class %s is not supported")
    public UnsupportedOperationException unsupportedMethod(String var1, String var2);

    @Message(id=11565, value="Failed to write configuration file %s")
    public RuntimeException failedToWriteConfigurationFile(@Cause Throwable var1, File var2);

    @Message(id=11566, value="A failure was detecting while performing a rollback.")
    public RuntimeException rollbackFailure(@Cause Throwable var1);

    @Message(id=11567, value="%s is null")
    public IllegalArgumentException nullVar(String var1);

    @Message(id=11568, value="Failed to load class '%s' for %s '%s'")
    public IllegalArgumentException failedToLoadClass(@Cause Throwable var1, String var2, String var3, String var4);

    @Message(id=11569, value="No property named '%s' for %s '%s' of type '%s'")
    public IllegalArgumentException invalidProperty(String var1, String var2, String var3, Class<?> var4);

    @Message(id=11570, value="Failed to locate constructor in class \"%s\" for %s \"%s\"")
    public IllegalArgumentException failedToLocateConstructor(@Cause Throwable var1, String var2, String var3, String var4);

    @Message(id=11571, value="Cannot set property '%s' on %s '%s' (removed)")
    public IllegalArgumentException cannotSetRemovedProperty(String var1, String var2, String var3);

    @Message(id=11572, value="No property '%s' setter found for %s '%s'")
    public IllegalArgumentException propertySetterNotFound(String var1, String var2, String var3);

    @Message(id=11573, value="No property '%s' type could be determined for %s '%s'")
    public IllegalArgumentException propertyTypeNotFound(String var1, String var2, String var3);

    @Message(id=11574, value="Cannot remove property '%s' on %s '%s' (removed)")
    public IllegalArgumentException propertyAlreadyRemoved(String var1, String var2, String var3);

    @Message(id=11575, value="Formatter '%s' is not found")
    public String formatterNotFound(String var1);

    @Message(id=11576, value="Unsupported character set '%s'")
    public IllegalArgumentException unsupportedCharSet(String var1);

    @Message(id=11577, value="Error manager '%s' is not found")
    public IllegalArgumentException errorManagerNotFound(String var1);

    @Message(id=11578, value="Nested handlers not supported for handler %s")
    public IllegalArgumentException nestedHandlersNotSupported(Class<? extends Handler> var1);

    @Message(id=11579, value="Logger '%s' already exists")
    public IllegalArgumentException loggerAlreadyExists(String var1);

    @Message(id=11580, value="Formatter '%s' already exists")
    public IllegalArgumentException formatterAlreadyExists(String var1);

    @Message(id=11581, value="Filter '%s' already exists")
    public IllegalArgumentException filterAlreadyExists(String var1);

    @Message(id=11582, value="ErrorManager '%s' already exists")
    public IllegalArgumentException errorManagerAlreadyExists(String var1);

    @Message(id=11583, value="Cannot assign null value to primitive property '%s' of %s")
    public IllegalArgumentException cannotAssignNullToPrimitive(String var1, Class<?> var2);

    @Message(id=11584, value="Truncated filter expression string")
    public IllegalArgumentException truncatedFilterExpression();

    @Message(id=11585, value="Invalid escape found in filter expression string")
    public IllegalArgumentException invalidEscapeFoundInFilterExpression();

    @Message(id=11586, value="Filter '%s' is not found")
    public IllegalArgumentException filterNotFound(String var1);

    @Message(id=11587, value="Expected identifier next in filter expression")
    public IllegalArgumentException expectedIdentifier();

    @Message(id=11588, value="Expected string next in filter expression")
    public IllegalArgumentException expectedString();

    @Message(id=11589, value="Expected '%s' next in filter expression")
    public IllegalArgumentException expected(String var1);

    @Message(id=-1, value="Expected '%s' or '%s' next in filter expression")
    public IllegalArgumentException expected(String var1, String var2);

    @Message(id=11590, value="Unexpected end of filter expression")
    public IllegalArgumentException unexpectedEnd();

    @Message(id=11591, value="Extra data after filter expression")
    public IllegalArgumentException extraData();

    @Message(id=11592, value="The logging subsystem requires the log manager to be org.jboss.logmanager.LogManager. The subsystem has not be initialized and cannot be used. To use JBoss Log Manager you must add the system property \"java.util.logging.manager\" and set it to \"org.jboss.logmanager.LogManager\"")
    public IllegalStateException extensionNotInitialized();
}

