/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Filters;
import org.jboss.as.logging.LoggingProfileContextSelector;
import org.jboss.as.logging.LoggingProfileOperations;
import org.jboss.as.logging.logmanager.ConfigurationPersistence;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.wildfly.security.manager.WildFlySecurityManager;

final class LoggingOperations {
    LoggingOperations() {
    }

    public static String getAddressName(ModelNode operation) {
        return LoggingOperations.getAddress(operation).getLastElement().getValue();
    }

    public static PathAddress getAddress(ModelNode operation) {
        return PathAddress.pathAddress((ModelNode)operation.require("address"));
    }

    static void addCommitStep(OperationContext context, ConfigurationPersistence configurationPersistence) {
        context.addStep((OperationStepHandler)new CommitOperationStepHandler(configurationPersistence), OperationContext.Stage.RUNTIME);
    }

    static abstract class LoggingWriteAttributeHandler
    extends AbstractWriteAttributeHandler<ConfigurationPersistence> {
        private final AttributeDefinition[] attributes;

        protected LoggingWriteAttributeHandler(AttributeDefinition[] attributes) {
            super(attributes);
            this.attributes = attributes;
        }

        protected final boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<ConfigurationPersistence> handbackHolder) throws OperationFailedException {
            ConfigurationPersistence configurationPersistence;
            String name = LoggingOperations.getAddressName(operation);
            PathAddress address = LoggingOperations.getAddress(operation);
            boolean isLoggingProfile = LoggingProfileOperations.isLoggingProfileAddress(address);
            if (isLoggingProfile) {
                LogContext logContext = LoggingProfileContextSelector.getInstance().getOrCreate(LoggingProfileOperations.getLoggingProfileName(address));
                configurationPersistence = ConfigurationPersistence.getOrCreateConfigurationPersistence(logContext);
            } else {
                configurationPersistence = ConfigurationPersistence.getOrCreateConfigurationPersistence();
            }
            LogContextConfiguration logContextConfiguration = configurationPersistence.getLogContextConfiguration();
            handbackHolder.setHandback((Object)configurationPersistence);
            boolean restartRequired = this.applyUpdate(context, attributeName, name, resolvedValue, logContextConfiguration);
            LoggingOperations.addCommitStep(context, configurationPersistence);
            return restartRequired;
        }

        protected abstract boolean applyUpdate(OperationContext var1, String var2, String var3, ModelNode var4, LogContextConfiguration var5) throws OperationFailedException;

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, ConfigurationPersistence configurationPersistence) throws OperationFailedException {
            LogContextConfiguration logContextConfiguration = configurationPersistence.getLogContextConfiguration();
            logContextConfiguration.forget();
        }

        protected void validateUpdatedModel(OperationContext context, Resource model) throws OperationFailedException {
            super.validateUpdatedModel(context, model);
            ModelNode submodel = model.getModel();
            if (submodel.hasDefined(CommonAttributes.FILTER.getName())) {
                String filterSpec = Filters.filterToFilterSpec(CommonAttributes.FILTER.resolveModelAttribute(context, submodel));
                submodel.remove(CommonAttributes.FILTER.getName());
                submodel.get(CommonAttributes.FILTER_SPEC.getName()).set(filterSpec);
            }
        }

        public final AttributeDefinition[] getAttributes() {
            return this.attributes;
        }
    }

    static abstract class LoggingRemoveOperationStepHandler
    extends LoggingOperationStepHandler {
        LoggingRemoveOperationStepHandler() {
        }

        @Override
        public final void execute(OperationContext context, ModelNode operation, final String name, final LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            final ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
            this.performRemove(context, operation, logContextConfiguration, name, model);
            if (context.getProcessType().isServer()) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        LoggingRemoveOperationStepHandler.this.performRuntime(context, operation, logContextConfiguration, name, model);
                        context.stepCompleted();
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }

        protected abstract void performRemove(OperationContext var1, ModelNode var2, LogContextConfiguration var3, String var4, ModelNode var5) throws OperationFailedException;
    }

    static abstract class LoggingUpdateOperationStepHandler
    extends LoggingOperationStepHandler {
        LoggingUpdateOperationStepHandler() {
        }

        @Override
        public final void execute(OperationContext context, ModelNode operation, final String name, final LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            final ModelNode model = resource.getModel();
            this.updateModel(operation, model);
            if (context.getProcessType().isServer()) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        LoggingUpdateOperationStepHandler.this.performRuntime(context, operation, logContextConfiguration, name, model);
                        context.stepCompleted();
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }

        public abstract void updateModel(ModelNode var1, ModelNode var2) throws OperationFailedException;
    }

    static abstract class LoggingAddOperationStepHandler
    extends LoggingOperationStepHandler {
        LoggingAddOperationStepHandler() {
        }

        @Override
        public final void execute(OperationContext context, ModelNode operation, final String name, final LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
            final ModelNode model = resource.getModel();
            this.updateModel(operation, model);
            if (context.getProcessType().isServer()) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        LoggingAddOperationStepHandler.this.performRuntime(context, operation, logContextConfiguration, name, model);
                        context.stepCompleted();
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }

        public abstract void updateModel(ModelNode var1, ModelNode var2) throws OperationFailedException;
    }

    private static abstract class LoggingOperationStepHandler
    implements OperationStepHandler {
        private LoggingOperationStepHandler() {
        }

        public final void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ConfigurationPersistence configurationPersistence;
            PathAddress address = LoggingOperations.getAddress(operation);
            String name = LoggingOperations.getAddressName(operation);
            boolean isLoggingProfile = LoggingProfileOperations.isLoggingProfileAddress(address);
            if (isLoggingProfile) {
                LogContext logContext = LoggingProfileContextSelector.getInstance().getOrCreate(LoggingProfileOperations.getLoggingProfileName(address));
                configurationPersistence = ConfigurationPersistence.getOrCreateConfigurationPersistence(logContext);
            } else {
                configurationPersistence = ConfigurationPersistence.getOrCreateConfigurationPersistence();
            }
            LogContextConfiguration logContextConfiguration = configurationPersistence.getLogContextConfiguration();
            this.execute(context, operation, name, logContextConfiguration);
            if (context.getProcessType().isServer()) {
                LoggingOperations.addCommitStep(context, configurationPersistence);
                context.completeStep(new OperationContext.RollbackHandler(){

                    public void handleRollback(OperationContext context, ModelNode operation) {
                        configurationPersistence.rollback();
                    }
                });
            } else {
                context.stepCompleted();
            }
        }

        public abstract void execute(OperationContext var1, ModelNode var2, String var3, LogContextConfiguration var4) throws OperationFailedException;

        public abstract void performRuntime(OperationContext var1, ModelNode var2, LogContextConfiguration var3, String var4, ModelNode var5) throws OperationFailedException;
    }

    public static class ReadFilterOperationStepHandler
    implements OperationStepHandler {
        public static final ReadFilterOperationStepHandler INSTANCE = new ReadFilterOperationStepHandler();

        private ReadFilterOperationStepHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
            ModelNode filter = CommonAttributes.FILTER_SPEC.resolveModelAttribute(context, model);
            if (filter.isDefined()) {
                context.getResult().set(Filters.filterSpecToFilter(filter.asString()));
            }
            context.stepCompleted();
        }
    }

    private static final class CommitOperationStepHandler
    implements OperationStepHandler {
        private static OperationContext.AttachmentKey<Boolean> WRITTEN_KEY = OperationContext.AttachmentKey.create(Boolean.class);
        private final ConfigurationPersistence configurationPersistence;
        private final boolean persistConfig;

        CommitOperationStepHandler(ConfigurationPersistence configurationPersistence) {
            this.configurationPersistence = configurationPersistence;
            this.persistConfig = Boolean.parseBoolean(WildFlySecurityManager.getPropertyPrivileged((String)"jboss.server.persist.config", (String)Boolean.toString(true)));
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            this.configurationPersistence.prepare();
            context.completeStep(new OperationContext.ResultHandler(){

                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    if (resultAction == OperationContext.ResultAction.KEEP) {
                        CommitOperationStepHandler.this.configurationPersistence.commit();
                        if (!LoggingProfileOperations.isLoggingProfileAddress(LoggingOperations.getAddress(operation)) && context.getAttachment(WRITTEN_KEY) == null) {
                            context.attachIfAbsent(WRITTEN_KEY, (Object)Boolean.TRUE);
                            if (CommitOperationStepHandler.this.persistConfig) {
                                CommitOperationStepHandler.this.configurationPersistence.writeConfiguration(context);
                            }
                        }
                    } else if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                        CommitOperationStepHandler.this.configurationPersistence.rollback();
                    }
                }
            });
        }
    }
}

