/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.concurrent;

import java.util.Map;
import java.util.concurrent.Callable;
import javax.enterprise.concurrent.ManageableThread;
import javax.enterprise.concurrent.ManagedTask;
import javax.enterprise.concurrent.ManagedTaskListener;

public final class ManagedExecutors {
    private ManagedExecutors() {
    }

    public static boolean isCurrentThreadShutdown() {
        Thread thread = Thread.currentThread();
        return thread instanceof ManageableThread && ((ManageableThread)((Object)thread)).isShutdown();
    }

    public static <V> Callable<V> managedTask(Callable<V> task, ManagedTaskListener taskListener) {
        return new ManagedCallable<V>(task, taskListener, null);
    }

    public static <V> Callable<V> managedTask(Callable<V> task, Map<String, String> executionProperties, ManagedTaskListener taskListener) {
        return new ManagedCallable<V>(task, taskListener, executionProperties);
    }

    public static Runnable managedTask(Runnable task, ManagedTaskListener taskListener) {
        return new ManagedRunnable(task, taskListener, null);
    }

    public static Runnable managedTask(Runnable task, Map<String, String> executionProperties, ManagedTaskListener taskListener) {
        return new ManagedRunnable(task, taskListener, executionProperties);
    }

    static class ManagedRunnable
    implements Runnable,
    ManagedTask {
        private final Runnable task;
        private final ManagedTaskListener taskListener;
        private final Map<String, String> executionProperties;

        ManagedRunnable(Runnable task, ManagedTaskListener taskListener, Map<String, String> executionProperties) {
            this.task = task;
            this.taskListener = taskListener;
            this.executionProperties = executionProperties;
        }

        @Override
        public void run() {
            this.task.run();
        }

        @Override
        public Map<String, String> getExecutionProperties() {
            return this.executionProperties;
        }

        @Override
        public ManagedTaskListener getManagedTaskListener() {
            return this.taskListener;
        }
    }

    static class ManagedCallable<V>
    implements Callable<V>,
    ManagedTask {
        private final Callable<V> task;
        private final ManagedTaskListener taskListener;
        private final Map<String, String> executionProperties;

        ManagedCallable(Callable<V> task, ManagedTaskListener taskListener, Map<String, String> executionProperties) {
            this.task = task;
            this.taskListener = taskListener;
            this.executionProperties = executionProperties;
        }

        @Override
        public V call() throws Exception {
            return this.task.call();
        }

        @Override
        public Map<String, String> getExecutionProperties() {
            return this.executionProperties;
        }

        @Override
        public ManagedTaskListener getManagedTaskListener() {
            return this.taskListener;
        }
    }
}

