/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

class FastCopyHashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 10929568968762L;
    private static final int DEFAULT_CAPACITY = 64;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.3125f;
    private transient E[] table;
    private transient int size;
    private transient int threshold;
    private final float loadFactor;
    private transient int modCount;
    private transient int hashCode;

    public FastCopyHashSet(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Can not have a negative size table!");
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (!(loadFactor > 0.0f) || !(loadFactor <= 1.0f)) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and less than or equal to 1");
        }
        this.loadFactor = loadFactor;
        this.init(initialCapacity, loadFactor);
    }

    public FastCopyHashSet(Set<? extends E> set) {
        if (set instanceof FastCopyHashSet) {
            FastCopyHashSet fast = (FastCopyHashSet)set;
            this.table = (Object[])fast.table.clone();
            this.loadFactor = fast.loadFactor;
            this.size = fast.size;
            this.threshold = fast.threshold;
            this.hashCode = fast.hashCode;
        } else {
            this.loadFactor = 0.3125f;
            this.init(set.size(), this.loadFactor);
            this.addAll(set);
        }
    }

    private void init(int initialCapacity, float loadFactor) {
        int c;
        for (c = 1; c < initialCapacity; c <<= 1) {
        }
        this.threshold = (int)((float)c * loadFactor);
        if (initialCapacity > this.threshold && c < 0x40000000) {
            this.threshold = (int)((float)(c <<= 1) * loadFactor);
        }
        this.table = new Object[c];
    }

    public FastCopyHashSet(int initialCapacity) {
        this(initialCapacity, 0.3125f);
    }

    public FastCopyHashSet() {
        this(64);
    }

    private int nextIndex(int index, int length) {
        index = index >= length - 1 ? 0 : index + 1;
        return index;
    }

    private static int index(int hashCode, int length) {
        return hashCode & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object key) {
        int index;
        if (key == null) {
            return false;
        }
        int hash = key.hashCode();
        int length = this.table.length;
        int start = index = FastCopyHashSet.index(hash, length);
        do {
            E e;
            if ((e = this.table[index]) == null) {
                return false;
            }
            if (!key.equals(e)) continue;
            return true;
        } while ((index = this.nextIndex(index, length)) != start);
        return false;
    }

    @Override
    public boolean add(E key) {
        E e;
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        E[] table = this.table;
        int hash = key.hashCode();
        int length = table.length;
        int index = FastCopyHashSet.index(hash, length);
        boolean f = false;
        int start = index;
        while ((e = table[index]) != null) {
            if (!f) {
                f = true;
            }
            if (key.equals(e)) {
                return false;
            }
            if ((index = this.nextIndex(index, length)) != start) continue;
            throw new IllegalStateException("Table is full!");
        }
        ++this.modCount;
        table[index] = key;
        this.hashCode += key.hashCode();
        if (++this.size >= this.threshold) {
            this.resize(length);
        }
        return true;
    }

    private void resize(int from) {
        E[] old;
        int newLength = from << 1;
        if (newLength > 0x40000000 || newLength <= from) {
            return;
        }
        Object[] newTable = new Object[newLength];
        for (E e : old = this.table) {
            if (e == null) continue;
            int index = FastCopyHashSet.index(e.hashCode(), newLength);
            while (newTable[index] != null) {
                index = this.nextIndex(index, newLength);
            }
            newTable[index] = e;
        }
        this.threshold = (int)(this.loadFactor * (float)newLength);
        this.table = newTable;
    }

    @Override
    public boolean addAll(Collection<? extends E> set) {
        int size = set.size();
        if (size == 0) {
            return false;
        }
        boolean changed = false;
        for (E e : set) {
            if (!this.add(e)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean remove(Object key) {
        int start;
        E[] table = this.table;
        int length = table.length;
        int hash = key.hashCode();
        int index = start = FastCopyHashSet.index(hash, length);
        do {
            E e;
            if ((e = table[index]) == null) {
                return false;
            }
            if (!key.equals(e)) continue;
            table[index] = null;
            this.hashCode -= hash;
            this.relocate(index);
            ++this.modCount;
            --this.size;
            return true;
        } while ((index = this.nextIndex(index, length)) != start);
        return false;
    }

    private void relocate(int start) {
        E[] table = this.table;
        int length = table.length;
        int current = this.nextIndex(start, length);
        E e;
        while ((e = table[current]) != null) {
            int prefer = FastCopyHashSet.index(e.hashCode(), length);
            if (current < prefer && (prefer <= start || start <= current) || prefer <= start && start <= current) {
                table[start] = e;
                table[current] = null;
                start = current;
            }
            current = this.nextIndex(current, length);
        }
        return;
    }

    @Override
    public void clear() {
        ++this.modCount;
        E[] table = this.table;
        for (int i = 0; i < table.length; ++i) {
            table[i] = null;
        }
        this.hashCode = 0;
        this.size = 0;
    }

    public FastCopyHashSet<E> clone() {
        try {
            FastCopyHashSet clone = (FastCopyHashSet)super.clone();
            clone.table = (Object[])this.table.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new KeyIterator();
    }

    public void printDebugStats() {
        int optimal = 0;
        int total = 0;
        int totalSkew = 0;
        int maxSkew = 0;
        for (int i = 0; i < this.table.length; ++i) {
            E e = this.table[i];
            if (e == null) continue;
            ++total;
            int target = FastCopyHashSet.index(e.hashCode(), this.table.length);
            if (i == target) {
                ++optimal;
                continue;
            }
            int skew = Math.abs(i - target);
            if (skew > maxSkew) {
                maxSkew = skew;
            }
            totalSkew += skew;
        }
        System.out.println(" Size:             " + this.size);
        System.out.println(" Real Size:        " + total);
        System.out.println(" Optimal:          " + optimal + " (" + (float)optimal * 100.0f / (float)total + "%)");
        System.out.println(" Average Distance: " + (float)totalSkew / (float)(total - optimal));
        System.out.println(" Max Distance:     " + maxSkew);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.init(size, this.loadFactor);
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            this.putForCreate(key);
        }
        this.size = size;
    }

    private void putForCreate(E key) {
        E[] table = this.table;
        int hash = key.hashCode();
        int length = table.length;
        int index = FastCopyHashSet.index(hash, length);
        E e = table[index];
        while (e != null) {
            index = this.nextIndex(index, length);
            e = table[index];
        }
        table[index] = key;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (E e : this.table) {
            if (e == null) continue;
            s.writeObject(e);
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        E[] table;
        for (E e : table = this.table) {
            if (e == null || c.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        Set<E> set;
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        if (o instanceof FastCopyHashSet) {
            set = (FastCopyHashSet)o;
            if (this.hashCode != ((FastCopyHashSet)set).hashCode) {
                return false;
            }
            if (this.table.length == ((FastCopyHashSet)set).table.length) {
                return Arrays.equals(this.table, ((FastCopyHashSet)set).table);
            }
        }
        if ((set = (Set)o).size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(set);
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    public Object[] getRawArray() {
        return this.table;
    }

    private class KeyIterator
    implements Iterator<E> {
        private int next = 0;
        private int expectedCount = FastCopyHashSet.access$100(FastCopyHashSet.this);
        private int current = -1;
        private boolean hasNext;
        private E[] table = FastCopyHashSet.access$200(FastCopyHashSet.this);

        private KeyIterator() {
        }

        @Override
        public E next() {
            if (FastCopyHashSet.this.modCount != this.expectedCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.next++;
            this.hasNext = false;
            return this.table[this.current];
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext) {
                return true;
            }
            E[] table = this.table;
            for (int i = this.next; i < table.length; ++i) {
                if (table[i] == null) continue;
                this.next = i;
                this.hasNext = true;
                return true;
            }
            this.next = table.length;
            return false;
        }

        @Override
        public void remove() {
            Object e;
            int current;
            if (FastCopyHashSet.this.modCount != this.expectedCount) {
                throw new ConcurrentModificationException();
            }
            int delete = current = this.current;
            if (current == -1) {
                throw new IllegalStateException();
            }
            this.current = -1;
            this.next = delete;
            E[] table = this.table;
            if (table != FastCopyHashSet.this.table) {
                FastCopyHashSet.this.remove(table[delete]);
                table[delete] = null;
                this.expectedCount = FastCopyHashSet.this.modCount;
                return;
            }
            int length = table.length;
            int i = delete;
            table[delete] = null;
            FastCopyHashSet.this.size--;
            while ((e = table[i = FastCopyHashSet.this.nextIndex(i, length)]) != null) {
                int prefer = FastCopyHashSet.index(e.hashCode(), length);
                if ((i >= prefer || prefer > delete && delete > i) && (prefer > delete || delete > i)) continue;
                if (i < current && current <= delete && table == FastCopyHashSet.this.table) {
                    int remaining = length - current;
                    Object[] newTable = new Object[remaining];
                    System.arraycopy(table, current, newTable, 0, remaining);
                    this.table = newTable;
                    this.next = 0;
                }
                table[delete] = e;
                table[i] = null;
                delete = i;
            }
        }
    }
}

