/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.proton;

import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.CompositeWritableBuffer;
import org.apache.qpid.proton.codec.DroppingWritableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.jms.EncodedMessage;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.MessageFormat;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.protocol.proton.ProtonRemotingConnection;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.impl.ServerMessageImpl;
import org.hornetq.utils.TypedProperties;

public class ProtonUtils {
    private static final String PREFIX = "HORNETQ_PROTON_";
    private static final String MESSAGE_ANNOTATIONS = "HORNETQ_PROTON_MESSAGE_ANNOTATIONS_";
    private static final String DELIVERY_ANNOTATIONS = "HORNETQ_PROTON_DELIVERY_ANNOTATIONS_";
    private static final String FOOTER_VALUES = "HORNETQ_PROTON_FOOTER_VALUES";
    private static final String MESSAGE_FORMAT = "HORNETQ_PROTON_MESSAGE_FORMAT";
    private static final String PROTON_MESSAGE_FORMAT = "HORNETQ_PROTON_FORMAT";
    private static final String PROTON_MESSAGE_SIZE = "PROTON_MESSAGE_SIZE";
    private static final String MESSAGE_TYPE = "HORNETQ_PROTON_MESSAGE_TYPE";
    private static final String FIRST_ACQUIRER = "HORNETQ_PROTON_FIRST_ACQUIRER";
    private static final String USER_ID = "HORNETQ_PROTON_USER_ID";
    private static final String SUBJECT = "HORNETQ_PROTON_SUBJECT";
    private static final String REPLY_TO = "HORNETQ_PROTON_REPLY_TO";
    private static final String CORRELATION_ID = "HORNETQ_PROTON_CORRELATION_ID";
    private static final String CONTENT_TYPE = "HORNETQ_PROTON_CONTENT_TYPE";
    private static final String CONTENT_ENCODING = "HORNETQ_PROTON_CONTENT_TYPE";
    private static final String ABSOLUTE_EXPIRY_TIME = "HORNETQ_PROTON_ABSOLUTE_EXPIRY_TIME";
    private static final String CREATION_TIME = "HORNETQ_PROTON_CREATION_TIME";
    private static final String GROUP_ID = "HORNETQ_PROTON_GROUP_ID";
    private static final String GROUP_SEQUENCE = "HORNETQ_PROTON_GROUP_SEQUENCE";
    private static final String REPLY_TO_GROUP_ID = "HORNETQ_PROTON_REPLY_TO_GROUP_ID";
    private static final SimpleString USER_ID_SS = new SimpleString("HORNETQ_PROTON_USER_ID");
    private static final SimpleString SUBJECT_SS = new SimpleString("HORNETQ_PROTON_SUBJECT");
    private static final SimpleString REPLY_TO_SS = new SimpleString("HORNETQ_PROTON_REPLY_TO");
    private static final SimpleString CORRELATION_ID_SS = new SimpleString("HORNETQ_PROTON_CORRELATION_ID");
    private static final SimpleString CONTENT_TYPE_SS = new SimpleString("HORNETQ_PROTON_CONTENT_TYPE");
    private static final SimpleString CONTENT_ENCODING_SS = new SimpleString("HORNETQ_PROTON_CONTENT_TYPE");
    private static final SimpleString ABSOLUTE_EXPIRY_TIME_SS = new SimpleString("HORNETQ_PROTON_ABSOLUTE_EXPIRY_TIME");
    private static final SimpleString CREATION_TIME_SS = new SimpleString("HORNETQ_PROTON_CREATION_TIME");
    private static final SimpleString GROUP_ID_SS = new SimpleString("HORNETQ_PROTON_GROUP_ID");
    private static final SimpleString GROUP_SEQUENCE_SS = new SimpleString("HORNETQ_PROTON_GROUP_SEQUENCE");
    private static final SimpleString REPLY_TO_GROUP_ID_SS = new SimpleString("HORNETQ_PROTON_REPLY_TO_GROUP_ID");
    private static final SimpleString PROTON_MESSAGE_SIZE_SS = new SimpleString("PROTON_MESSAGE_SIZE");
    private static Set<String> SPECIAL_PROPS = new HashSet<String>();

    private static long getMessageFormat(MessageFormat messageFormat) {
        switch (messageFormat) {
            case AMQP: {
                return 0L;
            }
            case DATA: {
                return 1L;
            }
            case JSON: {
                return 2L;
            }
            case TEXT: {
                return 3L;
            }
        }
        return 0L;
    }

    private static MessageFormat getMessageFormat(long messageFormat) {
        switch ((int)messageFormat) {
            case 0: {
                return MessageFormat.AMQP;
            }
            case 1: {
                return MessageFormat.DATA;
            }
            case 2: {
                return MessageFormat.JSON;
            }
            case 3: {
                return MessageFormat.TEXT;
            }
        }
        return MessageFormat.AMQP;
    }

    private static int getMessageType(Message protonMessage) {
        Section section = protonMessage.getBody();
        if (section instanceof AmqpValue) {
            AmqpValue amqpValue = (AmqpValue)section;
            Object value = amqpValue.getValue();
            if (value instanceof String) {
                return 3;
            }
            if (value instanceof byte[]) {
                return 4;
            }
            if (value instanceof Map) {
                return 5;
            }
            if (value instanceof Object) {
                return 2;
            }
            return 0;
        }
        return 0;
    }

    static {
        SPECIAL_PROPS.add(MESSAGE_FORMAT);
        SPECIAL_PROPS.add(MESSAGE_TYPE);
        SPECIAL_PROPS.add(FIRST_ACQUIRER);
        SPECIAL_PROPS.add(PROTON_MESSAGE_FORMAT);
        SPECIAL_PROPS.add(PROTON_MESSAGE_SIZE);
        SPECIAL_PROPS.add(MESSAGE_TYPE);
        SPECIAL_PROPS.add(USER_ID);
        SPECIAL_PROPS.add(SUBJECT);
        SPECIAL_PROPS.add(REPLY_TO);
        SPECIAL_PROPS.add(CORRELATION_ID);
        SPECIAL_PROPS.add("HORNETQ_PROTON_CONTENT_TYPE");
        SPECIAL_PROPS.add("HORNETQ_PROTON_CONTENT_TYPE");
        SPECIAL_PROPS.add(ABSOLUTE_EXPIRY_TIME);
        SPECIAL_PROPS.add(CREATION_TIME);
        SPECIAL_PROPS.add(GROUP_ID);
        SPECIAL_PROPS.add(GROUP_SEQUENCE);
        SPECIAL_PROPS.add(REPLY_TO_GROUP_ID);
    }

    public static class OUTBOUND {
        public static EncodedMessage transform(ServerMessage message, int deliveryCount) {
            long messageFormat = message.getLongProperty(ProtonUtils.MESSAGE_FORMAT);
            Integer size = message.getIntProperty(PROTON_MESSAGE_SIZE_SS);
            Header header = OUTBOUND.populateHeader(message, deliveryCount);
            DeliveryAnnotations deliveryAnnotations = OUTBOUND.populateDeliveryAnnotations(message);
            MessageAnnotations messageAnnotations = OUTBOUND.populateMessageAnnotations(message);
            Properties props = OUTBOUND.populateProperties(message);
            ApplicationProperties applicationProperties = OUTBOUND.populateApplicationProperties(message);
            Section section = OUTBOUND.populateBody(message);
            Footer footer = OUTBOUND.populateFooter(message);
            Set propertyNames = message.getPropertyNames();
            for (SimpleString propertyName : propertyNames) {
                TypedProperties typedProperties = message.getTypedProperties();
                String realName = propertyName.toString();
                if (!realName.startsWith(ProtonUtils.MESSAGE_ANNOTATIONS)) continue;
                SimpleString value = (SimpleString)typedProperties.getProperty(propertyName);
                Symbol symbol = Symbol.getSymbol((String)realName.replace(ProtonUtils.MESSAGE_ANNOTATIONS, ""));
                messageAnnotations.getValue().put(symbol, value.toString());
            }
            MessageImpl protonMessage = new MessageImpl(header, deliveryAnnotations, messageAnnotations, props, applicationProperties, section, footer);
            protonMessage.setMessageFormat(ProtonUtils.getMessageFormat(message.getLongProperty(new SimpleString(ProtonUtils.PROTON_MESSAGE_FORMAT))));
            ByteBuffer buffer = ByteBuffer.wrap(new byte[size.intValue()]);
            DroppingWritableBuffer overflow = new DroppingWritableBuffer();
            int c = protonMessage.encode((WritableBuffer)new CompositeWritableBuffer((WritableBuffer)new WritableBuffer.ByteBufferWrapper(buffer), (WritableBuffer)overflow));
            if (overflow.position() > 0) {
                buffer = ByteBuffer.wrap(new byte[4096 + overflow.position()]);
                c = protonMessage.encode((WritableBuffer)new WritableBuffer.ByteBufferWrapper(buffer));
            }
            return new EncodedMessage(messageFormat, buffer.array(), 0, c);
        }

        private static Header populateHeader(ServerMessage message, int deliveryCount) {
            Header header = new Header();
            header.setDurable(Boolean.valueOf(message.isDurable()));
            header.setPriority(new UnsignedByte(message.getPriority()));
            header.setDeliveryCount(new UnsignedInteger(deliveryCount));
            header.setTtl(new UnsignedInteger((int)message.getExpiration()));
            return header;
        }

        private static DeliveryAnnotations populateDeliveryAnnotations(ServerMessage message) {
            HashMap<CharSequence, Object> actualValues = new HashMap<CharSequence, Object>();
            DeliveryAnnotations deliveryAnnotations = new DeliveryAnnotations(actualValues);
            for (SimpleString name : message.getPropertyNames()) {
                String sName = name.toString();
                if (!sName.startsWith(ProtonUtils.DELIVERY_ANNOTATIONS)) continue;
                Object val = message.getTypedProperties().getProperty(name);
                if (val instanceof SimpleString) {
                    actualValues.put(sName.subSequence(sName.indexOf(ProtonUtils.DELIVERY_ANNOTATIONS), sName.length()), val.toString());
                    continue;
                }
                actualValues.put(sName.subSequence(sName.indexOf(ProtonUtils.DELIVERY_ANNOTATIONS), sName.length()), val);
            }
            return actualValues.size() > 0 ? deliveryAnnotations : null;
        }

        private static MessageAnnotations populateMessageAnnotations(ServerMessage message) {
            HashMap<CharSequence, Object> actualValues = new HashMap<CharSequence, Object>();
            MessageAnnotations messageAnnotations = new MessageAnnotations(actualValues);
            for (SimpleString name : message.getPropertyNames()) {
                String sName = name.toString();
                if (!sName.startsWith(ProtonUtils.MESSAGE_ANNOTATIONS)) continue;
                Object val = message.getTypedProperties().getProperty(name);
                if (val instanceof SimpleString) {
                    actualValues.put(sName.subSequence(sName.indexOf(ProtonUtils.MESSAGE_ANNOTATIONS), sName.length()), val.toString());
                    continue;
                }
                actualValues.put(sName.subSequence(sName.indexOf(ProtonUtils.MESSAGE_ANNOTATIONS), sName.length()), val);
            }
            return messageAnnotations;
        }

        private static Properties populateProperties(ServerMessage message) {
            Calendar calendar = Calendar.getInstance();
            Properties properties = new Properties();
            TypedProperties typedProperties = message.getTypedProperties();
            properties.setMessageId((Object)message.getMessageID());
            if (message.getAddress() != null) {
                properties.setTo(message.getAddress().toString());
            }
            if (typedProperties.containsProperty(USER_ID_SS)) {
                properties.setUserId(new Binary(typedProperties.getBytesProperty(USER_ID_SS)));
            }
            if (typedProperties.containsProperty(SUBJECT_SS)) {
                properties.setSubject(typedProperties.getSimpleStringProperty(SUBJECT_SS).toString());
            }
            if (typedProperties.containsProperty(REPLY_TO_SS)) {
                properties.setReplyTo(typedProperties.getSimpleStringProperty(REPLY_TO_SS).toString());
            }
            if (typedProperties.containsProperty(CORRELATION_ID_SS)) {
                properties.setCorrelationId((Object)typedProperties.getSimpleStringProperty(CORRELATION_ID_SS).toString());
            }
            if (typedProperties.containsProperty(CONTENT_TYPE_SS)) {
                properties.setContentType(Symbol.getSymbol((String)typedProperties.getSimpleStringProperty(CONTENT_TYPE_SS).toString()));
            }
            if (typedProperties.containsProperty(CONTENT_ENCODING_SS)) {
                properties.setContentEncoding(Symbol.getSymbol((String)typedProperties.getSimpleStringProperty(CONTENT_ENCODING_SS).toString()));
            }
            if (typedProperties.containsProperty(ABSOLUTE_EXPIRY_TIME_SS)) {
                calendar.setTimeInMillis(typedProperties.getLongProperty(ABSOLUTE_EXPIRY_TIME_SS));
                properties.setAbsoluteExpiryTime(calendar.getTime());
            }
            if (typedProperties.containsProperty(CREATION_TIME_SS)) {
                calendar.setTimeInMillis(typedProperties.getLongProperty(CREATION_TIME_SS));
                properties.setCreationTime(calendar.getTime());
            }
            if (typedProperties.containsProperty(GROUP_ID_SS)) {
                properties.setGroupId(typedProperties.getSimpleStringProperty(GROUP_ID_SS).toString());
            }
            if (typedProperties.containsProperty(GROUP_SEQUENCE_SS)) {
                properties.setGroupSequence(new UnsignedInteger(typedProperties.getIntProperty(GROUP_SEQUENCE_SS).intValue()));
            }
            if (typedProperties.containsProperty(REPLY_TO_GROUP_ID_SS)) {
                properties.setReplyToGroupId(typedProperties.getSimpleStringProperty(REPLY_TO_GROUP_ID_SS).toString());
            }
            return properties;
        }

        private static ApplicationProperties populateApplicationProperties(ServerMessage message) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (SimpleString name : message.getPropertyNames()) {
                OUTBOUND.setProperty(name, message.getTypedProperties().getProperty(name), values);
            }
            return new ApplicationProperties(values);
        }

        private static void setProperty(SimpleString name, Object property, HashMap<String, Object> values) {
            String s = name.toString();
            if (SPECIAL_PROPS.contains(s) || s.startsWith(ProtonUtils.MESSAGE_ANNOTATIONS) || s.startsWith(ProtonUtils.DELIVERY_ANNOTATIONS) || s.startsWith(ProtonUtils.FOOTER_VALUES)) {
                return;
            }
            if (property instanceof SimpleString) {
                values.put(s, property.toString());
            } else {
                values.put(s, property);
            }
        }

        private static Footer populateFooter(ServerMessage message) {
            HashMap<CharSequence, Object> actualValues = new HashMap<CharSequence, Object>();
            Footer footer = new Footer(actualValues);
            for (SimpleString name : message.getPropertyNames()) {
                String sName = name.toString();
                if (!sName.startsWith(ProtonUtils.FOOTER_VALUES)) continue;
                Object val = message.getTypedProperties().getProperty(name);
                if (val instanceof SimpleString) {
                    actualValues.put(sName.subSequence(sName.indexOf(ProtonUtils.FOOTER_VALUES), sName.length()), val.toString());
                    continue;
                }
                actualValues.put(sName.subSequence(sName.indexOf(ProtonUtils.FOOTER_VALUES), sName.length()), val);
            }
            return footer;
        }

        private static Section populateBody(ServerMessage message) {
            Integer type = message.getIntProperty(ProtonUtils.MESSAGE_TYPE);
            switch (type) {
                case 0: 
                case 1: {
                    return new Data(new Binary(message.getBodyBuffer().copy().channelBuffer().array()));
                }
                case 2: {
                    return new AmqpValue((Object)new Binary(message.getBodyBuffer().copy().channelBuffer().array()));
                }
                case 3: {
                    return new AmqpValue((Object)message.getBodyBuffer().copy().readNullableString());
                }
            }
            return new Data(new Binary(message.getBodyBuffer().copy().channelBuffer().array()));
        }
    }

    public static class INBOUND {
        public static ServerMessageImpl transform(ProtonRemotingConnection connection, EncodedMessage encodedMessage) throws Exception {
            Message protonMessage = encodedMessage.decode();
            Header header = protonMessage.getHeader();
            if (header == null) {
                header = new Header();
            }
            ServerMessageImpl message = connection.createServerMessage();
            TypedProperties properties = message.getProperties();
            properties.putLongProperty(new SimpleString(ProtonUtils.MESSAGE_FORMAT), encodedMessage.getMessageFormat());
            properties.putLongProperty(new SimpleString(ProtonUtils.PROTON_MESSAGE_FORMAT), ProtonUtils.getMessageFormat(protonMessage.getMessageFormat()));
            properties.putIntProperty(new SimpleString(ProtonUtils.PROTON_MESSAGE_SIZE), encodedMessage.getLength());
            INBOUND.populateSpecialProps(header, protonMessage, message, properties);
            INBOUND.populateHeaderProperties(header, properties, message);
            INBOUND.populateDeliveryAnnotations(protonMessage.getDeliveryAnnotations(), properties);
            INBOUND.populateMessageAnnotations(protonMessage.getMessageAnnotations(), properties);
            INBOUND.populateApplicationProperties(protonMessage.getApplicationProperties(), properties);
            INBOUND.populateProperties(protonMessage.getProperties(), properties, message);
            INBOUND.populateFooterProperties(protonMessage.getFooter(), properties);
            message.setTimestamp(System.currentTimeMillis());
            Section section = protonMessage.getBody();
            if (section instanceof AmqpValue) {
                AmqpValue amqpValue = (AmqpValue)section;
                Object value = amqpValue.getValue();
                if (value instanceof String) {
                    message.getBodyBuffer().writeNullableString((String)value);
                } else if (value instanceof Binary) {
                    Binary binary = (Binary)value;
                    message.getBodyBuffer().writeBytes(binary.getArray());
                }
            } else if (section instanceof Data) {
                message.getBodyBuffer().writeBytes(((Data)section).getValue().getArray());
            }
            return message;
        }

        private static void populateSpecialProps(Header header, Message protonMessage, ServerMessageImpl message, TypedProperties properties) {
            if (header.getFirstAcquirer() != null) {
                properties.putBooleanProperty(new SimpleString(ProtonUtils.FIRST_ACQUIRER), header.getFirstAcquirer().booleanValue());
            }
            properties.putIntProperty(new SimpleString(ProtonUtils.MESSAGE_TYPE), ProtonUtils.getMessageType(protonMessage));
        }

        private static void populateHeaderProperties(Header header, TypedProperties properties, ServerMessageImpl message) {
            if (header.getDurable() != null) {
                message.setDurable(header.getDurable());
            }
            if (header.getPriority() != null) {
                message.setPriority((byte)header.getPriority().intValue());
            }
            if (header.getTtl() != null) {
                message.setExpiration(header.getTtl().longValue());
            }
        }

        private static void populateDeliveryAnnotations(DeliveryAnnotations deliveryAnnotations, TypedProperties properties) {
            if (deliveryAnnotations != null) {
                Map values = deliveryAnnotations.getValue();
                Set keySet = values.keySet();
                for (Object key : keySet) {
                    Symbol symbol = (Symbol)key;
                    Object value = values.get(key);
                    properties.putSimpleStringProperty(new SimpleString(ProtonUtils.DELIVERY_ANNOTATIONS + symbol.toString()), new SimpleString(value.toString()));
                }
            }
        }

        private static void populateFooterProperties(Footer footer, TypedProperties properties) {
            if (footer != null) {
                Map values = footer.getValue();
                Set keySet = values.keySet();
                for (Object key : keySet) {
                    Symbol symbol = (Symbol)key;
                    Object value = values.get(key);
                    properties.putSimpleStringProperty(new SimpleString(ProtonUtils.FOOTER_VALUES + symbol.toString()), new SimpleString(value.toString()));
                }
            }
        }

        private static void populateProperties(Properties amqpProperties, TypedProperties properties, ServerMessageImpl message) {
            if (amqpProperties == null) {
                return;
            }
            if (amqpProperties.getTo() != null) {
                message.setAddress(new SimpleString(amqpProperties.getTo()));
            }
            if (amqpProperties.getUserId() != null) {
                properties.putBytesProperty(USER_ID_SS, amqpProperties.getUserId().getArray());
            }
            if (amqpProperties.getSubject() != null) {
                properties.putSimpleStringProperty(SUBJECT_SS, new SimpleString(amqpProperties.getSubject()));
            }
            if (amqpProperties.getReplyTo() != null) {
                properties.putSimpleStringProperty(REPLY_TO_SS, new SimpleString(amqpProperties.getReplyTo()));
            }
            if (amqpProperties.getCorrelationId() != null) {
                properties.putSimpleStringProperty(CORRELATION_ID_SS, new SimpleString(amqpProperties.getCorrelationId().toString()));
            }
            if (amqpProperties.getContentType() != null) {
                properties.putSimpleStringProperty(CONTENT_TYPE_SS, new SimpleString(amqpProperties.getContentType().toString()));
            }
            if (amqpProperties.getContentEncoding() != null) {
                properties.putSimpleStringProperty(CONTENT_ENCODING_SS, new SimpleString(amqpProperties.getContentEncoding().toString()));
            }
            if (amqpProperties.getAbsoluteExpiryTime() != null) {
                properties.putLongProperty(ABSOLUTE_EXPIRY_TIME_SS, amqpProperties.getAbsoluteExpiryTime().getTime());
            }
            if (amqpProperties.getCreationTime() != null) {
                properties.putLongProperty(CREATION_TIME_SS, amqpProperties.getCreationTime().getTime());
            }
            if (amqpProperties.getGroupId() != null) {
                properties.putSimpleStringProperty(GROUP_ID_SS, new SimpleString(amqpProperties.getGroupId()));
            }
            if (amqpProperties.getGroupSequence() != null) {
                properties.putIntProperty(GROUP_SEQUENCE_SS, amqpProperties.getGroupSequence().intValue());
            }
            if (amqpProperties.getReplyToGroupId() != null) {
                message.getProperties().putSimpleStringProperty(REPLY_TO_GROUP_ID_SS, new SimpleString(amqpProperties.getReplyToGroupId()));
            }
        }

        private static void populateApplicationProperties(ApplicationProperties applicationProperties, TypedProperties properties) {
            if (applicationProperties != null) {
                Map props = applicationProperties.getValue();
                for (Object key : props.keySet()) {
                    Object val = props.get(key);
                    INBOUND.setProperty(key, val, properties);
                }
            }
        }

        private static void setProperty(Object key, Object val, TypedProperties properties) {
            if (val instanceof String) {
                properties.putSimpleStringProperty(new SimpleString((String)key), new SimpleString((String)val));
            } else if (val instanceof Boolean) {
                properties.putBooleanProperty(new SimpleString((String)key), ((Boolean)val).booleanValue());
            } else if (val instanceof Double) {
                properties.putDoubleProperty(new SimpleString((String)key), ((Double)val).doubleValue());
            } else if (val instanceof Float) {
                properties.putFloatProperty(new SimpleString((String)key), ((Float)val).floatValue());
            } else if (val instanceof Integer) {
                properties.putIntProperty(new SimpleString((String)key), ((Integer)val).intValue());
            } else if (val instanceof Byte) {
                properties.putByteProperty(new SimpleString((String)key), ((Byte)val).byteValue());
            }
        }

        public static void populateMessageAnnotations(MessageAnnotations messageAnnotations, TypedProperties properties) {
            if (messageAnnotations != null) {
                Map values = messageAnnotations.getValue();
                Set keySet = values.keySet();
                for (Object key : keySet) {
                    Symbol symbol = (Symbol)key;
                    Object value = values.get(key);
                    properties.putSimpleStringProperty(new SimpleString(ProtonUtils.MESSAGE_ANNOTATIONS + symbol.toString()), new SimpleString(value.toString()));
                }
            }
        }
    }
}

