/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.persistenceprovider;

import java.util.ServiceLoader;
import javax.persistence.spi.PersistenceProvider;
import org.jboss.as.jpa.config.Configuration;
import org.jboss.as.jpa.persistenceprovider.PersistenceProviderResolverImpl;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

public class PersistenceProviderLoader {
    public static void loadDefaultProvider() throws ModuleLoadException {
        String defaultProviderModule = Configuration.getDefaultProviderModuleName();
        PersistenceProviderLoader.loadProviderModuleByName(defaultProviderModule);
    }

    public static void loadProviderModuleByName(String moduleName) throws ModuleLoadException {
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        Module module = moduleLoader.loadModule(ModuleIdentifier.fromString((String)moduleName));
        ServiceLoader serviceLoader = module.loadService(PersistenceProvider.class);
        if (serviceLoader != null) {
            for (PersistenceProvider provider1 : serviceLoader) {
                PersistenceProviderResolverImpl.getInstance().addPersistenceProvider(provider1);
            }
        }
    }
}

