/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import org.jboss.as.jpa.config.PersistenceProviderDeploymentHolder;
import org.jboss.as.jpa.processor.JpaAttachments;
import org.jboss.as.jpa.processor.PersistenceProviderHandler;
import org.jboss.as.jpa.processor.PersistenceUnitServiceHandler;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;

public class PersistenceCompleteInstallProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        if (PersistenceCompleteInstallProcessor.deploymentHasPersistenceProvider(phaseContext.getDeploymentUnit())) {
            PersistenceProviderHandler.finishDeploy(phaseContext);
        }
        PersistenceUnitServiceHandler.deploy(phaseContext, false);
    }

    public void undeploy(DeploymentUnit context) {
        PersistenceUnitServiceHandler.undeploy(context);
    }

    private static boolean deploymentHasPersistenceProvider(DeploymentUnit deploymentUnit) {
        PersistenceProviderDeploymentHolder persistenceProviderDeploymentHolder = (PersistenceProviderDeploymentHolder)(deploymentUnit = DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit)).getAttachment(JpaAttachments.DEPLOYED_PERSISTENCE_PROVIDER);
        return persistenceProviderDeploymentHolder != null && persistenceProviderDeploymentHolder.getProvider() != null ? persistenceProviderDeploymentHolder.getProvider().size() > 0 : false;
    }
}

