/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.impl.backing;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.IdentifierFactory;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntry;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStore;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStoreConfig;
import org.jboss.as.ejb3.cache.spi.GroupCompatibilityChecker;
import org.jboss.as.ejb3.cache.spi.PersistentObjectStore;
import org.jboss.as.ejb3.cache.spi.impl.AbstractBackingCacheEntryStore;
import org.jboss.as.ejb3.cache.spi.impl.CacheableTimestamp;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.NodeAffinity;

public class SimpleBackingCacheEntryStore<K extends Serializable, V extends Cacheable<K>, E extends BackingCacheEntry<K, V>>
extends AbstractBackingCacheEntryStore<K, V, E> {
    private final IdentifierFactory<K> identifierFactory;
    private final PersistentObjectStore<K, E> store;
    private final Map<K, EntryHolder> cache = new ConcurrentHashMap<K, EntryHolder>();
    private final SortedSet<CacheableTimestamp<K>> entries = new ConcurrentSkipListSet<CacheableTimestamp<K>>();
    private final ServerEnvironment environment;

    public SimpleBackingCacheEntryStore(IdentifierFactory<K> identifierFactory, PersistentObjectStore<K, E> store, ServerEnvironment environment, StatefulTimeoutInfo timeout, BackingCacheEntryStoreConfig config) {
        super(timeout, config);
        this.identifierFactory = identifierFactory;
        this.store = store;
        this.environment = environment;
    }

    @Override
    public K createIdentifier() {
        return (K)((Serializable)this.identifierFactory.createIdentifier());
    }

    @Override
    public Affinity getStrictAffinity() {
        return new NodeAffinity(this.environment.getNodeName());
    }

    @Override
    public Affinity getWeakAffinity(K key) {
        return Affinity.NONE;
    }

    @Override
    public boolean hasAffinity(K key) {
        return true;
    }

    @Override
    public boolean isClustered() {
        return false;
    }

    @Override
    public E get(K key, boolean lock) {
        EntryHolder holder = this.cache.get(key);
        if (holder == null) {
            BackingCacheEntry value = (BackingCacheEntry)this.store.load(key);
            if (value != null) {
                CacheableTimestamp timestamp = new CacheableTimestamp(value);
                this.cache.put(key, new EntryHolder(this, value, timestamp));
                this.entries.add(timestamp);
            }
            return (E)value;
        }
        return (E)holder.value;
    }

    @Override
    public Set<K> insert(E entry) {
        Serializable key = (Serializable)entry.getId();
        if (this.cache.containsKey(key)) {
            throw EjbMessages.MESSAGES.duplicateCacheEntry(key);
        }
        CacheableTimestamp timestamp = new CacheableTimestamp(entry);
        this.cache.put(key, new EntryHolder(this, (BackingCacheEntry)entry, timestamp));
        this.entries.add(timestamp);
        HashSet toPassivate = new HashSet();
        int maxSize = this.getConfig().getMaxSize();
        int thisSize = this.cache.size();
        if (thisSize > maxSize) {
            int remaining = thisSize - maxSize;
            Iterator iterator = this.entries.iterator();
            while (remaining > 0 && iterator.hasNext()) {
                EntryHolder holder = this.cache.get(((CacheableTimestamp)iterator.next()).getId());
                if (holder == null || ((Serializable)holder.value.getId()).equals(timestamp.getId()) || holder.value.isInUse()) continue;
                --remaining;
                toPassivate.add(holder.value.getId());
            }
        }
        return toPassivate;
    }

    @Override
    public void update(E entry, boolean modified) {
        Serializable key = (Serializable)entry.getId();
        if (!this.cache.containsKey(key)) {
            throw EjbMessages.MESSAGES.missingCacheEntry(key);
        }
        this.update(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void passivate(E entry) {
        E e = entry;
        synchronized (e) {
            Serializable key = (Serializable)entry.getId();
            this.store.store(entry);
            EntryHolder holder = this.cache.remove(key);
            if (holder != null) {
                this.remove(holder.timestamp);
            }
        }
    }

    @Override
    public E remove(K id) {
        EntryHolder holder;
        E entry = this.get(id, false);
        if (entry != null && (holder = this.cache.remove(id)) != null) {
            this.remove(holder.timestamp);
        }
        return entry;
    }

    @Override
    private void remove(CacheableTimestamp<K> timestamp) {
        this.entries.remove(timestamp);
    }

    private void update(E entry) {
        CacheableTimestamp timestamp = new CacheableTimestamp(entry);
        EntryHolder holder = this.cache.get(entry.getId());
        if (holder != null) {
            this.entries.remove(holder.timestamp);
        }
        this.cache.put(entry.getId(), new EntryHolder(this, (BackingCacheEntry)entry, timestamp));
        this.entries.add(timestamp);
    }

    @Override
    public void start() {
        this.store.start();
    }

    @Override
    public void stop() {
        this.store.stop();
    }

    @Override
    public boolean isCompatibleWith(GroupCompatibilityChecker other) {
        if (other instanceof BackingCacheEntryStore) {
            return !((BackingCacheEntryStore)other).isClustered();
        }
        return false;
    }

    @Override
    public int getStoreSize() {
        return this.cache.size();
    }

    @Override
    public int getPassivatedCount() {
        return this.store.getStoreSize();
    }

    private static final class EntryHolder {
        private final CacheableTimestamp<K> timestamp;
        private final E value;
        final /* synthetic */ SimpleBackingCacheEntryStore this$0;

        private EntryHolder(E value, CacheableTimestamp<K> timestamp) {
            this.this$0 = var1_1;
            this.value = value;
            this.timestamp = timestamp;
        }
    }
}

