/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity.interceptors;

import javax.ejb.EJBException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentInstanceInterceptorFactory;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.as.ejb3.component.entity.interceptors.InternalInvocationMarker;
import org.jboss.as.ejb3.component.interceptors.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.stateful.CurrentSynchronizationCallback;
import org.jboss.as.ejb3.tx.OwnableReentrantLock;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class EntityBeanSynchronizationInterceptor
extends AbstractEJBInterceptor {
    private final Object threadLock = new Object();
    private final OwnableReentrantLock lock = new OwnableReentrantLock();
    public static final InterceptorFactory FACTORY = new ComponentInstanceInterceptorFactory(){

        protected Interceptor create(Component component, InterceptorFactoryContext context) {
            return new EntityBeanSynchronizationInterceptor();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        EntityBeanComponent component = EntityBeanSynchronizationInterceptor.getComponent(context, EntityBeanComponent.class);
        EntityBeanComponentInstance instance = (EntityBeanComponentInstance)((Object)context.getPrivateData(ComponentInstance.class));
        if (instance.getPrimaryKey() == null) {
            return context.proceed();
        }
        TransactionSynchronizationRegistry transactionSynchronizationRegistry = component.getTransactionSynchronizationRegistry();
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.trace("Trying to acquire lock: " + this.lock + " for entity bean " + (Object)((Object)instance) + " during invocation: " + context);
        }
        Object lockOwner = this.getLockOwner(transactionSynchronizationRegistry);
        this.lock.pushOwner(lockOwner);
        try {
            this.lock.lock();
            boolean syncRegistered = false;
            OwnableReentrantLock ownableReentrantLock = this.lock;
            synchronized (ownableReentrantLock) {
                Object object;
                block22: {
                    if (instance.isReloadRequired()) {
                        instance.reload();
                    }
                    if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                        EjbLogger.ROOT_LOGGER.trace("Acquired lock: " + this.lock + " for entity bean instance: " + (Object)((Object)instance) + " during invocation: " + context);
                    }
                    if (context.getPrivateData(InternalInvocationMarker.class) == null && (instance.isRemoved() || instance.isDiscarded())) {
                        Object primaryKey = context.getPrivateData(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY);
                        component.getCache().release(instance, true);
                        this.lock.unlock();
                        throw EjbMessages.MESSAGES.instanceWasRemoved(component.getComponentName(), primaryKey);
                    }
                    Object currentTransactionKey = null;
                    try {
                        currentTransactionKey = transactionSynchronizationRegistry.getTransactionKey();
                        if (!instance.isSynchronizeRegistered()) {
                            if (currentTransactionKey != null) {
                                EntityBeanSynchronization entitySynchronization = new EntityBeanSynchronization(instance, lockOwner);
                                transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)entitySynchronization);
                                syncRegistered = true;
                                if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                                    EjbLogger.ROOT_LOGGER.trace("Registered tx synchronization: " + entitySynchronization + " for tx: " + currentTransactionKey + " associated with stateful component instance: " + (Object)((Object)instance));
                                }
                            }
                            instance.setSynchronizationRegistered(true);
                        }
                        object = context.proceed();
                        if (currentTransactionKey == null) {
                            instance.store();
                            this.releaseInstance(instance, true);
                            break block22;
                        }
                        if (syncRegistered) break block22;
                        component.getCache().release(instance, true);
                        this.lock.unlock();
                    }
                    catch (Throwable throwable) {
                        if (currentTransactionKey == null) {
                            instance.store();
                            this.releaseInstance(instance, true);
                        } else if (!syncRegistered) {
                            component.getCache().release(instance, true);
                            this.lock.unlock();
                        }
                        throw throwable;
                    }
                }
                return object;
            }
        }
        finally {
            this.lock.popOwner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInstance(EntityBeanComponentInstance instance, boolean success) {
        try {
            instance.getComponent().getCache().release(instance, success);
        }
        finally {
            instance.setSynchronizationRegistered(false);
            this.releaseLock();
        }
    }

    private void releaseLock() {
        this.lock.unlock();
        if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
            EjbLogger.ROOT_LOGGER.trace("Released lock: " + this.lock);
        }
    }

    private Object getLockOwner(TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        Object owner = transactionSynchronizationRegistry.getTransactionKey();
        return owner != null ? owner : Thread.currentThread();
    }

    private class EntityBeanSynchronization
    implements Synchronization {
        private final EntityBeanComponentInstance componentInstance;
        private final Object lockOwner;

        EntityBeanSynchronization(EntityBeanComponentInstance componentInstance, Object lockOwner) {
            this.componentInstance = componentInstance;
            this.lockOwner = lockOwner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeCompletion() {
            try {
                CurrentSynchronizationCallback.set(CurrentSynchronizationCallback.CallbackType.BEFORE_COMPLETION);
                Object object = EntityBeanSynchronizationInterceptor.this.threadLock;
                synchronized (object) {
                    try {
                        if (!this.componentInstance.isRemoved() && !this.componentInstance.isDiscarded() && this.componentInstance.getPrimaryKey() != null) {
                            this.componentInstance.store();
                        }
                    }
                    catch (Throwable t) {
                        EntityBeanSynchronizationInterceptor.this.lock.pushOwner(this.lockOwner);
                        try {
                            this.handleThrowableInTxSync(this.componentInstance, t);
                        }
                        finally {
                            EntityBeanSynchronizationInterceptor.this.lock.popOwner();
                        }
                    }
                }
            }
            finally {
                CurrentSynchronizationCallback.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            EntityBeanSynchronizationInterceptor.this.lock.pushOwner(this.lockOwner);
            try {
                boolean success;
                boolean bl = success = status != 1 && status != 4 && status != 9;
                if (!success) {
                    this.componentInstance.setReloadRequired(true);
                }
                EntityBeanSynchronizationInterceptor.this.releaseInstance(this.componentInstance, success);
            }
            catch (Exception e) {
                EjbLogger.EJB3_LOGGER.exceptionReleasingEntity(e);
            }
            finally {
                EntityBeanSynchronizationInterceptor.this.lock.popOwner();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Error handleThrowableInTxSync(EntityBeanComponentInstance instance, Throwable t) {
            EjbLogger.ROOT_LOGGER.discardingEntityComponent(instance, t);
            try {
                instance.discard();
            }
            finally {
                EntityBeanSynchronizationInterceptor.this.releaseLock();
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw (EJBException)new EJBException().initCause(t);
        }
    }
}

