/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.terminal.CursorPosition;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.terminal.TerminalCharacter;
import org.jboss.aesh.util.ANSI;

public abstract class AbstractTerminal
implements Terminal {
    private Logger logger;

    AbstractTerminal(Logger logger2) {
        this.logger = logger2;
    }

    @Override
    public void writeChar(TerminalCharacter character) throws IOException {
        this.writeToStdOut(character.getAsString());
    }

    @Override
    public void writeChars(List<TerminalCharacter> chars) throws IOException {
        StringBuilder builder = new StringBuilder();
        TerminalCharacter prev = null;
        for (TerminalCharacter c : chars) {
            if (prev == null) {
                builder.append(c.getAsString());
            } else {
                builder.append(c.getAsString(prev));
            }
            prev = c;
        }
        this.writeToStdOut(builder.toString());
    }

    @Override
    public CursorPosition getCursor() {
        if (Settings.getInstance().isAnsiConsole() && Config.isOSPOSIXCompatible()) {
            try {
                int row;
                this.writeToStdOut(ANSI.getCurrentCursorPos());
                StringBuilder builder = new StringBuilder(8);
                while ((row = this.read(false)[0]) > -1 && row != 82) {
                    if (row == 27 || row == 91) continue;
                    builder.append((char)row);
                }
                return new CursorPosition(Integer.parseInt(builder.substring(0, builder.indexOf(";"))), Integer.parseInt(builder.substring(builder.lastIndexOf(";") + 1, builder.length())));
            }
            catch (Exception e) {
                if (Settings.getInstance().isLogging()) {
                    this.logger.log(Level.SEVERE, "Failed to find current row with ansi code: ", e);
                }
                return new CursorPosition(-1, -1);
            }
        }
        return new CursorPosition(-1, -1);
    }

    @Override
    public void setCursor(CursorPosition position) throws IOException {
        if (this.getSize().isPositionWithinSize(position)) {
            this.writeToStdOut(position.asAnsi());
        }
    }

    @Override
    public void moveCursor(int rows, int columns) throws IOException {
        CursorPosition cp = this.getCursor();
        cp.move(rows, columns);
        if (this.getSize().isPositionWithinSize(cp)) {
            this.setCursor(cp);
        }
    }

    @Override
    public void clear() throws IOException {
        this.writeToStdOut(ANSI.clearScreen());
    }
}

