/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.jboss.threads.JBossThreadFactory;

public class ClientConfigurationImpl
implements ModelControllerClientConfiguration {
    private static final int DEFAULT_MAX_THREADS = ClientConfigurationImpl.getSystemProperty("org.jboss.as.controller.client.max-threads", 6);
    private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private static final AtomicInteger executorCount = new AtomicInteger();
    private final String address;
    private final int port;
    private final CallbackHandler handler;
    private final Map<String, String> saslOptions;
    private final SSLContext sslContext;
    private final ExecutorService executorService;
    private final String protocol;
    private boolean shutdownExecutor;
    private final int connectionTimeout;

    static ExecutorService createDefaultExecutor() {
        ThreadGroup group = new ThreadGroup("management-client-thread");
        JBossThreadFactory threadFactory = new JBossThreadFactory(group, Boolean.FALSE, null, "%G " + executorCount.incrementAndGet() + "-%t", null, null, AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

            @Override
            public AccessControlContext run() {
                return AccessController.getContext();
            }
        }));
        return new ThreadPoolExecutor(2, DEFAULT_MAX_THREADS, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    protected ClientConfigurationImpl(String address, int port, CallbackHandler handler, Map<String, String> saslOptions, SSLContext sslContext, ExecutorService executorService, String protocol) {
        this(address, port, handler, saslOptions, sslContext, executorService, false, 5000, protocol);
    }

    protected ClientConfigurationImpl(String address, int port, CallbackHandler handler, Map<String, String> saslOptions, SSLContext sslContext, ExecutorService executorService, boolean shutdownExecutor, String protocol) {
        this(address, port, handler, saslOptions, sslContext, executorService, shutdownExecutor, 5000, protocol);
    }

    protected ClientConfigurationImpl(String address, int port, CallbackHandler handler, Map<String, String> saslOptions, SSLContext sslContext, ExecutorService executorService, boolean shutdownExecutor, int connectionTimeout, String protocol) {
        this.address = address;
        this.port = port;
        this.handler = handler;
        this.saslOptions = saslOptions;
        this.sslContext = sslContext;
        this.executorService = executorService;
        this.shutdownExecutor = shutdownExecutor;
        this.protocol = protocol;
        this.connectionTimeout = connectionTimeout > 0 ? connectionTimeout : 5000;
    }

    @Override
    public String getHost() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        return this.handler;
    }

    @Override
    public Map<String, String> getSaslOptions() {
        return this.saslOptions;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public ExecutorService getExecutor() {
        return this.executorService;
    }

    @Override
    public void close() {
        if (this.shutdownExecutor && this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    public static ModelControllerClientConfiguration create(InetAddress address, int port) {
        return new ClientConfigurationImpl(address.getHostName(), port, null, null, null, ClientConfigurationImpl.createDefaultExecutor(), true, null);
    }

    public static ModelControllerClientConfiguration create(String protocol, InetAddress address, int port) {
        return new ClientConfigurationImpl(address.getHostName(), port, null, null, null, ClientConfigurationImpl.createDefaultExecutor(), true, protocol);
    }

    public static ModelControllerClientConfiguration create(InetAddress address, int port, CallbackHandler handler) {
        return new ClientConfigurationImpl(address.getHostName(), port, handler, null, null, ClientConfigurationImpl.createDefaultExecutor(), true, null);
    }

    public static ModelControllerClientConfiguration create(String protocol, InetAddress address, int port, CallbackHandler handler) {
        return new ClientConfigurationImpl(address.getHostName(), port, handler, null, null, ClientConfigurationImpl.createDefaultExecutor(), true, protocol);
    }

    public static ModelControllerClientConfiguration create(InetAddress address, int port, CallbackHandler handler, Map<String, String> saslOptions) {
        return new ClientConfigurationImpl(address.getHostName(), port, handler, saslOptions, null, ClientConfigurationImpl.createDefaultExecutor(), true, null);
    }

    public static ModelControllerClientConfiguration create(String protocol, InetAddress address, int port, CallbackHandler handler, Map<String, String> saslOptions) {
        return new ClientConfigurationImpl(address.getHostName(), port, handler, saslOptions, null, ClientConfigurationImpl.createDefaultExecutor(), true, protocol);
    }

    public static ModelControllerClientConfiguration create(String hostName, int port) throws UnknownHostException {
        return new ClientConfigurationImpl(hostName, port, null, null, null, ClientConfigurationImpl.createDefaultExecutor(), true, null);
    }

    public static ModelControllerClientConfiguration create(String protocol, String hostName, int port) throws UnknownHostException {
        return new ClientConfigurationImpl(hostName, port, null, null, null, ClientConfigurationImpl.createDefaultExecutor(), true, protocol);
    }

    public static ModelControllerClientConfiguration create(String hostName, int port, CallbackHandler handler) throws UnknownHostException {
        return new ClientConfigurationImpl(hostName, port, handler, null, null, ClientConfigurationImpl.createDefaultExecutor(), true, null);
    }

    public static ModelControllerClientConfiguration create(String protocol, String hostName, int port, CallbackHandler handler) throws UnknownHostException {
        return new ClientConfigurationImpl(hostName, port, handler, null, null, ClientConfigurationImpl.createDefaultExecutor(), true, protocol);
    }

    public static ModelControllerClientConfiguration create(String hostName, int port, CallbackHandler handler, SSLContext sslContext) throws UnknownHostException {
        return new ClientConfigurationImpl(hostName, port, handler, null, sslContext, ClientConfigurationImpl.createDefaultExecutor(), true, null);
    }

    public static ModelControllerClientConfiguration create(String protocol, String hostName, int port, CallbackHandler handler, SSLContext sslContext) throws UnknownHostException {
        return new ClientConfigurationImpl(hostName, port, handler, null, sslContext, ClientConfigurationImpl.createDefaultExecutor(), true, protocol);
    }

    public static ModelControllerClientConfiguration create(String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout) throws UnknownHostException {
        return new ClientConfigurationImpl(hostName, port, handler, null, sslContext, ClientConfigurationImpl.createDefaultExecutor(), true, connectionTimeout, null);
    }

    public static ModelControllerClientConfiguration create(String protocol, String hostName, int port, CallbackHandler handler, SSLContext sslContext, int connectionTimeout) throws UnknownHostException {
        return new ClientConfigurationImpl(hostName, port, handler, null, sslContext, ClientConfigurationImpl.createDefaultExecutor(), true, connectionTimeout, protocol);
    }

    public static ModelControllerClientConfiguration create(String hostName, int port, CallbackHandler handler, Map<String, String> saslOptions) throws UnknownHostException {
        return new ClientConfigurationImpl(hostName, port, handler, saslOptions, null, ClientConfigurationImpl.createDefaultExecutor(), true, null);
    }

    public static ModelControllerClientConfiguration create(String protocol, String hostName, int port, CallbackHandler handler, Map<String, String> saslOptions) throws UnknownHostException {
        return new ClientConfigurationImpl(hostName, port, handler, saslOptions, null, ClientConfigurationImpl.createDefaultExecutor(), true, protocol);
    }

    private static int getSystemProperty(String name, int defaultValue) {
        String value = ClientConfigurationImpl.getStringProperty(name);
        try {
            return value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    private static String getStringProperty(final String name) {
        return System.getSecurityManager() == null ? System.getProperty(name) : AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        });
    }
}

