/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PredicateHandler;
import io.undertow.server.handlers.RedirectHandler;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import java.util.Locale;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

class ErrorContextHandler {
    private static final String INDEX_HTML = "index.html";
    private static final String INDEX_WIN_HTML = "index_win.html";
    private static final String ERROR_MODULE = "org.jboss.as.domain-http-error-context";
    static final String ERROR_CONTEXT = "/error";
    private static final String DEFAULT_RESOURCE;

    private ErrorContextHandler() {
    }

    public static HttpHandler createErrorContext(String slot) throws ModuleLoadException {
        ClassPathResourceManager cpresource = new ClassPathResourceManager(ErrorContextHandler.getClassLoader(Module.getCallerModuleLoader(), ERROR_MODULE, slot), "");
        ResourceHandler handler = new ResourceHandler().setAllowed(Predicates.not((Predicate)Predicates.path((String)"META-INF"))).setResourceManager((ResourceManager)cpresource).setDirectoryListingEnabled(false).setCachable(Predicates.falsePredicate());
        PredicateHandler predicateHandler = new PredicateHandler(Predicates.path((String)""), (HttpHandler)new RedirectHandler(ERROR_CONTEXT + DEFAULT_RESOURCE), (HttpHandler)handler);
        return predicateHandler;
    }

    private static ClassLoader getClassLoader(ModuleLoader moduleLoader, String module, String slot) throws ModuleLoadException {
        ModuleIdentifier id = ModuleIdentifier.create((String)module, (String)slot);
        ModuleClassLoader cl = moduleLoader.loadModule(id).getClassLoader();
        return cl;
    }

    static {
        String os = System.getProperty("os.name");
        DEFAULT_RESOURCE = os != null && os.toLowerCase(Locale.ENGLISH).contains("win") ? "/index_win.html" : "/index.html";
    }
}

