/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.jboss.as.controller.security.AccessMechanismPrincipal;
import org.jboss.as.controller.security.InetAddressPrincipal;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.as.domain.http.server.security.SubjectAccount;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SubjectDoAsHandler
implements HttpHandler {
    private final HttpHandler wrapped;

    public SubjectDoAsHandler(HttpHandler toWrap) {
        this.wrapped = toWrap;
    }

    public void handleRequest(final HttpServerExchange exchange) throws Exception {
        Account account;
        SecurityContext securityContext = (SecurityContext)exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        Subject useSubject = null;
        if (securityContext != null && (account = securityContext.getAuthenticatedAccount()) instanceof SubjectAccount) {
            PrivilegedAction<Subject> copyAction = new PrivilegedAction<Subject>(){

                @Override
                public Subject run() {
                    Subject subject = ((SubjectAccount)account).getSubject();
                    Subject copySubject = new Subject();
                    copySubject.getPrincipals().addAll(subject.getPrincipals());
                    copySubject.getPrivateCredentials().addAll(subject.getPrivateCredentials());
                    copySubject.getPublicCredentials().addAll(subject.getPublicCredentials());
                    SocketAddress address = exchange.getConnection().getPeerAddress();
                    if (address instanceof InetSocketAddress) {
                        copySubject.getPrincipals().add((Principal)new InetAddressPrincipal(((InetSocketAddress)address).getAddress()));
                    }
                    copySubject.getPrincipals().add((Principal)new AccessMechanismPrincipal(AccessMechanism.HTTP));
                    copySubject.setReadOnly();
                    return copySubject;
                }
            };
            useSubject = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(copyAction) : (Subject)copyAction.run();
        }
        this.handleRequest(exchange, useSubject);
    }

    void handleRequest(final HttpServerExchange exchange, Subject subject) throws Exception {
        if (subject != null) {
            try {
                Subject.doAs(subject, new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        SubjectDoAsHandler.this.wrapped.handleRequest(exchange);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        } else {
            this.wrapped.handleRequest(exchange);
        }
    }
}

