/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso;

import org.infinispan.Cache;
import org.wildfly.clustering.web.Batcher;
import org.wildfly.clustering.web.infinispan.sso.SSOFactory;
import org.wildfly.clustering.web.sso.SSO;
import org.wildfly.clustering.web.sso.SSOManager;

public class InfinispanSSOManager<V, L>
implements SSOManager<L>,
Batcher {
    private final SSOFactory<V, L> factory;
    private final Cache<String, V> cache;

    public InfinispanSSOManager(SSOFactory<V, L> factory, Cache<String, V> cache) {
        this.factory = factory;
        this.cache = cache;
    }

    public SSO<L> createSSO(String ssoId) {
        return this.factory.createSSO(ssoId, this.factory.createValue(ssoId));
    }

    public SSO<L> findSSO(String ssoId) {
        Object value = this.factory.findValue(ssoId);
        return value != null ? this.factory.createSSO(ssoId, value) : null;
    }

    public boolean startBatch() {
        return this.cache.startBatch();
    }

    public void endBatch(boolean successful) {
        this.cache.endBatch(successful);
    }

    public Batcher getBatcher() {
        return this;
    }
}

