/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deploymentoverlay;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.constraint.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.server.deploymentoverlay.ContentDefinition;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayAdd;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayDeploymentDefinition;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayModel;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayRemove;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayPriority;

public class DeploymentOverlayDefinition
extends SimpleResourceDefinition {
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[0];
    private final DeploymentOverlayPriority priority;
    private final ContentRepository contentRepo;
    private final DeploymentFileRepository fileRepository;

    public static AttributeDefinition[] attributes() {
        return (AttributeDefinition[])ATTRIBUTES.clone();
    }

    public DeploymentOverlayDefinition(DeploymentOverlayPriority priority, ContentRepository contentRepo, DeploymentFileRepository fileRepository) {
        super(DeploymentOverlayModel.DEPLOYMENT_OVERRIDE_PATH, ControllerResolver.getResolver((String[])new String[]{"deployment-overlay"}), (OperationStepHandler)DeploymentOverlayAdd.INSTANCE, (OperationStepHandler)DeploymentOverlayRemove.INSTANCE);
        this.priority = priority;
        this.contentRepo = contentRepo;
        this.fileRepository = fileRepository;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadOnlyAttribute(attr, null);
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        if (this.contentRepo != null) {
            resourceRegistration.registerSubModel((ResourceDefinition)new ContentDefinition(this.contentRepo, this.fileRepository));
        }
        if (this.priority != null) {
            resourceRegistration.registerSubModel((ResourceDefinition)new DeploymentOverlayDeploymentDefinition(this.priority));
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return ApplicationTypeAccessConstraintDefinition.DEPLOYMENT_AS_LIST;
    }
}

