/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.as.clustering.concurrent.ComparableRunnableFuture;
import org.jboss.as.clustering.marshalling.DynamicClassTable;
import org.jboss.as.clustering.marshalling.MarshallingConfigurationFactory;
import org.jboss.as.clustering.marshalling.MarshallingContext;
import org.jboss.as.clustering.marshalling.VersionedMarshallingConfiguration;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;
import org.jboss.threads.JBossThreadFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.mux.MuxMessageDispatcher;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.Node;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.dispatcher.MembershipListener;
import org.wildfly.clustering.server.SimpleNode;
import org.wildfly.clustering.server.dispatcher.CommandMarshaller;
import org.wildfly.clustering.server.dispatcher.CommandResponseMarshaller;
import org.wildfly.clustering.server.dispatcher.NodeRegistry;
import org.wildfly.clustering.server.dispatcher.ServiceCommandDispatcher;
import org.wildfly.security.manager.GetAccessControlContextAction;

public class CommandDispatcherFactoryService
implements CommandDispatcherFactory,
RequestHandler,
Service<CommandDispatcherFactory>,
org.jgroups.MembershipListener,
NodeRegistry,
VersionedMarshallingConfiguration {
    private static final short SCOPE_ID = 222;
    private static final int CURRENT_VERSION = 1;
    final MarshallingContext marshallingContext = new MarshallingContext((VersionedMarshallingConfiguration)this);
    final Map<ServiceName, Map.Entry<Object, MembershipListener>> services = new ConcurrentHashMap<ServiceName, Map.Entry<Object, MembershipListener>>();
    final ConcurrentMap<Address, Node> nodes = new ConcurrentHashMap<Address, Node>();
    private final Map<Integer, MarshallingConfiguration> configurations = new HashMap<Integer, MarshallingConfiguration>();
    private final Value<Channel> channel;
    private final Value<ModuleLoader> loader;
    private final ModuleIdentifier moduleId;
    private volatile ExecutorService executor;
    private volatile MessageDispatcher dispatcher;
    volatile Set<Node> view = Collections.emptySet();
    private volatile long timeout = TimeUnit.MINUTES.toMillis(1L);

    public CommandDispatcherFactoryService(Value<Channel> channel, Value<ModuleLoader> loader, ModuleIdentifier moduleId) {
        this.channel = channel;
        this.loader = loader;
        this.moduleId = moduleId;
    }

    public <C> CommandDispatcher<C> createCommandDispatcher(ServiceName service, C context) {
        return this.createCommandDispatcher(service, context, null);
    }

    public <C> CommandDispatcher<C> createCommandDispatcher(final ServiceName service, C context, MembershipListener listener) {
        boolean version = true;
        CommandMarshaller marshaller = new CommandMarshaller<C>(){

            @Override
            public <R> byte[] marshal(Command<R, C> command) throws IOException {
                try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                    output.write(1);
                    try (Marshaller marshaller = CommandDispatcherFactoryService.this.marshallingContext.createMarshaller(1);){
                        marshaller.start(Marshalling.createByteOutput((OutputStream)output));
                        marshaller.writeUTF(service.getCanonicalName());
                        marshaller.writeObject(command);
                        marshaller.flush();
                    }
                    byte[] byArray = output.toByteArray();
                    return byArray;
                }
            }
        };
        this.services.put(service, new AbstractMap.SimpleImmutableEntry<C, MembershipListener>(context, listener));
        return new ServiceCommandDispatcher<C>(this.dispatcher, marshaller, this, this.timeout){

            public void close() {
                CommandDispatcherFactoryService.this.services.remove(service);
            }
        };
    }

    public CommandDispatcherFactory getValue() {
        return this;
    }

    public void start(StartContext context) throws StartException {
        ModuleLoader loader = (ModuleLoader)this.loader.getValue();
        MarshallingConfiguration config = MarshallingConfigurationFactory.createMarshallingConfiguration((ModuleLoader)loader);
        try {
            Module module = loader.loadModule(this.moduleId);
            config.setClassTable((ClassTable)new DynamicClassTable((ClassLoader)module.getClassLoader()));
            this.configurations.put(1, config);
        }
        catch (ModuleLoadException e) {
            throw new StartException((Throwable)e);
        }
        ThreadGroup group = new ThreadGroup(CommandDispatcherFactoryService.class.getSimpleName());
        JBossThreadFactory factory = new JBossThreadFactory(group, Boolean.FALSE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new PriorityBlockingQueue(2), (ThreadFactory)factory){

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
                ComparableRunnableFuture future = super.newTaskFor(runnable, value);
                return runnable instanceof ViewTask ? new ComparableRunnableFuture((RunnableFuture)future, (Comparable)((ViewTask)runnable)) : future;
            }
        };
        Channel channel = (Channel)this.channel.getValue();
        final CommandResponseMarshaller marshaller = new CommandResponseMarshaller(this.marshallingContext, 1);
        this.dispatcher = new MuxMessageDispatcher(222){

            protected RequestCorrelator createRequestCorrelator(Protocol transport, RequestHandler handler, Address localAddr) {
                RequestCorrelator correlator = super.createRequestCorrelator(transport, handler, localAddr);
                correlator.setMarshaller(marshaller);
                return correlator;
            }
        };
        this.dispatcher.setChannel(channel);
        this.dispatcher.setRequestHandler((RequestHandler)this);
        this.dispatcher.setMembershipListener((org.jgroups.MembershipListener)this);
        this.dispatcher.start();
        new ViewTask(channel.getView()).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        try {
            this.dispatcher.stop();
        }
        finally {
            this.executor.shutdown();
            this.configurations.clear();
            this.nodes.clear();
            this.view = Collections.emptySet();
        }
    }

    public int getCurrentMarshallingVersion() {
        return 1;
    }

    public MarshallingConfiguration getMarshallingConfiguration(int version) {
        MarshallingConfiguration configuration = this.configurations.get(version);
        if (configuration == null) {
            throw new IllegalArgumentException(Integer.toString(version));
        }
        return configuration;
    }

    @Override
    public Node getNode(Address address) {
        Node existing;
        Node node = (Node)this.nodes.get(address);
        if (node != null) {
            return node;
        }
        Channel channel = this.dispatcher.getChannel();
        IpAddress ipAddress = (IpAddress)channel.down(new Event(87, (Object)address));
        InetSocketAddress socketAddress = new InetSocketAddress(ipAddress.getIpAddress(), ipAddress.getPort());
        String name = channel.getName(address);
        if (name == null) {
            name = String.format("%s:%s", socketAddress.getHostString(), socketAddress.getPort());
        }
        return (existing = this.nodes.putIfAbsent(address, node = new SimpleNode(name, socketAddress))) != null ? existing : node;
    }

    @Override
    public Address getAddress(Node node) {
        for (Map.Entry entry : this.nodes.entrySet()) {
            if (!node.equals(entry.getValue())) continue;
            return (Address)entry.getKey();
        }
        throw new IllegalArgumentException(node.getName());
    }

    private Address getLocalAddress() {
        return this.dispatcher.getChannel().getAddress();
    }

    public List<Node> getNodes() {
        List addresses = this.dispatcher.getChannel().getView().getMembers();
        ArrayList<Node> nodes = new ArrayList<Node>(addresses.size());
        for (Address address : addresses) {
            nodes.add(this.getNode(address));
        }
        return nodes;
    }

    public boolean isCoordinator() {
        return this.getLocalAddress().equals(this.getCoordinatorAddress());
    }

    public Node getLocalNode() {
        return this.getNode(this.getLocalAddress());
    }

    public Node getCoordinatorNode() {
        Address address = this.getCoordinatorAddress();
        return address != null ? this.getNode(address) : null;
    }

    private Address getCoordinatorAddress() {
        List addresses = this.dispatcher.getChannel().getView().getMembers();
        return !addresses.isEmpty() ? (Address)addresses.get(0) : null;
    }

    /*
     * Exception decompiling
     */
    public Object handle(Message message) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void viewAccepted(View view) {
        this.executor.submit(new ViewTask(view));
    }

    public void suspect(Address suspected) {
    }

    public void block() {
    }

    public void unblock() {
    }

    private class ViewTask
    implements Runnable,
    Comparable<ViewTask> {
        private final View view;

        ViewTask(View view) {
            this.view = view;
        }

        @Override
        public void run() {
            Set<Node> previousView = CommandDispatcherFactoryService.this.view;
            int size = this.view.size();
            ArrayList<Node> allNodes = new ArrayList<Node>(size);
            ArrayList<Node> newNodes = new ArrayList<Node>(size);
            for (Address address : this.view.getMembers()) {
                Node node = CommandDispatcherFactoryService.this.getNode(address);
                allNodes.add(node);
                if (previousView.contains(node)) continue;
                newNodes.add(node);
            }
            ArrayList<Node> deadNodes = new ArrayList<Node>(previousView);
            deadNodes.removeAll(allNodes);
            CommandDispatcherFactoryService.this.view = new HashSet<Node>(allNodes);
            CommandDispatcherFactoryService.this.nodes.values().removeAll(deadNodes);
            Collection<Map.Entry<Object, MembershipListener>> listeners = CommandDispatcherFactoryService.this.services.values();
            List<List<Node>> groups = this.createGroups(this.view);
            for (Map.Entry<Object, MembershipListener> entry : listeners) {
                MembershipListener listener = entry.getValue();
                if (listener == null) continue;
                listener.membershipChanged(deadNodes, newNodes, allNodes, groups);
            }
        }

        private List<List<Node>> createGroups(View view) {
            if (!(view instanceof MergeView)) {
                return null;
            }
            MergeView merge = (MergeView)view;
            List partitions = merge.getSubgroups();
            ArrayList<List<Node>> groups = new ArrayList<List<Node>>(partitions.size());
            for (View partition : partitions) {
                ArrayList<Node> nodes = new ArrayList<Node>(partition.size());
                for (Address address : partition.getMembers()) {
                    nodes.add(CommandDispatcherFactoryService.this.getNode(address));
                }
                groups.add(nodes);
            }
            return groups;
        }

        @Override
        public int compareTo(ViewTask task) {
            return this.view.getViewId().compareTo(task.view.getViewId());
        }
    }
}

