/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.CacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.FileCacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.jdbc.configuration.AbstractJdbcCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.JdbcBinaryCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.JdbcMixedCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.JdbcStringBasedCacheStoreConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.TableManipulationConfigurationBuilder;
import org.infinispan.loaders.remote.configuration.RemoteCacheStoreConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.BaseJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BaseStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.Indexing;
import org.jboss.as.clustering.infinispan.subsystem.LockingResource;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.infinispan.subsystem.StorePropertyResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.server.Services;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.tm.XAResourceRecoveryRegistry;

public abstract class CacheAdd
extends AbstractAddStepHandler {
    private static final Logger log = Logger.getLogger((String)CacheAdd.class.getPackage().getName());
    private static final String DEFAULTS = "infinispan-defaults.xml";
    private static volatile Map<CacheMode, Configuration> defaults = null;
    final CacheMode mode;

    public static synchronized Configuration getDefaultConfiguration(CacheMode cacheMode) {
        if (defaults == null) {
            ConfigurationBuilderHolder holder = CacheAdd.load(DEFAULTS);
            Configuration defaultConfig = holder.getDefaultConfigurationBuilder().build();
            EnumMap<CacheMode, Configuration> map = new EnumMap<CacheMode, Configuration>(CacheMode.class);
            map.put(defaultConfig.clustering().cacheMode(), defaultConfig);
            for (ConfigurationBuilder builder : holder.getNamedConfigurationBuilders().values()) {
                Configuration config = builder.build();
                map.put(config.clustering().cacheMode(), config);
            }
            for (CacheMode mode : CacheMode.values()) {
                if (map.containsKey(mode)) continue;
                map.put(mode, new ConfigurationBuilder().read(defaultConfig).clustering().cacheMode(mode).build());
            }
            defaults = map;
        }
        return defaults.get(cacheMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConfigurationBuilderHolder load(String resource) {
        ConfigurationBuilderHolder configurationBuilderHolder;
        URL url = CacheAdd.find(resource, CacheAdd.class.getClassLoader());
        log.debugf("Loading Infinispan defaults from %s", (Object)url.toString());
        InputStream input = url.openStream();
        ParserRegistry parser = new ParserRegistry(ParserRegistry.class.getClassLoader());
        try {
            configurationBuilderHolder = parser.parse(input);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (IOException e) {
                    log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Failed to parse %s", url), e);
            }
        }
        try {
            input.close();
        }
        catch (IOException e) {
            log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return configurationBuilderHolder;
    }

    private static URL find(String resource, ClassLoader ... loaders) {
        for (ClassLoader loader : loaders) {
            URL url;
            if (loader == null || (url = loader.getResource(resource)) == null) continue;
            return url;
        }
        throw new IllegalArgumentException(String.format("Failed to locate %s", resource));
    }

    CacheAdd(CacheMode mode) {
        this.mode = mode;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        this.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode cacheModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        PathAddress containerAddress = this.getCacheContainerAddressFromOperation(operation);
        ModelNode containerModel = context.readResourceFromRoot(containerAddress).getModel();
        newControllers.addAll(this.installRuntimeServices(context, operation, containerModel, cacheModel, verificationHandler));
    }

    Collection<ServiceController<?>> installRuntimeServices(OperationContext context, ModelNode operation, ModelNode containerModel, ModelNode cacheModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        PathAddress cacheAddress = this.getCacheAddressFromOperation(operation);
        PathAddress containerAddress = this.getCacheContainerAddressFromOperation(operation);
        String cacheName = cacheAddress.getLastElement().getValue();
        String containerName = containerAddress.getLastElement().getValue();
        ModelNode resolvedValue = null;
        resolvedValue = CacheResourceDefinition.JNDI_NAME.resolveModelAttribute(context, cacheModel);
        String jndiName = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        ServiceController.Mode initialMode = StartMode.valueOf(CacheResourceDefinition.START.resolveModelAttribute(context, cacheModel).asString()).getMode();
        resolvedValue = CacheResourceDefinition.CACHE_MODULE.resolveModelAttribute(context, cacheModel);
        ModuleIdentifier moduleId = resolvedValue.isDefined() ? ModuleIdentifier.fromString((String)resolvedValue.asString()) : null;
        LinkedList dependencies = new LinkedList();
        ConfigurationBuilder builder = new ConfigurationBuilder().read(CacheAdd.getDefaultConfiguration(this.mode));
        this.processModelNode(context, containerName, cacheModel, builder, dependencies);
        String defaultCache = CacheContainerResourceDefinition.DEFAULT_CACHE.resolveModelAttribute(context, containerModel).asString();
        ServiceTarget target = context.getServiceTarget();
        Configuration config = builder.build();
        ArrayList controllers = new ArrayList(3);
        controllers.add(this.installCacheConfigurationService(target, containerName, cacheName, defaultCache, moduleId, builder, config, dependencies, verificationHandler));
        log.debugf("Cache configuration service for %s installed for container %s", (Object)cacheName, (Object)containerName);
        controllers.add(this.installCacheService(target, containerName, cacheName, defaultCache, initialMode, config, verificationHandler));
        controllers.add(this.installJndiService(target, containerName, cacheName, jndiName, verificationHandler));
        log.debugf("Cache service for cache %s installed for container %s", (Object)cacheName, (Object)containerName);
        return controllers;
    }

    void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress cacheAddress = this.getCacheAddressFromOperation(operation);
        PathAddress containerAddress = this.getCacheContainerAddressFromOperation(operation);
        String cacheName = cacheAddress.getLastElement().getValue();
        String containerName = containerAddress.getLastElement().getValue();
        ModelNode resolvedValue = null;
        resolvedValue = CacheResourceDefinition.JNDI_NAME.resolveModelAttribute(context, model);
        String jndiName = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        context.removeService(this.createCacheBinding(jndiName, containerName, cacheName).getBinderServiceName());
        context.removeService(CacheService.getServiceName(containerName, cacheName));
        context.removeService(CacheConfigurationService.getServiceName(containerName, cacheName));
        log.debugf("cache %s removed for container %s", (Object)cacheName, (Object)containerName);
    }

    protected PathAddress getCacheAddressFromOperation(ModelNode operation) {
        return PathAddress.pathAddress((ModelNode)operation.get("address"));
    }

    protected PathAddress getCacheContainerAddressFromOperation(ModelNode operation) {
        PathAddress cacheAddress = this.getCacheAddressFromOperation(operation);
        PathAddress containerAddress = cacheAddress.subAddress(0, cacheAddress.size() - 1);
        return containerAddress;
    }

    ServiceController<?> installCacheConfigurationService(ServiceTarget target, String containerName, String cacheName, String defaultCache, ModuleIdentifier moduleId, ConfigurationBuilder builder, Configuration config, List<Dependency<?>> dependencies, ServiceVerificationHandler verificationHandler) {
        InjectedValue container = new InjectedValue();
        CacheConfigurationDependencies cacheConfigurationDependencies = new CacheConfigurationDependencies((Value<EmbeddedCacheManager>)container);
        CacheConfigurationService service = new CacheConfigurationService(cacheName, builder, moduleId, cacheConfigurationDependencies);
        ServiceBuilder configBuilder = target.addService(CacheConfigurationService.getServiceName(containerName, cacheName), (Service)service).addDependency(EmbeddedCacheManagerService.getServiceName(containerName), EmbeddedCacheManager.class, (Injector)container).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, cacheConfigurationDependencies.getModuleLoaderInjector()).setInitialMode(ServiceController.Mode.PASSIVE);
        if (config.invocationBatching().enabled()) {
            cacheConfigurationDependencies.getTransactionManagerInjector().inject((Object)BatchModeTransactionManager.getInstance());
        } else if (config.transaction().transactionMode() == org.infinispan.transaction.TransactionMode.TRANSACTIONAL) {
            configBuilder.addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, cacheConfigurationDependencies.getTransactionManagerInjector());
            if (config.transaction().useSynchronization()) {
                configBuilder.addDependency(TxnServices.JBOSS_TXN_SYNCHRONIZATION_REGISTRY, TransactionSynchronizationRegistry.class, cacheConfigurationDependencies.getTransactionSynchronizationRegistryInjector());
            }
        }
        for (Dependency<?> dependency : dependencies) {
            this.addDependency(configBuilder, dependency);
        }
        if (cacheName.equals(defaultCache)) {
            configBuilder.addAliases(new ServiceName[]{CacheConfigurationService.getServiceName(containerName, null)});
        }
        return configBuilder.install();
    }

    ServiceController<?> installCacheService(ServiceTarget target, String containerName, String cacheName, String defaultCache, ServiceController.Mode initialMode, Configuration config, ServiceVerificationHandler verificationHandler) {
        InjectedValue container = new InjectedValue();
        CacheDependencies cacheDependencies = new CacheDependencies((Value<EmbeddedCacheManager>)container);
        CacheService service = new CacheService(cacheName, cacheDependencies);
        ServiceBuilder builder = AsynchronousService.addService((ServiceTarget)target, (ServiceName)CacheService.getServiceName(containerName, cacheName), service).addDependency(CacheConfigurationService.getServiceName(containerName, cacheName)).addDependency(EmbeddedCacheManagerService.getServiceName(containerName), EmbeddedCacheManager.class, (Injector)container).setInitialMode(initialMode);
        if (config.transaction().recovery().enabled()) {
            builder.addDependency(TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER, XAResourceRecoveryRegistry.class, cacheDependencies.getRecoveryRegistryInjector());
        }
        if (cacheName.equals(defaultCache)) {
            builder.addAliases(new ServiceName[]{CacheService.getServiceName(containerName, null)});
        }
        if (initialMode == ServiceController.Mode.ACTIVE) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        return builder.install();
    }

    ServiceController<?> installJndiService(ServiceTarget target, String containerName, String cacheName, String jndiName, ServiceVerificationHandler verificationHandler) {
        ServiceName cacheServiceName = CacheService.getServiceName(containerName, cacheName);
        ContextNames.BindInfo binding = this.createCacheBinding(jndiName, containerName, cacheName);
        BinderService binder = new BinderService(binding.getBindName());
        return target.addService(binding.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{binding.getBindName()})}).addDependency(cacheServiceName, Cache.class, (Injector)new ManagedReferenceInjector(binder.getManagedObjectInjector())).addDependency(binding.getParentContextServiceName(), ServiceBasedNamingStore.class, binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE).install();
    }

    private ContextNames.BindInfo createCacheBinding(String jndiName, String container, String cache) {
        JndiName name = jndiName != null ? JndiNameFactory.parse((String)jndiName) : JndiNameFactory.createJndiName((String)"java:jboss", (String[])new String[]{"infinispan", "cache", container, cache});
        return ContextNames.bindInfoFor((String)name.getAbsoluteName());
    }

    private <T> void addDependency(ServiceBuilder<?> builder, Dependency<T> dependency) {
        ServiceName name = dependency.getName();
        Injector<T> injector = dependency.getInjector();
        if (injector != null) {
            builder.addDependency(name, dependency.getType(), injector);
        } else {
            builder.addDependency(name);
        }
    }

    void populate(ModelNode fromModel, ModelNode toModel) throws OperationFailedException {
        CacheResourceDefinition.START.validateAndSet(fromModel, toModel);
        CacheResourceDefinition.BATCHING.validateAndSet(fromModel, toModel);
        CacheResourceDefinition.INDEXING.validateAndSet(fromModel, toModel);
        CacheResourceDefinition.JNDI_NAME.validateAndSet(fromModel, toModel);
        CacheResourceDefinition.CACHE_MODULE.validateAndSet(fromModel, toModel);
        CacheResourceDefinition.INDEXING_PROPERTIES.validateAndSet(fromModel, toModel);
    }

    void processModelNode(OperationContext context, String containerName, ModelNode cache, ConfigurationBuilder builder, List<Dependency<?>> dependencies) throws OperationFailedException {
        String storeKey;
        Indexing indexing = Indexing.valueOf(CacheResourceDefinition.INDEXING.resolveModelAttribute(context, cache).asString());
        boolean batching = CacheResourceDefinition.BATCHING.resolveModelAttribute(context, cache).asBoolean();
        builder.clustering().cacheMode(this.mode);
        ModelNode indexingPropertiesModel = CacheResourceDefinition.INDEXING_PROPERTIES.resolveModelAttribute(context, cache);
        Properties indexingProperties = new Properties();
        if (indexing.isEnabled() && indexingPropertiesModel.isDefined()) {
            for (Property p : indexingPropertiesModel.asPropertyList()) {
                String value = p.getValue().asString();
                indexingProperties.put(p.getName(), value);
            }
        }
        builder.indexing().enabled(indexing.isEnabled()).indexLocalOnly(indexing.isLocalOnly()).withProperties(indexingProperties);
        if (cache.hasDefined("locking") && cache.get(new String[]{"locking", "LOCKING"}).isDefined()) {
            ModelNode locking = cache.get(new String[]{"locking", "LOCKING"});
            IsolationLevel isolationLevel = IsolationLevel.valueOf((String)LockingResource.ISOLATION.resolveModelAttribute(context, locking).asString());
            boolean striping = LockingResource.STRIPING.resolveModelAttribute(context, locking).asBoolean();
            long acquireTimeout = LockingResource.ACQUIRE_TIMEOUT.resolveModelAttribute(context, locking).asLong();
            int concurrencyLevel = LockingResource.CONCURRENCY_LEVEL.resolveModelAttribute(context, locking).asInt();
            builder.locking().isolationLevel(isolationLevel).useLockStriping(striping).lockAcquisitionTimeout(acquireTimeout).concurrencyLevel(concurrencyLevel);
        }
        if (cache.hasDefined("transaction") && cache.get(new String[]{"transaction", "TRANSACTION"}).isDefined()) {
            ModelNode transaction = cache.get(new String[]{"transaction", "TRANSACTION"});
            long stopTimeout = TransactionResourceDefinition.STOP_TIMEOUT.resolveModelAttribute(context, transaction).asLong();
            TransactionMode txMode = TransactionMode.valueOf(TransactionResourceDefinition.MODE.resolveModelAttribute(context, transaction).asString());
            LockingMode lockingMode = LockingMode.valueOf((String)TransactionResourceDefinition.LOCKING.resolveModelAttribute(context, transaction).asString());
            builder.transaction().cacheStopTimeout(stopTimeout).transactionMode(txMode.getMode()).lockingMode(lockingMode).useSynchronization(!txMode.isXAEnabled()).recovery().enabled(txMode.isRecoveryEnabled());
        }
        if (batching) {
            builder.transaction().transactionMode(org.infinispan.transaction.TransactionMode.TRANSACTIONAL).invocationBatching().enable();
        } else {
            builder.transaction().invocationBatching().disable();
        }
        if (cache.hasDefined("eviction") && cache.get(new String[]{"eviction", "EVICTION"}).isDefined()) {
            ModelNode eviction = cache.get(new String[]{"eviction", "EVICTION"});
            EvictionStrategy strategy = EvictionStrategy.valueOf((String)EvictionResourceDefinition.EVICTION_STRATEGY.resolveModelAttribute(context, eviction).asString());
            builder.eviction().strategy(strategy);
            if (strategy.isEnabled()) {
                int maxEntries = EvictionResourceDefinition.MAX_ENTRIES.resolveModelAttribute(context, eviction).asInt();
                builder.eviction().maxEntries(maxEntries);
            }
        }
        if (cache.hasDefined("expiration") && cache.get(new String[]{"expiration", "EXPIRATION"}).isDefined()) {
            ModelNode expiration = cache.get(new String[]{"expiration", "EXPIRATION"});
            long maxIdle = ExpirationResourceDefinition.MAX_IDLE.resolveModelAttribute(context, expiration).asLong();
            long lifespan = ExpirationResourceDefinition.LIFESPAN.resolveModelAttribute(context, expiration).asLong();
            long interval = ExpirationResourceDefinition.INTERVAL.resolveModelAttribute(context, expiration).asLong();
            builder.expiration().maxIdle(maxIdle).lifespan(lifespan).wakeUpInterval(interval);
            if (maxIdle > 0L || lifespan > 0L) {
                builder.expiration().enableReaper();
            } else {
                builder.expiration().disableReaper();
            }
        }
        if ((storeKey = this.findStoreKey(cache)) != null) {
            ModelNode store = this.getStoreModelNode(cache);
            boolean shared = BaseStoreResourceDefinition.SHARED.resolveModelAttribute(context, store).asBoolean();
            boolean preload = BaseStoreResourceDefinition.PRELOAD.resolveModelAttribute(context, store).asBoolean();
            boolean passivation = BaseStoreResourceDefinition.PASSIVATION.resolveModelAttribute(context, store).asBoolean();
            boolean fetchState = BaseStoreResourceDefinition.FETCH_STATE.resolveModelAttribute(context, store).asBoolean();
            boolean purge = BaseStoreResourceDefinition.PURGE.resolveModelAttribute(context, store).asBoolean();
            boolean singleton = BaseStoreResourceDefinition.SINGLETON.resolveModelAttribute(context, store).asBoolean();
            boolean async = store.hasDefined("write-behind") && store.get(new String[]{"write-behind", "WRITE_BEHIND"}).isDefined();
            LoadersConfigurationBuilder loadersBuilder = builder.loaders().shared(shared).preload(preload).passivation(passivation);
            CacheStoreConfigurationBuilder storeBuilder = (CacheStoreConfigurationBuilder)((CacheStoreConfigurationBuilder)((CacheStoreConfigurationBuilder)this.buildCacheStore(context, loadersBuilder, containerName, store, storeKey, dependencies).fetchPersistentState(fetchState)).purgeOnStartup(purge)).purgeSynchronously(true);
            storeBuilder.singletonStore().enabled(singleton);
            if (async) {
                ModelNode writeBehind = store.get(new String[]{"write-behind", "WRITE_BEHIND"});
                storeBuilder.async().enable().flushLockTimeout(StoreWriteBehindResourceDefinition.FLUSH_LOCK_TIMEOUT.resolveModelAttribute(context, writeBehind).asLong()).modificationQueueSize(StoreWriteBehindResourceDefinition.MODIFICATION_QUEUE_SIZE.resolveModelAttribute(context, writeBehind).asInt()).shutdownTimeout(StoreWriteBehindResourceDefinition.SHUTDOWN_TIMEOUT.resolveModelAttribute(context, writeBehind).asLong()).threadPoolSize(StoreWriteBehindResourceDefinition.THREAD_POOL_SIZE.resolveModelAttribute(context, writeBehind).asInt());
            }
            TypedProperties properties = new TypedProperties();
            if (store.hasDefined("property")) {
                for (Property property : store.get("property").asPropertyList()) {
                    String propertyName = property.getName();
                    ModelNode propertyValue = null;
                    propertyValue = StorePropertyResourceDefinition.VALUE.resolveModelAttribute(context, property.getValue());
                    properties.setProperty(propertyName, propertyValue.asString());
                }
            }
            storeBuilder.withProperties((Properties)properties);
        }
    }

    private String findStoreKey(ModelNode cache) {
        if (cache.hasDefined("store")) {
            return "store";
        }
        if (cache.hasDefined("file-store")) {
            return "file-store";
        }
        if (cache.hasDefined("string-keyed-jdbc-store")) {
            return "string-keyed-jdbc-store";
        }
        if (cache.hasDefined("binary-keyed-jdbc-store")) {
            return "binary-keyed-jdbc-store";
        }
        if (cache.hasDefined("mixed-keyed-jdbc-store")) {
            return "mixed-keyed-jdbc-store";
        }
        if (cache.hasDefined("remote-store")) {
            return "remote-store";
        }
        return null;
    }

    private ModelNode getStoreModelNode(ModelNode cache) {
        if (cache.hasDefined("store")) {
            return cache.get(new String[]{"store", "STORE"});
        }
        if (cache.hasDefined("file-store")) {
            return cache.get(new String[]{"file-store", "FILE_STORE"});
        }
        if (cache.hasDefined("string-keyed-jdbc-store")) {
            return cache.get(new String[]{"string-keyed-jdbc-store", "STRING_KEYED_JDBC_STORE"});
        }
        if (cache.hasDefined("binary-keyed-jdbc-store")) {
            return cache.get(new String[]{"binary-keyed-jdbc-store", "BINARY_KEYED_JDBC_STORE"});
        }
        if (cache.hasDefined("mixed-keyed-jdbc-store")) {
            return cache.get(new String[]{"mixed-keyed-jdbc-store", "MIXED_KEYED_JDBC_STORE"});
        }
        if (cache.hasDefined("remote-store")) {
            return cache.get(new String[]{"remote-store", "REMOTE_STORE"});
        }
        return null;
    }

    private CacheStoreConfigurationBuilder<?, ?> buildCacheStore(OperationContext context, LoadersConfigurationBuilder loadersBuilder, String containerName, ModelNode store, String storeKey, List<Dependency<?>> dependencies) throws OperationFailedException {
        ModelNode resolvedValue = null;
        if (storeKey.equals("file-store")) {
            final FileCacheStoreConfigurationBuilder builder = (FileCacheStoreConfigurationBuilder)loadersBuilder.addStore(FileCacheStoreConfigurationBuilder.class);
            resolvedValue = FileStoreResourceDefinition.PATH.resolveModelAttribute(context, store);
            final String path = resolvedValue.isDefined() ? resolvedValue.asString() : "infinispan" + File.separatorChar + containerName;
            resolvedValue = FileStoreResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, store);
            final String relativeTo = resolvedValue.isDefined() ? resolvedValue.asString() : "jboss.server.data.dir";
            SimpleInjector<PathManager> injector = new SimpleInjector<PathManager>(){
                volatile PathManager.Callback.Handle callbackHandle;

                public void inject(PathManager value) {
                    this.callbackHandle = value.registerCallback(relativeTo, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
                    builder.location(value.resolveRelativePathEntry(path, relativeTo));
                }

                @Override
                public void uninject() {
                    super.uninject();
                    if (this.callbackHandle != null) {
                        this.callbackHandle.remove();
                    }
                }
            };
            dependencies.add(new Dependency<PathManager>(PathManagerService.SERVICE_NAME, PathManager.class, injector));
            return builder.fsyncMode(FileCacheStoreConfigurationBuilder.FsyncMode.PER_WRITE);
        }
        if (storeKey.equals("string-keyed-jdbc-store") || storeKey.equals("binary-keyed-jdbc-store") || storeKey.equals("mixed-keyed-jdbc-store")) {
            AbstractJdbcCacheStoreConfigurationBuilder<?, ?> builder = this.buildJdbcStore(loadersBuilder, context, store);
            String datasource = BaseJDBCStoreResourceDefinition.DATA_SOURCE.resolveModelAttribute(context, store).asString();
            dependencies.add(new Dependency(ServiceName.JBOSS.append(new String[]{"data-source", datasource})));
            builder.dataSource().jndiUrl(datasource);
            return builder;
        }
        if (storeKey.equals("remote-store")) {
            final RemoteCacheStoreConfigurationBuilder builder = (RemoteCacheStoreConfigurationBuilder)loadersBuilder.addStore(RemoteCacheStoreConfigurationBuilder.class);
            for (ModelNode server : store.require("remote-servers").asList()) {
                String outboundSocketBinding = server.get("outbound-socket-binding").asString();
                SimpleInjector<OutboundSocketBinding> injector = new SimpleInjector<OutboundSocketBinding>(){

                    public void inject(OutboundSocketBinding value) {
                        try {
                            builder.addServer().host(value.getDestinationAddress().getHostAddress()).port(value.getDestinationPort());
                        }
                        catch (UnknownHostException e) {
                            throw InfinispanMessages.MESSAGES.failedToInjectSocketBinding(e, value);
                        }
                    }
                };
                dependencies.add(new Dependency<OutboundSocketBinding>(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{outboundSocketBinding}), OutboundSocketBinding.class, injector));
            }
            if (store.hasDefined("cache")) {
                builder.remoteCacheName(store.get("cache").asString());
            }
            if (store.hasDefined("socket-timeout")) {
                builder.socketTimeout(store.require("socket-timeout").asLong());
            }
            if (store.hasDefined("tcp-no-delay")) {
                builder.tcpNoDelay(store.require("tcp-no-delay").asBoolean());
            }
            return builder;
        }
        String className = store.require("class").asString();
        try {
            Class<CacheStore> storeClass = CacheStore.class.getClassLoader().loadClass(className).asSubclass(CacheStore.class);
            return loadersBuilder.loaders().addStore().cacheStore(storeClass.newInstance());
        }
        catch (Exception e) {
            throw InfinispanMessages.MESSAGES.invalidCacheStore(e, className);
        }
    }

    private AbstractJdbcCacheStoreConfigurationBuilder<?, ?> buildJdbcStore(LoadersConfigurationBuilder loadersBuilder, OperationContext context, ModelNode store) throws OperationFailedException {
        boolean useStringKeyedTable = store.hasDefined("string-keyed-table");
        boolean useBinaryKeyedTable = store.hasDefined("binary-keyed-table");
        if (useStringKeyedTable && !useBinaryKeyedTable) {
            JdbcStringBasedCacheStoreConfigurationBuilder builder = (JdbcStringBasedCacheStoreConfigurationBuilder)loadersBuilder.addStore(JdbcStringBasedCacheStoreConfigurationBuilder.class);
            this.buildStringKeyedTable((TableManipulationConfigurationBuilder<?, ?>)builder.table(), context, store.get("string-keyed-table"));
            return builder;
        }
        if (useBinaryKeyedTable && !useStringKeyedTable) {
            JdbcBinaryCacheStoreConfigurationBuilder builder = (JdbcBinaryCacheStoreConfigurationBuilder)loadersBuilder.addStore(JdbcBinaryCacheStoreConfigurationBuilder.class);
            this.buildBinaryKeyedTable((TableManipulationConfigurationBuilder<?, ?>)builder.table(), context, store.get("binary-keyed-table"));
            return builder;
        }
        JdbcMixedCacheStoreConfigurationBuilder builder = (JdbcMixedCacheStoreConfigurationBuilder)loadersBuilder.addStore(JdbcMixedCacheStoreConfigurationBuilder.class);
        this.buildStringKeyedTable((TableManipulationConfigurationBuilder<?, ?>)builder.stringTable(), context, store.get("string-keyed-table"));
        this.buildBinaryKeyedTable((TableManipulationConfigurationBuilder<?, ?>)builder.binaryTable(), context, store.get("binary-keyed-table"));
        return builder;
    }

    private void buildBinaryKeyedTable(TableManipulationConfigurationBuilder<?, ?> builder, OperationContext context, ModelNode table) throws OperationFailedException {
        this.buildTable(builder, context, table, "ispn_bucket");
    }

    private void buildStringKeyedTable(TableManipulationConfigurationBuilder<?, ?> builder, OperationContext context, ModelNode table) throws OperationFailedException {
        this.buildTable(builder, context, table, "ispn_entry");
    }

    private void buildTable(TableManipulationConfigurationBuilder<?, ?> builder, OperationContext context, ModelNode table, String defaultTableNamePrefix) throws OperationFailedException {
        ModelNode tableNamePrefix = BaseJDBCStoreResourceDefinition.PREFIX.resolveModelAttribute(context, table);
        builder.batchSize(BaseJDBCStoreResourceDefinition.BATCH_SIZE.resolveModelAttribute(context, table).asInt()).fetchSize(BaseJDBCStoreResourceDefinition.FETCH_SIZE.resolveModelAttribute(context, table).asInt()).tableNamePrefix(tableNamePrefix.isDefined() ? tableNamePrefix.asString() : defaultTableNamePrefix).idColumnName(this.getColumnProperty(context, table, "id-column", (AttributeDefinition)BaseJDBCStoreResourceDefinition.COLUMN_NAME, "id")).idColumnType(this.getColumnProperty(context, table, "id-column", (AttributeDefinition)BaseJDBCStoreResourceDefinition.COLUMN_TYPE, "VARCHAR")).dataColumnName(this.getColumnProperty(context, table, "data-column", (AttributeDefinition)BaseJDBCStoreResourceDefinition.COLUMN_NAME, "datum")).dataColumnType(this.getColumnProperty(context, table, "data-column", (AttributeDefinition)BaseJDBCStoreResourceDefinition.COLUMN_TYPE, "BINARY")).timestampColumnName(this.getColumnProperty(context, table, "timestamp-column", (AttributeDefinition)BaseJDBCStoreResourceDefinition.COLUMN_NAME, "version")).timestampColumnType(this.getColumnProperty(context, table, "timestamp-column", (AttributeDefinition)BaseJDBCStoreResourceDefinition.COLUMN_TYPE, "BIGINT"));
    }

    private String getColumnProperty(OperationContext context, ModelNode table, String columnKey, AttributeDefinition columnAttribute, String defaultValue) throws OperationFailedException {
        if (!table.isDefined() || !table.hasDefined(columnKey)) {
            return defaultValue;
        }
        ModelNode column = table.get(columnKey);
        ModelNode resolvedValue = null;
        resolvedValue = columnAttribute.resolveModelAttribute(context, column);
        return resolvedValue.isDefined() ? resolvedValue.asString() : defaultValue;
    }

    private static class CacheConfigurationDependencies
    implements CacheConfigurationService.Dependencies {
        private final Value<EmbeddedCacheManager> container;
        private final InjectedValue<TransactionManager> tm = new InjectedValue();
        private final InjectedValue<TransactionSynchronizationRegistry> tsr = new InjectedValue();
        private final InjectedValue<ModuleLoader> moduleLoader = new InjectedValue();

        CacheConfigurationDependencies(Value<EmbeddedCacheManager> container) {
            this.container = container;
        }

        Injector<TransactionManager> getTransactionManagerInjector() {
            return this.tm;
        }

        Injector<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistryInjector() {
            return this.tsr;
        }

        Injector<ModuleLoader> getModuleLoaderInjector() {
            return this.moduleLoader;
        }

        @Override
        public EmbeddedCacheManager getCacheContainer() {
            return (EmbeddedCacheManager)this.container.getValue();
        }

        @Override
        public TransactionManager getTransactionManager() {
            return (TransactionManager)this.tm.getOptionalValue();
        }

        @Override
        public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
            return (TransactionSynchronizationRegistry)this.tsr.getOptionalValue();
        }

        @Override
        public ModuleLoader getModuleLoader() {
            return (ModuleLoader)this.moduleLoader.getValue();
        }
    }

    private static class CacheDependencies
    implements CacheService.Dependencies {
        private final Value<EmbeddedCacheManager> container;
        private final InjectedValue<XAResourceRecoveryRegistry> recoveryRegistry = new InjectedValue();

        CacheDependencies(Value<EmbeddedCacheManager> container) {
            this.container = container;
        }

        Injector<XAResourceRecoveryRegistry> getRecoveryRegistryInjector() {
            return this.recoveryRegistry;
        }

        @Override
        public EmbeddedCacheManager getCacheContainer() {
            return (EmbeddedCacheManager)this.container.getValue();
        }

        @Override
        public XAResourceRecoveryRegistry getRecoveryRegistry() {
            return (XAResourceRecoveryRegistry)this.recoveryRegistry.getOptionalValue();
        }
    }

    private abstract class SimpleInjector<I>
    implements Injector<I> {
        private SimpleInjector() {
        }

        public void uninject() {
        }
    }

    protected class Dependency<I> {
        private final ServiceName name;
        private final Class<I> type;
        private final Injector<I> target;

        Dependency(ServiceName name) {
            this(name, null, null);
        }

        Dependency(ServiceName name, Class<I> type, Injector<I> target) {
            this.name = name;
            this.type = type;
            this.target = target;
        }

        ServiceName getName() {
            return this.name;
        }

        public Class<I> getType() {
            return this.type;
        }

        public Injector<I> getInjector() {
            return this.target;
        }
    }
}

