/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSModelGroupDefinition;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.Constants;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.group.ValueListRepeatableParticleHandler;
import org.jboss.xb.binding.metadata.AddMethodMetaData;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.ClassMetaData;
import org.jboss.xb.binding.metadata.MapEntryMetaData;
import org.jboss.xb.binding.metadata.PackageMetaData;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.metadata.PutMethodMetaData;
import org.jboss.xb.binding.metadata.SchemaMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.metadata.XsdAnnotation;
import org.jboss.xb.binding.metadata.XsdAppInfo;
import org.jboss.xb.binding.resolver.MultiClassSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.AllBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ChoiceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultHandlers;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SequenceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtCharactersHandler;
import org.jboss.xb.binding.sunday.xop.XOPIncludeHandler;

public class XsdBinder {
    static final Logger log = Logger.getLogger(XsdBinder.class);
    private boolean processAnnotations = true;
    private SchemaBindingResolver resolver;
    private boolean simpleContentWithIdAsSimpleType = true;
    private boolean unresolvedContentBoundToDOM = true;
    private boolean trace = log.isTraceEnabled();
    private final SchemaBinding schema;
    private SharedElements sharedElements = new SharedElements();
    private final List<Object> typeGroupStack = new ArrayList<Object>();

    public static XsdBinder newInstance() {
        return new XsdBinder();
    }

    public static SchemaBinding bind(String xsdUrl) {
        MultiClassSchemaResolver resolver = new MultiClassSchemaResolver();
        resolver.setBaseURI(xsdUrl);
        return XsdBinder.bind(xsdUrl, (SchemaBindingResolver)resolver);
    }

    public static SchemaBinding bind(String xsdUrl, SchemaBindingResolver resolver) {
        XSModel model = Util.loadSchema(xsdUrl, resolver);
        return XsdBinder.bind(model, resolver);
    }

    public static SchemaBinding bind(InputStream xsdStream, String encoding) {
        return XsdBinder.bind(xsdStream, encoding, (SchemaBindingResolver)new MultiClassSchemaResolver());
    }

    public static SchemaBinding bind(InputStream xsdStream, String encoding, String baseURI) {
        return XsdBinder.bind(xsdStream, encoding, baseURI, true);
    }

    public static SchemaBinding bind(InputStream xsdStream, String encoding, String baseURI, boolean processAnnotations) {
        MultiClassSchemaResolver resolver = new MultiClassSchemaResolver();
        resolver.setBaseURI(baseURI);
        return XsdBinder.bind(xsdStream, encoding, resolver, processAnnotations);
    }

    public static SchemaBinding bind(InputStream xsdStream, String encoding, SchemaBindingResolver resolver) {
        return XsdBinder.bind(xsdStream, encoding, resolver, true);
    }

    public static SchemaBinding bind(InputStream xsdStream, String encoding, SchemaBindingResolver resolver, boolean processAnnotations) {
        XSModel model = Util.loadSchema(xsdStream, encoding, resolver);
        return XsdBinder.bind(model, resolver, processAnnotations);
    }

    public static SchemaBinding bind(Reader xsdReader, String encoding) {
        return XsdBinder.bind(xsdReader, encoding, (SchemaBindingResolver)new MultiClassSchemaResolver());
    }

    public static SchemaBinding bind(Reader xsdReader, String encoding, String baseURI) {
        MultiClassSchemaResolver resolver = new MultiClassSchemaResolver();
        resolver.setBaseURI(baseURI);
        return XsdBinder.bind(xsdReader, encoding, (SchemaBindingResolver)resolver);
    }

    public static SchemaBinding bind(Reader xsdReader, String encoding, SchemaBindingResolver resolver) {
        XSModel model = Util.loadSchema(xsdReader, encoding, resolver);
        return XsdBinder.bind(model, resolver);
    }

    public static SchemaBinding bind(String xsd, String encoding) {
        return XsdBinder.bind(xsd, encoding, (SchemaBindingResolver)new MultiClassSchemaResolver());
    }

    public static SchemaBinding bind(String xsd, String encoding, SchemaBindingResolver resolver) {
        XSModel model = Util.loadSchema(xsd, encoding);
        return XsdBinder.bind(model, resolver);
    }

    public static SchemaBinding bind(XSModel model, SchemaBindingResolver resolver) {
        return XsdBinder.bind(model, resolver, true);
    }

    public static SchemaBinding bind(XSModel model, SchemaBindingResolver resolver, boolean processAnnotations) {
        XsdBinder binder = new XsdBinder();
        binder.setProcessAnnotations(processAnnotations);
        binder.setSchemaResolver(resolver);
        return binder.parse(model);
    }

    public static void bindType(SchemaBinding schema, XSTypeDefinition type) {
        XsdBinder binder = new XsdBinder(schema);
        TypeBinding typeBinding = binder.bindType(type);
        schema.addType(typeBinding);
    }

    public static void bindElement(SchemaBinding schema, XSElementDeclaration element, int minOccurs, int maxOccurs, boolean maxOccursUnbounded) {
        XsdBinder binder = new XsdBinder(schema);
        ParticleBinding particle = binder.bindElement(element, minOccurs, maxOccurs, maxOccursUnbounded);
        schema.addElementParticle(particle);
    }

    private XsdBinder() {
        this(new SchemaBinding());
    }

    private XsdBinder(SchemaBinding schema) {
        this.schema = schema;
    }

    public void setProcessAnnotations(boolean processAnnotations) {
        this.processAnnotations = processAnnotations;
    }

    public boolean isProcessAnnotations() {
        return this.processAnnotations;
    }

    public void setSchemaResolver(SchemaBindingResolver resolver) {
        this.resolver = resolver;
    }

    public SchemaBindingResolver getSchemaResolver() {
        return this.resolver;
    }

    public void setSimpleContentWithIdAsSimpleType(boolean simpleContentWithIdAsSimpleType) {
        this.simpleContentWithIdAsSimpleType = simpleContentWithIdAsSimpleType;
    }

    public boolean isSimpleContentWithIdAsSimpleType() {
        return this.simpleContentWithIdAsSimpleType;
    }

    public void setUnresolvedContentBoundToDOM(boolean toDOM) {
        this.unresolvedContentBoundToDOM = toDOM;
    }

    public boolean isUnresolvedContentBoundToDOM() {
        return this.unresolvedContentBoundToDOM;
    }

    public SchemaBinding parse(String xsdUrl) {
        if (this.resolver == null) {
            this.resolver = new MultiClassSchemaResolver();
        }
        XSModel model = Util.loadSchema(xsdUrl, this.resolver);
        return this.parse(model);
    }

    public SchemaBinding parse(InputStream xsdStream, String encoding) {
        if (this.resolver == null) {
            this.resolver = new MultiClassSchemaResolver();
        }
        XSModel model = Util.loadSchema(xsdStream, encoding, this.resolver);
        return this.parse(model);
    }

    public SchemaBinding parse(Reader xsdReader, String encoding) {
        if (this.resolver == null) {
            this.resolver = new MultiClassSchemaResolver();
        }
        XSModel model = Util.loadSchema(xsdReader, encoding, this.resolver);
        return this.parse(model);
    }

    private SchemaBinding parse(XSModel model) {
        XSModelGroupDefinition groupDef;
        int i;
        this.schema.setSchemaResolver(this.resolver);
        if (this.processAnnotations) {
            XSObjectList annotations = model.getAnnotations();
            if (this.trace) {
                log.trace((Object)("started binding schema " + this.schema));
                log.trace((Object)("Schema annotations: " + annotations.getLength()));
            }
            for (int i2 = 0; i2 < annotations.getLength(); ++i2) {
                SchemaMetaData schemaBindings;
                XSAnnotation annotation = (XSAnnotation)annotations.item(i2);
                XsdAnnotation an = XsdAnnotation.unmarshal(annotation.getAnnotationString());
                XsdAppInfo appinfo = an.getAppInfo();
                if (appinfo == null || (schemaBindings = appinfo.getSchemaMetaData()) == null) continue;
                this.schema.setIgnoreUnresolvedFieldOrClass(schemaBindings.isIgnoreUnresolvedFieldOrClass());
                this.schema.setReplacePropertyRefs(schemaBindings.isReplacePropertyRefs());
                PackageMetaData packageMetaData = schemaBindings.getPackage();
                if (packageMetaData == null) continue;
                if (this.trace) {
                    log.trace((Object)("schema default package: " + packageMetaData.getName()));
                }
                this.schema.setPackageMetaData(packageMetaData);
            }
        }
        StringList namespaceList = model.getNamespaces();
        LinkedHashSet<String> namespaces = new LinkedHashSet<String>(namespaceList.getLength());
        for (int i3 = 0; i3 < namespaceList.getLength(); ++i3) {
            namespaces.add(namespaceList.item(i3));
        }
        this.schema.setNamespaces(namespaces);
        XSNamedMap groups = model.getComponents((short)6);
        if (this.trace) {
            log.trace((Object)("Model groups: " + groups.getLength()));
        }
        for (i = 0; i < groups.getLength(); ++i) {
            groupDef = (XSModelGroupDefinition)groups.item(i);
            this.bindGlobalGroup(groupDef);
        }
        for (i = 0; i < groups.getLength(); ++i) {
            groupDef = (XSModelGroupDefinition)groups.item(i);
            this.bindGlobalGroupParticles(groupDef.getModelGroup());
        }
        XSNamedMap types = model.getComponents((short)3);
        if (this.trace) {
            log.trace((Object)("Model types: " + types.getLength()));
        }
        for (int i4 = 0; i4 < types.getLength(); ++i4) {
            XSTypeDefinition type = (XSTypeDefinition)types.item(i4);
            if ("http://www.w3.org/2001/XMLSchema".equals(type.getNamespace())) continue;
            this.bindType(type);
        }
        XSNamedMap elements = model.getComponents((short)2);
        if (this.trace) {
            log.trace((Object)("Model elements: " + types.getLength()));
        }
        for (int i5 = 0; i5 < elements.getLength(); ++i5) {
            XSElementDeclaration element = (XSElementDeclaration)elements.item(i5);
            this.bindElement(element, 1, 0, false);
        }
        if (this.unresolvedContentBoundToDOM) {
            this.schema.setUnresolvedContentBoundToDOM(this.unresolvedContentBoundToDOM);
        }
        if (this.trace) {
            log.trace((Object)("finished binding schema " + this.schema));
        }
        return this.schema;
    }

    private TypeBinding bindType(XSTypeDefinition type) {
        TypeBinding binding;
        switch (type.getTypeCategory()) {
            case 16: {
                binding = this.bindSimpleType((XSSimpleTypeDefinition)type);
                break;
            }
            case 15: {
                binding = this.bindComplexType((XSComplexTypeDefinition)type);
                break;
            }
            default: {
                throw new JBossXBRuntimeException("Unexpected type category: " + type.getTypeCategory());
            }
        }
        return binding;
    }

    private TypeBinding bindSimpleType(XSSimpleTypeDefinition type) {
        XSObjectList annotations;
        int i;
        XSTypeDefinition baseTypeDef;
        TypeBinding baseType;
        TypeBinding binding;
        QName typeName = type.getName() == null ? null : new QName(type.getNamespace(), type.getName());
        TypeBinding typeBinding = binding = typeName == null ? null : this.schema.getType(typeName);
        if (binding != null) {
            return binding;
        }
        if (this.trace) {
            log.trace((Object)("binding simple type " + typeName));
        }
        TypeBinding typeBinding2 = baseType = (baseTypeDef = type.getBaseType()) == null ? null : this.bindType(baseTypeDef);
        if (baseType == null) {
            binding = new TypeBinding(typeName);
        } else {
            binding = new TypeBinding(typeName, baseType);
            if ("http://www.w3.org/2001/XMLSchema".equals(baseTypeDef.getNamespace())) {
                binding.setCharactersHandler(DefaultHandlers.CHARACTERS_HANDLER_FACTORY.newCharactersHandler());
            }
        }
        StringList strList = type.getLexicalPattern();
        if (strList != null && strList.getLength() > 0) {
            for (i = 0; i < strList.getLength(); ++i) {
                binding.addLexicalPattern(strList.item(i));
            }
        }
        if ((strList = type.getLexicalEnumeration()) != null && strList.getLength() > 0) {
            for (i = 0; i < strList.getLength(); ++i) {
                binding.addEnumValue(strList.item(i));
            }
        }
        if (type.getItemType() != null) {
            TypeBinding itemType = this.bindSimpleType(type.getItemType());
            binding.setItemType(itemType);
        }
        if (typeName != null) {
            this.schema.addType(binding);
        }
        if (this.trace) {
            String msg;
            String string = msg = typeName == null ? "bound simple anonymous type" : "bound simple type " + typeName;
            if (baseType != null) {
                msg = msg + " inherited binding metadata from " + baseType.getQName();
            }
            log.trace((Object)msg);
        }
        if (this.processAnnotations && (annotations = type.getAnnotations()) != null) {
            if (this.trace) {
                log.trace((Object)(typeName + " annotations " + annotations.getLength()));
            }
            for (int i2 = 0; i2 < annotations.getLength(); ++i2) {
                ValueMetaData valueMetaData;
                XSAnnotation an = (XSAnnotation)annotations.item(i2);
                XsdAnnotation xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString());
                XsdAppInfo appInfo = xsdAn.getAppInfo();
                if (appInfo == null) continue;
                ClassMetaData classMetaData = appInfo.getClassMetaData();
                if (classMetaData != null) {
                    if (this.trace) {
                        log.trace((Object)("simple type " + type.getName() + ": impl=" + classMetaData.getImpl()));
                    }
                    binding.setClassMetaData(classMetaData);
                }
                if ((valueMetaData = appInfo.getValueMetaData()) == null) continue;
                if (this.trace) {
                    log.trace((Object)("simple type " + type.getName() + ": unmarshalMethod=" + valueMetaData.getUnmarshalMethod() + ", marshalMethod=" + valueMetaData.getMarshalMethod()));
                }
                binding.setValueMetaData(valueMetaData);
            }
        }
        binding.setSchemaBinding(this.schema);
        return binding;
    }

    private TypeBinding bindComplexType(XSComplexTypeDefinition type) {
        XSParticle particle;
        XSObjectList annotations;
        TypeBinding binding;
        QName typeName = type.getName() == null ? null : new QName(type.getNamespace(), type.getName());
        TypeBinding typeBinding = binding = typeName == null ? null : this.schema.getType(typeName);
        if (binding != null) {
            return binding;
        }
        XSTypeDefinition baseTypeDef = type.getBaseType();
        TypeBinding baseType = null;
        if (baseTypeDef != null && !Constants.QNAME_ANYTYPE.equals(typeName)) {
            baseType = this.bindType(baseTypeDef);
            if (typeName != null && (binding = this.schema.getType(typeName)) != null) {
                return binding;
            }
        }
        if (this.trace) {
            log.trace((Object)("binding complex " + (typeName == null ? "anonymous type" : "type " + typeName)));
        }
        binding = new TypeBinding(typeName);
        binding.setBaseType(baseType);
        binding.setSimple(false);
        if (type.getSimpleType() != null) {
            TypeBinding simpleType = this.bindSimpleType(type.getSimpleType());
            binding.setSimpleType(simpleType);
        } else if (type.getContentType() == 3) {
            TypeBinding stringType = this.schema.getType(Constants.QNAME_STRING);
            if (stringType == null) {
                throw new JBossXBRuntimeException("xsd:string has not been bound yet!");
            }
            binding.setSimpleType(stringType);
        }
        if (typeName != null) {
            this.schema.addType(binding);
        }
        binding.setSchemaBinding(this.schema);
        XSObjectList attrs = type.getAttributeUses();
        if (this.trace) {
            log.trace((Object)(typeName + " attributes " + attrs.getLength()));
        }
        AttributeBinding attrBinding = null;
        boolean hasOnlyIdAttrs = true;
        for (int i = 0; i < attrs.getLength(); ++i) {
            XSAttributeUse attr = (XSAttributeUse)attrs.item(i);
            attrBinding = this.bindAttribute(attr);
            binding.addAttribute(attrBinding);
            if (!hasOnlyIdAttrs || Constants.QNAME_ID.equals(attrBinding.getType().getQName())) continue;
            hasOnlyIdAttrs = false;
        }
        if (this.processAnnotations && (annotations = type.getAnnotations()) != null) {
            if (this.trace) {
                log.trace((Object)(typeName + " annotations " + annotations.getLength()));
            }
            for (int i = 0; i < annotations.getLength(); ++i) {
                AddMethodMetaData addMethodMetaData;
                PropertyMetaData propertyMetaData;
                boolean skip;
                MapEntryMetaData mapEntryMetaData;
                CharactersMetaData charactersMetaData;
                XSAnnotation an = (XSAnnotation)annotations.item(i);
                XsdAnnotation xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString());
                XsdAppInfo appInfo = xsdAn.getAppInfo();
                if (appInfo == null) continue;
                ClassMetaData classMetaData = appInfo.getClassMetaData();
                if (classMetaData != null) {
                    if (this.trace) {
                        log.trace((Object)("complex type " + type.getName() + ": impl=" + classMetaData.getImpl()));
                    }
                    binding.setClassMetaData(classMetaData);
                }
                if ((charactersMetaData = appInfo.getCharactersMetaData()) != null) {
                    if (this.trace) {
                        boolean mapEntryValue;
                        boolean mapEntryKey;
                        ValueMetaData valueMetaData;
                        PropertyMetaData propertyMetaData2 = charactersMetaData.getProperty();
                        if (propertyMetaData2 != null) {
                            log.trace((Object)("complex type " + type.getName() + ": characters bound to " + propertyMetaData2.getName()));
                        }
                        if ((valueMetaData = charactersMetaData.getValue()) != null) {
                            log.trace((Object)("complex type " + type.getName() + ": characters unmarshalMethod=" + valueMetaData.getUnmarshalMethod() + ", marshalMethod=" + valueMetaData.getMarshalMethod()));
                        }
                        if (mapEntryKey = appInfo.isMapEntryKey()) {
                            log.trace((Object)("complex type " + type.getName() + ": characters are bound as a key in a map entry"));
                        }
                        if (mapEntryValue = appInfo.isMapEntryValue()) {
                            log.trace((Object)("complex type " + type.getName() + ": characters are bound as a value in a map entry"));
                        }
                    }
                    binding.setCharactersMetaData(charactersMetaData);
                }
                if ((mapEntryMetaData = appInfo.getMapEntryMetaData()) != null) {
                    if (this.trace) {
                        log.trace((Object)("complex type " + type.getName() + " is bound to a map entry: impl=" + mapEntryMetaData.getImpl() + ", getKeyMethod=" + mapEntryMetaData.getGetKeyMethod() + ", setKeyMethod=" + mapEntryMetaData.getSetKeyMethod() + ", getValueMethod=" + mapEntryMetaData.getGetValueMethod() + ", setValueMethod=" + mapEntryMetaData.getSetValueMethod() + ", valueType=" + mapEntryMetaData.getValueType() + ", nonNullValue=" + mapEntryMetaData.isNonNullValue()));
                    }
                    if (classMetaData != null) {
                        throw new JBossXBRuntimeException("Illegal binding: both jbxb:class and jbxb:mapEntry are specified for complex type " + type.getName());
                    }
                    binding.setMapEntryMetaData(mapEntryMetaData);
                }
                if (skip = appInfo.isSkip()) {
                    if (this.trace) {
                        log.trace((Object)("complex type " + type.getName() + ": elements of this type will be skipped; their attrs, character content " + "and elements will be set the parent."));
                    }
                    binding.setSkip(skip);
                }
                if ((propertyMetaData = appInfo.getPropertyMetaData()) != null) {
                    if (this.trace) {
                        log.trace((Object)("complex type " + type.getName() + ": the content of elements of this type is bound to property " + propertyMetaData.getName()));
                    }
                    binding.setPropertyMetaData(propertyMetaData);
                }
                if ((addMethodMetaData = appInfo.getAddMethodMetaData()) == null) continue;
                if (this.trace) {
                    log.trace((Object)("complex type " + type.getName() + ": elements of this type will be added to parent objects with addMethod=" + addMethodMetaData.getMethodName() + ", valueType=" + addMethodMetaData.getValueType()));
                }
                binding.setAddMethodMetaData(addMethodMetaData);
            }
        }
        if ((particle = type.getParticle()) != null) {
            this.pushType(binding);
            this.bindParticle(particle);
            this.popType();
        }
        if (binding.getClassMetaData() == null && this.simpleContentWithIdAsSimpleType && particle == null && hasOnlyIdAttrs) {
            binding.setStartElementCreatesObject(false);
        } else {
            binding.setStartElementCreatesObject(true);
        }
        if (binding.hasOnlyXmlMimeAttributes()) {
            XsdBinder.addXOPInclude(binding, this.schema);
        }
        if (this.trace) {
            log.trace((Object)(typeName == null ? "bound complex anonymous type" : "bound complex type " + typeName));
        }
        return binding;
    }

    private AttributeBinding bindAttribute(XSAttributeUse attrUse) {
        XSAnnotation an;
        XSAttributeDeclaration attr = attrUse.getAttrDeclaration();
        QName attrName = new QName(attr.getNamespace(), attr.getName());
        XSSimpleTypeDefinition attrType = attr.getTypeDefinition();
        TypeBinding typeBinding = this.bindSimpleType(attrType);
        if (this.trace) {
            log.trace((Object)("binding attribute " + attrName + ", required=" + attrUse.getRequired()));
        }
        AttributeBinding binding = new AttributeBinding(this.schema, attrName, typeBinding, DefaultHandlers.ATTRIBUTE_HANDLER);
        binding.setRequired(attrUse.getRequired());
        if (attrUse.getConstraintType() == 1) {
            binding.setDefaultConstraint(attrUse.getConstraintValue());
        }
        if (this.processAnnotations && (an = attr.getAnnotation()) != null) {
            XsdAnnotation xsdAn;
            XsdAppInfo appInfo;
            if (this.trace) {
                log.trace((Object)(attrName + " attribute annotation"));
            }
            if ((appInfo = (xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString())).getAppInfo()) != null) {
                boolean mapEntryValue;
                boolean mapEntryKey;
                PropertyMetaData propertyMetaData = appInfo.getPropertyMetaData();
                if (propertyMetaData != null) {
                    binding.setPropertyMetaData(propertyMetaData);
                }
                if (mapEntryKey = appInfo.isMapEntryKey()) {
                    binding.setMapEntryKey(mapEntryKey);
                }
                if (mapEntryValue = appInfo.isMapEntryValue()) {
                    binding.setMapEntryValue(mapEntryValue);
                }
            }
        }
        if (this.trace) {
            String msg = "bound attribute " + attrName;
            msg = binding.getPropertyMetaData() != null ? msg + " property=" + binding.getPropertyMetaData().getName() + ", collectionType=" + binding.getPropertyMetaData().getCollectionType() : (binding.isMapEntryKey() ? msg + "bound as a key in a map entry" : (binding.isMapEntryValue() ? msg + "bound as a value in a map entry" : msg + " type=" + attrType.getName()));
            if (binding.getDefaultConstraint() != null) {
                msg = msg + ", default=" + binding.getDefaultConstraint();
            }
            log.trace((Object)msg);
        }
        return binding;
    }

    private void bindParticle(XSParticle particle) {
        ParticleBinding particleBinding = null;
        XSTerm term = particle.getTerm();
        switch (term.getType()) {
            case 7: {
                XSModelGroup modelGroup = (XSModelGroup)term;
                if (modelGroup.getParticles().getLength() <= 0) break;
                ModelGroupBinding groupBinding = this.bindModelGroup(modelGroup);
                particleBinding = new ParticleBinding(groupBinding);
                particleBinding.setMaxOccursUnbounded(particle.getMaxOccursUnbounded());
                particleBinding.setMinOccurs(particle.getMinOccurs());
                particleBinding.setMaxOccurs(particle.getMaxOccurs());
                Object o = this.peekTypeOrGroup();
                if (o instanceof ModelGroupBinding) {
                    ModelGroupBinding parentGroup = (ModelGroupBinding)o;
                    parentGroup.addParticle(particleBinding);
                    if (this.trace) {
                        log.trace((Object)("added " + groupBinding + " to " + parentGroup));
                    }
                } else if (o instanceof TypeBinding) {
                    TypeBinding typeBinding = (TypeBinding)o;
                    typeBinding.setParticle(particleBinding);
                    if (this.trace) {
                        log.trace((Object)("added " + groupBinding + " to type " + typeBinding.getQName()));
                    }
                }
                if (!groupBinding.getParticles().isEmpty()) break;
                this.pushModelGroup(groupBinding);
                this.bindModelGroupParticles(modelGroup);
                this.popModelGroup();
                break;
            }
            case 9: {
                particleBinding = this.bindWildcard(particle);
                break;
            }
            case 2: {
                particleBinding = this.bindElement((XSElementDeclaration)term, particle.getMinOccurs(), particle.getMaxOccurs(), particle.getMaxOccursUnbounded());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected term type: " + term.getType());
            }
        }
        if (particleBinding != null) {
            particleBinding.getTerm().setRepeatableHandler(ValueListRepeatableParticleHandler.INSTANCE);
        }
    }

    private ModelGroupBinding bindModelGroup(XSModelGroup modelGroup) {
        XSAnnotation annotation;
        ModelGroupBinding groupBinding = this.sharedElements.getGlobalGroup(modelGroup);
        if (groupBinding != null) {
            return groupBinding;
        }
        switch (modelGroup.getCompositor()) {
            case 3: {
                groupBinding = new AllBinding(this.schema);
                break;
            }
            case 2: {
                groupBinding = new ChoiceBinding(this.schema);
                break;
            }
            case 1: {
                groupBinding = new SequenceBinding(this.schema);
                break;
            }
            default: {
                throw new JBossXBRuntimeException("Unexpected model group: " + modelGroup.getCompositor());
            }
        }
        if (this.trace) {
            log.trace((Object)("created model group " + groupBinding));
        }
        if (this.processAnnotations && (annotation = modelGroup.getAnnotation()) != null) {
            XsdBinder.customizeTerm(annotation, groupBinding, this.trace);
        }
        return groupBinding;
    }

    private ParticleBinding bindWildcard(XSParticle particle) {
        XSAnnotation annotation;
        WildcardBinding binding = new WildcardBinding(this.schema);
        ModelGroupBinding group = (ModelGroupBinding)this.peekTypeOrGroup();
        ParticleBinding particleBinding = new ParticleBinding(binding);
        particleBinding.setMaxOccurs(particle.getMaxOccurs());
        particleBinding.setMaxOccursUnbounded(particle.getMaxOccursUnbounded());
        particleBinding.setMinOccurs(particle.getMinOccurs());
        group.addParticle(particleBinding);
        XSWildcard wildcard = (XSWildcard)particle.getTerm();
        if (wildcard.getName() != null) {
            binding.setQName(new QName(wildcard.getNamespace(), wildcard.getName()));
        }
        binding.setProcessContents(wildcard.getProcessContents());
        if (this.processAnnotations && (annotation = wildcard.getAnnotation()) != null) {
            XsdBinder.customizeTerm(annotation, binding, this.trace);
        }
        return particleBinding;
    }

    private ParticleBinding bindElement(XSElementDeclaration elementDec, int minOccurs, int maxOccurs, boolean maxOccursUnbounded) {
        XSAnnotation an;
        QName qName = new QName(elementDec.getNamespace(), elementDec.getName());
        ModelGroupBinding parentGroup = (ModelGroupBinding)this.peekTypeOrGroup();
        boolean global = elementDec.getScope() == 1;
        ElementBinding element = this.schema.getElement(qName);
        if (global && element != null) {
            ParticleBinding particle = new ParticleBinding(element);
            if (parentGroup != null) {
                parentGroup.addParticle(particle);
            }
            particle.setMinOccurs(minOccurs);
            if (maxOccursUnbounded) {
                particle.setMaxOccursUnbounded(maxOccursUnbounded);
            } else {
                particle.setMaxOccurs(maxOccurs);
            }
            return particle;
        }
        TypeBinding type = null;
        boolean shared = this.sharedElements.isShared(elementDec);
        if (shared) {
            type = this.sharedElements.getTypeBinding(elementDec);
        }
        if (type == null) {
            type = this.bindType(elementDec.getTypeDefinition());
            if (shared) {
                this.sharedElements.setTypeBinding(elementDec, type);
            }
        }
        element = new ElementBinding(this.schema, qName, type);
        element.setNillable(elementDec.getNillable());
        ParticleBinding particle = new ParticleBinding(element);
        particle.setMinOccurs(minOccurs);
        particle.setMaxOccurs(maxOccurs);
        particle.setMaxOccursUnbounded(maxOccursUnbounded);
        if (global) {
            this.schema.addElementParticle(particle);
        }
        if (parentGroup != null) {
            parentGroup.addParticle(particle);
            if (this.trace) {
                log.trace((Object)("Element " + element.getQName() + " added to " + parentGroup));
            }
        }
        if (this.trace) {
            TypeBinding parentType = this.peekType();
            QName parentQName = null;
            if (parentType != null) {
                parentQName = parentType.getQName();
            }
            log.trace((Object)("element: name=" + qName + ", type=" + type.getQName() + ", repeatable=" + particle.isRepeatable() + ", nillable=" + element.isNillable() + ", minOccurs=" + minOccurs + ", maxOccurs=" + (maxOccursUnbounded ? "unbounded" : "" + maxOccurs) + ", " + (global ? "global scope" : " owner type=" + parentQName)));
        }
        if (this.processAnnotations && (an = elementDec.getAnnotation()) != null) {
            XsdBinder.customizeTerm(an, element, this.trace);
        }
        return particle;
    }

    private void bindModelGroupParticles(XSModelGroup modelGroup) {
        XSObjectList particles = modelGroup.getParticles();
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            this.bindParticle(particle);
        }
    }

    private static void addXOPInclude(TypeBinding binding, SchemaBinding schema) {
        binding.setHandler(DefaultHandlers.XOP_HANDLER);
        if (binding.getParticle() != null) {
            throw new JBossXBRuntimeException("XOP optimizable type has a particle which is unexpected, please, open a JIRA issue!");
        }
        TypeBinding anyUriType = schema.getType(Constants.QNAME_ANYURI);
        if (anyUriType == null) {
            log.warn((Object)("Type " + Constants.QNAME_ANYURI + " not bound."));
        }
        TypeBinding xopIncludeType = new TypeBinding(new QName("http://www.w3.org/2004/08/xop/include", "Include"));
        xopIncludeType.setSchemaBinding(schema);
        xopIncludeType.addAttribute(new QName("href"), anyUriType, DefaultHandlers.ATTRIBUTE_HANDLER);
        xopIncludeType.setHandler(new XOPIncludeHandler(binding));
        ElementBinding xopInclude = new ElementBinding(schema, new QName("http://www.w3.org/2004/08/xop/include", "Include"), xopIncludeType);
        ParticleBinding particleBinding = new ParticleBinding(xopInclude);
        particleBinding.setMinOccurs(0);
        binding.addParticle(particleBinding);
    }

    private static void customizeTerm(XSAnnotation an, TermBinding term, boolean trace) {
        XsdAnnotation xsdAn = XsdAnnotation.unmarshal(an.getAnnotationString());
        XsdAppInfo appInfo = xsdAn.getAppInfo();
        if (appInfo != null) {
            boolean mapEntryValue;
            boolean mapEntryKey;
            ValueMetaData valueMetaData;
            AddMethodMetaData addMethodMetaData;
            PutMethodMetaData putMethodMetaData;
            MapEntryMetaData mapEntryMetaData;
            PropertyMetaData propertyMetaData;
            Boolean skip = null;
            ClassMetaData classMetaData = appInfo.getClassMetaData();
            if (classMetaData != null) {
                if (trace) {
                    String msg = term.isModelGroup() ? term + " bound to " : (term.isWildcard() ? " wildcard bound to " : "element: name=" + ((ElementBinding)term).getQName() + ", class=");
                    msg = msg + classMetaData.getImpl();
                    log.trace((Object)msg);
                }
                term.setClassMetaData(classMetaData);
                skip = Boolean.FALSE;
            }
            if ((propertyMetaData = appInfo.getPropertyMetaData()) != null) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term + " " : "element: name=" + ((ElementBinding)term).getQName() + ", ";
                    msg = msg + " property=" + propertyMetaData.getName() + ", collectionType=" + propertyMetaData.getCollectionType();
                    log.trace((Object)msg);
                }
                term.setPropertyMetaData(propertyMetaData);
            }
            if ((mapEntryMetaData = appInfo.getMapEntryMetaData()) != null) {
                String msg;
                if (propertyMetaData != null) {
                    String msg2 = "A term can be bound either as a property or as a map entry but not both: " + (term.isModelGroup() ? term.toString() : ((ElementBinding)term).getQName().toString());
                    throw new JBossXBRuntimeException(msg2);
                }
                if (trace) {
                    msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element name=" + ((ElementBinding)term).getQName();
                    msg = msg + " is bound to a map entry: impl=" + mapEntryMetaData.getImpl() + ", getKeyMethod=" + mapEntryMetaData.getGetKeyMethod() + ", setKeyMethod=" + mapEntryMetaData.getSetKeyMethod() + ", getValueMethod=" + mapEntryMetaData.getGetValueMethod() + ", setValueMethod=" + mapEntryMetaData.getSetValueMethod() + ", valueType=" + mapEntryMetaData.getValueType() + ", nonNullValue=" + mapEntryMetaData.isNonNullValue();
                    log.trace((Object)msg);
                }
                if (classMetaData != null) {
                    msg = "Invalid customization: both jbxb:class and jbxb:mapEntry are specified for term " + (term.isWildcard() || term.isModelGroup() ? term.toString() : ((ElementBinding)term).getQName().toString());
                    throw new JBossXBRuntimeException(msg);
                }
                term.setMapEntryMetaData(mapEntryMetaData);
                skip = Boolean.FALSE;
            }
            if ((putMethodMetaData = appInfo.getPutMethodMetaData()) != null) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element: name=" + ((ElementBinding)term).getQName() + ",";
                    msg = msg + " putMethod=" + putMethodMetaData.getName() + ", keyType=" + putMethodMetaData.getKeyType() + ", valueType=" + putMethodMetaData.getValueType();
                    log.trace((Object)msg);
                }
                term.setPutMethodMetaData(putMethodMetaData);
            }
            if ((addMethodMetaData = appInfo.getAddMethodMetaData()) != null) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element: name=" + ((ElementBinding)term).getQName() + ",";
                    msg = msg + " addMethod=" + addMethodMetaData.getMethodName() + ", valueType=" + addMethodMetaData.getValueType() + ", isChildType=" + addMethodMetaData.isChildType();
                    log.trace((Object)msg);
                }
                term.setAddMethodMetaData(addMethodMetaData);
            }
            if ((valueMetaData = appInfo.getValueMetaData()) != null) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element " + ((ElementBinding)term).getQName();
                    msg = msg + ": unmarshalMethod=" + valueMetaData.getUnmarshalMethod();
                    log.trace((Object)msg);
                }
                term.setValueMetaData(valueMetaData);
                if (term.isElement()) {
                    ElementBinding e = (ElementBinding)term;
                    TypeBinding currentType = e.getType();
                    TypeBinding newType = new TypeBinding(currentType.getQName(), currentType);
                    CharactersHandler ch = DefaultHandlers.CHARACTERS_HANDLER_FACTORY.newCharactersHandler(RtCharactersHandler.VALUE_METADATA_UNMARSHAL_HANDLER);
                    newType.setCharactersHandler(ch);
                    e.setType(newType);
                }
            }
            if (mapEntryKey = appInfo.isMapEntryKey()) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element name=" + ((ElementBinding)term).getQName();
                    msg = msg + ": is bound to a key in a map entry";
                    log.trace((Object)msg);
                }
                term.setMapEntryKey(mapEntryKey);
                skip = Boolean.FALSE;
            }
            if (mapEntryValue = appInfo.isMapEntryValue()) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element name=" + ((ElementBinding)term).getQName();
                    msg = msg + ": is bound to a value in a map entry";
                    log.trace((Object)msg);
                }
                term.setMapEntryValue(mapEntryValue);
                skip = Boolean.FALSE;
            }
            boolean skipAnnotation = appInfo.isSkip();
            if (skip != null) {
                term.setSkip(skip);
            } else if (skipAnnotation) {
                if (trace) {
                    String msg = term.isWildcard() || term.isModelGroup() ? term.toString() : "element name=" + ((ElementBinding)term).getQName();
                    msg = msg + ": will be skipped, it's attributes, character content and children will be set on the parent";
                    log.trace((Object)msg);
                }
                term.setSkip(skipAnnotation);
            }
        }
    }

    private void bindGlobalGroup(XSModelGroupDefinition groupDef) {
        QName groupName = new QName(groupDef.getNamespace(), groupDef.getName());
        XSModelGroup group = groupDef.getModelGroup();
        ModelGroupBinding groupBinding = this.bindModelGroup(group);
        groupBinding.setQName(groupName);
        this.sharedElements.addGlobalGroup(group, groupBinding);
        this.schema.addGroup(groupName, groupBinding);
    }

    private void bindGlobalGroupParticles(XSModelGroup group) {
        ModelGroupBinding groupBinding = this.sharedElements.getGlobalGroup(group);
        if (groupBinding.getParticles().isEmpty()) {
            this.pushModelGroup(groupBinding);
            this.bindModelGroupParticles(group);
            this.popModelGroup();
        }
    }

    private void popType() {
        Object o = this.typeGroupStack.remove(this.typeGroupStack.size() - 1);
        if (!(o instanceof TypeBinding)) {
            throw new JBossXBRuntimeException("Should have poped type binding but got " + o);
        }
    }

    private void pushType(TypeBinding binding) {
        this.typeGroupStack.add(binding);
    }

    private void popModelGroup() {
        Object o = this.typeGroupStack.remove(this.typeGroupStack.size() - 1);
        if (!(o instanceof ModelGroupBinding)) {
            throw new JBossXBRuntimeException("Should have poped model group binding but got " + o);
        }
    }

    private void pushModelGroup(ModelGroupBinding binding) {
        this.typeGroupStack.add(binding);
    }

    private Object peekTypeOrGroup() {
        return this.typeGroupStack.isEmpty() ? null : this.typeGroupStack.get(this.typeGroupStack.size() - 1);
    }

    private TypeBinding peekType() {
        TypeBinding binding = null;
        ListIterator<Object> i = this.typeGroupStack.listIterator(this.typeGroupStack.size());
        while (i.hasPrevious()) {
            Object o = i.previous();
            if (!(o instanceof TypeBinding)) continue;
            binding = (TypeBinding)o;
            break;
        }
        return binding;
    }

    private static final class SharedElements {
        private Map<XSElementDeclaration, TypeBinding> elements = Collections.emptyMap();
        private Map<XSModelGroup, ModelGroupBinding> globalGroups = Collections.emptyMap();

        private SharedElements() {
        }

        public void add(XSElementDeclaration element) {
            switch (this.elements.size()) {
                case 0: {
                    this.elements = Collections.singletonMap(element, null);
                    break;
                }
                case 1: {
                    this.elements = new HashMap<XSElementDeclaration, TypeBinding>(this.elements);
                }
                default: {
                    this.elements.put(element, null);
                }
            }
        }

        public boolean isShared(XSElementDeclaration element) {
            return this.elements.containsKey(element);
        }

        public TypeBinding getTypeBinding(XSElementDeclaration element) {
            return this.elements.get(element);
        }

        public void setTypeBinding(XSElementDeclaration element, TypeBinding type) {
            switch (this.elements.size()) {
                case 0: {
                    this.elements = Collections.singletonMap(element, type);
                    break;
                }
                case 1: {
                    this.elements = new HashMap<XSElementDeclaration, TypeBinding>(this.elements);
                }
                default: {
                    this.elements.put(element, type);
                }
            }
        }

        public void addGlobalGroup(XSModelGroup group, ModelGroupBinding groupBinding) {
            switch (this.globalGroups.size()) {
                case 0: {
                    this.globalGroups = Collections.singletonMap(group, groupBinding);
                    break;
                }
                case 1: {
                    this.globalGroups = new HashMap<XSModelGroup, ModelGroupBinding>(this.globalGroups);
                }
                default: {
                    this.globalGroups.put(group, groupBinding);
                }
            }
        }

        public ModelGroupBinding getGlobalGroup(XSModelGroup group) {
            return this.globalGroups.get(group);
        }
    }
}

