/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.BaseDigestCalculator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Store;
import org.bouncycastle.x509.NoSuchStoreException;
import org.bouncycastle.x509.X509Store;

public class CMSSignedData {
    private static final CMSSignedHelper HELPER = CMSSignedHelper.INSTANCE;
    SignedData signedData;
    ContentInfo contentInfo;
    CMSProcessable signedContent;
    SignerInformationStore signerInfoStore;
    X509Store attributeStore;
    X509Store certificateStore;
    X509Store crlStore;
    private Map hashes;

    private CMSSignedData(CMSSignedData cMSSignedData) {
        this.signedData = cMSSignedData.signedData;
        this.contentInfo = cMSSignedData.contentInfo;
        this.signedContent = cMSSignedData.signedContent;
        this.signerInfoStore = cMSSignedData.signerInfoStore;
    }

    public CMSSignedData(byte[] byArray) throws CMSException {
        this(CMSUtils.readContentInfo(byArray));
    }

    public CMSSignedData(CMSProcessable cMSProcessable, byte[] byArray) throws CMSException {
        this(cMSProcessable, CMSUtils.readContentInfo(byArray));
    }

    public CMSSignedData(Map map, byte[] byArray) throws CMSException {
        this(map, CMSUtils.readContentInfo(byArray));
    }

    public CMSSignedData(CMSProcessable cMSProcessable, InputStream inputStream) throws CMSException {
        this(cMSProcessable, CMSUtils.readContentInfo((InputStream)new ASN1InputStream(inputStream)));
    }

    public CMSSignedData(InputStream inputStream) throws CMSException {
        this(CMSUtils.readContentInfo(inputStream));
    }

    public CMSSignedData(CMSProcessable cMSProcessable, ContentInfo contentInfo) {
        this.signedContent = cMSProcessable;
        this.contentInfo = contentInfo;
        this.signedData = SignedData.getInstance((Object)this.contentInfo.getContent());
    }

    public CMSSignedData(Map map, ContentInfo contentInfo) {
        this.hashes = map;
        this.contentInfo = contentInfo;
        this.signedData = SignedData.getInstance((Object)this.contentInfo.getContent());
    }

    public CMSSignedData(ContentInfo contentInfo) {
        this.contentInfo = contentInfo;
        this.signedData = SignedData.getInstance((Object)this.contentInfo.getContent());
        this.signedContent = this.signedData.getEncapContentInfo().getContent() != null ? new CMSProcessableByteArray(((ASN1OctetString)this.signedData.getEncapContentInfo().getContent()).getOctets()) : null;
    }

    public int getVersion() {
        return this.signedData.getVersion().getValue().intValue();
    }

    public SignerInformationStore getSignerInfos() {
        if (this.signerInfoStore == null) {
            ASN1Set aSN1Set = this.signedData.getSignerInfos();
            ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
            DefaultSignatureAlgorithmIdentifierFinder defaultSignatureAlgorithmIdentifierFinder = new DefaultSignatureAlgorithmIdentifierFinder();
            for (int i = 0; i != aSN1Set.size(); ++i) {
                SignerInfo signerInfo = SignerInfo.getInstance((Object)aSN1Set.getObjectAt(i));
                ASN1ObjectIdentifier aSN1ObjectIdentifier = this.signedData.getEncapContentInfo().getContentType();
                if (this.hashes == null) {
                    arrayList.add(new SignerInformation(signerInfo, aSN1ObjectIdentifier, this.signedContent, null, defaultSignatureAlgorithmIdentifierFinder));
                    continue;
                }
                byte[] byArray = (byte[])this.hashes.get(signerInfo.getDigestAlgorithm().getAlgorithm().getId());
                arrayList.add(new SignerInformation(signerInfo, aSN1ObjectIdentifier, null, new BaseDigestCalculator(byArray), defaultSignatureAlgorithmIdentifierFinder));
            }
            this.signerInfoStore = new SignerInformationStore(arrayList);
        }
        return this.signerInfoStore;
    }

    public X509Store getAttributeCertificates(String string, String string2) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        return this.getAttributeCertificates(string, CMSUtils.getProvider(string2));
    }

    public X509Store getAttributeCertificates(String string, Provider provider) throws NoSuchStoreException, CMSException {
        if (this.attributeStore == null) {
            this.attributeStore = HELPER.createAttributeStore(string, provider, this.signedData.getCertificates());
        }
        return this.attributeStore;
    }

    public X509Store getCertificates(String string, String string2) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        return this.getCertificates(string, CMSUtils.getProvider(string2));
    }

    public X509Store getCertificates(String string, Provider provider) throws NoSuchStoreException, CMSException {
        if (this.certificateStore == null) {
            this.certificateStore = HELPER.createCertificateStore(string, provider, this.signedData.getCertificates());
        }
        return this.certificateStore;
    }

    public X509Store getCRLs(String string, String string2) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        return this.getCRLs(string, CMSUtils.getProvider(string2));
    }

    public X509Store getCRLs(String string, Provider provider) throws NoSuchStoreException, CMSException {
        if (this.crlStore == null) {
            this.crlStore = HELPER.createCRLsStore(string, provider, this.signedData.getCRLs());
        }
        return this.crlStore;
    }

    public CertStore getCertificatesAndCRLs(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.getCertificatesAndCRLs(string, CMSUtils.getProvider(string2));
    }

    public CertStore getCertificatesAndCRLs(String string, Provider provider) throws NoSuchAlgorithmException, CMSException {
        ASN1Set aSN1Set = this.signedData.getCertificates();
        ASN1Set aSN1Set2 = this.signedData.getCRLs();
        return HELPER.createCertStore(string, provider, aSN1Set, aSN1Set2);
    }

    public Store getCertificates() {
        ASN1Set aSN1Set = this.signedData.getCertificates();
        if (aSN1Set != null) {
            ArrayList<X509CertificateHolder> arrayList = new ArrayList<X509CertificateHolder>(aSN1Set.size());
            Enumeration enumeration = aSN1Set.getObjects();
            while (enumeration.hasMoreElements()) {
                DERObject dERObject = ((DEREncodable)enumeration.nextElement()).getDERObject();
                if (!(dERObject instanceof ASN1Sequence)) continue;
                arrayList.add(new X509CertificateHolder(X509CertificateStructure.getInstance((Object)dERObject)));
            }
            return new CollectionStore(arrayList);
        }
        return new CollectionStore(new ArrayList());
    }

    public Store getCRLs() {
        ASN1Set aSN1Set = this.signedData.getCRLs();
        if (aSN1Set != null) {
            ArrayList<CertificateList> arrayList = new ArrayList<CertificateList>(aSN1Set.size());
            Enumeration enumeration = aSN1Set.getObjects();
            while (enumeration.hasMoreElements()) {
                DERObject dERObject = ((DEREncodable)enumeration.nextElement()).getDERObject();
                if (!(dERObject instanceof ASN1Sequence)) continue;
                arrayList.add(CertificateList.getInstance((Object)dERObject));
            }
            return new CollectionStore(arrayList);
        }
        return new CollectionStore(new ArrayList());
    }

    public Store getAttributeCertificates() {
        ASN1Set aSN1Set = this.signedData.getCertificates();
        if (aSN1Set != null) {
            ArrayList<X509AttributeCertificateHolder> arrayList = new ArrayList<X509AttributeCertificateHolder>(aSN1Set.size());
            Enumeration enumeration = aSN1Set.getObjects();
            while (enumeration.hasMoreElements()) {
                DERObject dERObject = ((DEREncodable)enumeration.nextElement()).getDERObject();
                if (!(dERObject instanceof ASN1TaggedObject)) continue;
                arrayList.add(new X509AttributeCertificateHolder(AttributeCertificate.getInstance((Object)((ASN1TaggedObject)dERObject).getObject())));
            }
            return new CollectionStore(arrayList);
        }
        return new CollectionStore(new ArrayList());
    }

    public String getSignedContentTypeOID() {
        return this.signedData.getEncapContentInfo().getContentType().getId();
    }

    public CMSProcessable getSignedContent() {
        return this.signedContent;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }

    public static CMSSignedData replaceSigners(CMSSignedData cMSSignedData, SignerInformationStore signerInformationStore) {
        SignerInformation signerInformation2;
        CMSSignedData cMSSignedData2 = new CMSSignedData(cMSSignedData);
        cMSSignedData2.signerInfoStore = signerInformationStore;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (SignerInformation signerInformation2 : signerInformationStore.getSigners()) {
            aSN1EncodableVector.add((DEREncodable)CMSSignedHelper.INSTANCE.fixAlgID(signerInformation2.getDigestAlgorithmID()));
            aSN1EncodableVector2.add((DEREncodable)signerInformation2.toSignerInfo());
        }
        signerInformation2 = new DERSet(aSN1EncodableVector);
        DERSet dERSet = new DERSet(aSN1EncodableVector2);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)cMSSignedData.signedData.getDERObject();
        aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(aSN1Sequence.getObjectAt(0));
        aSN1EncodableVector2.add((DEREncodable)signerInformation2);
        for (int i = 2; i != aSN1Sequence.size() - 1; ++i) {
            aSN1EncodableVector2.add(aSN1Sequence.getObjectAt(i));
        }
        aSN1EncodableVector2.add((DEREncodable)dERSet);
        cMSSignedData2.signedData = SignedData.getInstance((Object)new BERSequence(aSN1EncodableVector2));
        cMSSignedData2.contentInfo = new ContentInfo(cMSSignedData2.contentInfo.getContentType(), (DEREncodable)cMSSignedData2.signedData);
        return cMSSignedData2;
    }

    public static CMSSignedData replaceCertificatesAndCRLs(CMSSignedData cMSSignedData, CertStore certStore) throws CMSException {
        ASN1Set aSN1Set;
        CMSSignedData cMSSignedData2 = new CMSSignedData(cMSSignedData);
        ASN1Set aSN1Set2 = null;
        ASN1Set aSN1Set3 = null;
        try {
            aSN1Set = CMSUtils.createBerSetFromList(CMSUtils.getCertificatesFromStore(certStore));
            if (aSN1Set.size() != 0) {
                aSN1Set2 = aSN1Set;
            }
        }
        catch (CertStoreException certStoreException) {
            throw new CMSException("error getting certs from certStore", certStoreException);
        }
        try {
            aSN1Set = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(certStore));
            if (aSN1Set.size() != 0) {
                aSN1Set3 = aSN1Set;
            }
        }
        catch (CertStoreException certStoreException) {
            throw new CMSException("error getting crls from certStore", certStoreException);
        }
        cMSSignedData2.signedData = new SignedData(cMSSignedData.signedData.getDigestAlgorithms(), cMSSignedData.signedData.getEncapContentInfo(), aSN1Set2, aSN1Set3, cMSSignedData.signedData.getSignerInfos());
        cMSSignedData2.contentInfo = new ContentInfo(cMSSignedData2.contentInfo.getContentType(), (DEREncodable)cMSSignedData2.signedData);
        return cMSSignedData2;
    }

    public static CMSSignedData replaceCertificatesAndCRLs(CMSSignedData cMSSignedData, Store store, Store store2, Store store3) throws CMSException {
        ASN1Set aSN1Set;
        CMSSignedData cMSSignedData2 = new CMSSignedData(cMSSignedData);
        ASN1Set aSN1Set2 = null;
        ASN1Set aSN1Set3 = null;
        if (store != null || store2 != null) {
            ASN1Set aSN1Set4;
            aSN1Set = new ArrayList();
            if (store != null) {
                aSN1Set.addAll(CMSUtils.getCertificatesFromStore(store));
            }
            if (store2 != null) {
                aSN1Set.addAll(CMSUtils.getAttributeCertificatesFromStore(store2));
            }
            if ((aSN1Set4 = CMSUtils.createBerSetFromList((List)aSN1Set)).size() != 0) {
                aSN1Set2 = aSN1Set4;
            }
        }
        if (store3 != null && (aSN1Set = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(store3))).size() != 0) {
            aSN1Set3 = aSN1Set;
        }
        cMSSignedData2.signedData = new SignedData(cMSSignedData.signedData.getDigestAlgorithms(), cMSSignedData.signedData.getEncapContentInfo(), aSN1Set2, aSN1Set3, cMSSignedData.signedData.getSignerInfos());
        cMSSignedData2.contentInfo = new ContentInfo(cMSSignedData2.contentInfo.getContentType(), (DEREncodable)cMSSignedData2.signedData);
        return cMSSignedData2;
    }
}

