/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sun.net.httpserver;

import java.util.LinkedList;
import org.jboss.sun.net.httpserver.HttpContextImpl;

class ContextList {
    static final int MAX_CONTEXTS = 50;
    LinkedList<HttpContextImpl> list = new LinkedList();

    ContextList() {
    }

    public synchronized void add(HttpContextImpl ctx) {
        this.list.add(ctx);
    }

    public synchronized int size() {
        return this.list.size();
    }

    synchronized HttpContextImpl findContext(String protocol, String path) {
        return this.findContext(protocol, path, false);
    }

    synchronized HttpContextImpl findContext(String protocol, String path, boolean exact) {
        protocol = protocol.toLowerCase();
        String longest = "";
        HttpContextImpl lc = null;
        for (HttpContextImpl ctx : this.list) {
            if (!ctx.getProtocol().equals(protocol)) continue;
            String cpath = ctx.getPath();
            if (exact && !cpath.equals(path) || !exact && !path.startsWith(cpath) || cpath.length() <= longest.length()) continue;
            longest = cpath;
            lc = ctx;
        }
        return lc;
    }

    public synchronized void remove(String protocol, String path) throws IllegalArgumentException {
        HttpContextImpl ctx = this.findContext(protocol, path, true);
        if (ctx == null) {
            throw new IllegalArgumentException("cannot remove element from list");
        }
        this.list.remove(ctx);
    }

    public synchronized void remove(HttpContextImpl context) throws IllegalArgumentException {
        for (HttpContextImpl ctx : this.list) {
            if (!ctx.equals(context)) continue;
            this.list.remove(ctx);
            return;
        }
        throw new IllegalArgumentException("no such context in list");
    }
}

