/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.httpclient.methods.GetMethod;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.util.resource.HttpResource;
import org.opensaml.util.resource.ResourceException;
import org.opensaml.util.resource.ResourceFilter;
import org.opensaml.xml.util.DatatypeHelper;

public class FileBackedHttpResource
extends HttpResource {
    private File resourceFile;

    public FileBackedHttpResource(String resource, String backingFile) {
        super(resource);
        if (DatatypeHelper.isEmpty((String)backingFile)) {
            throw new IllegalArgumentException("Backing file path may not be null or empty");
        }
        this.resourceFile = new File(backingFile);
    }

    public FileBackedHttpResource(String resource, URI backingFile) {
        super(resource);
        if (backingFile == null) {
            throw new IllegalArgumentException("Backing file path may not be null or empty");
        }
        this.resourceFile = new File(backingFile);
    }

    public FileBackedHttpResource(String resource, String backingFile, ResourceFilter resourceFilter) {
        super(resource, resourceFilter);
        if (DatatypeHelper.isEmpty((String)backingFile)) {
            throw new IllegalArgumentException("Backing file path may not be null or empty");
        }
        this.resourceFile = new File(backingFile);
    }

    public FileBackedHttpResource(String resource, URI backingFile, ResourceFilter resourceFilter) {
        super(resource, resourceFilter);
        if (backingFile == null) {
            throw new IllegalArgumentException("Backing file path may not be null or empty");
        }
        this.resourceFile = new File(backingFile);
    }

    @Override
    public boolean exists() throws ResourceException {
        if (!super.exists()) {
            return this.resourceFile.exists();
        }
        return true;
    }

    @Override
    public InputStream getInputStream() throws ResourceException {
        InputStream ins = null;
        try {
            GetMethod getMethod = super.getResource();
            byte[] response = getMethod.getResponseBody();
            this.saveToResourceFile(response);
            ins = getMethod.getResponseBodyAsStream();
        }
        catch (Exception e) {
            try {
                ins = new FileInputStream(this.resourceFile);
            }
            catch (IOException ioe) {
                throw new ResourceException("Unable to read resource URL or backing file " + this.resourceFile.getAbsolutePath(), ioe);
            }
        }
        return this.applyFilter(ins);
    }

    @Override
    public DateTime getLastModifiedTime() throws ResourceException {
        try {
            return super.getLastModifiedTime();
        }
        catch (ResourceException e) {
            long lastModifiedTime = this.resourceFile.lastModified();
            if (lastModifiedTime == 0L) {
                throw new ResourceException("URL resource is not reachable and backing file is not readable");
            }
            return new DateTime(lastModifiedTime, (Chronology)ISOChronology.getInstanceUTC());
        }
    }

    @Override
    public String getLocation() {
        return super.getLocation();
    }

    protected void saveToResourceFile(byte[] resource) throws ResourceException {
        try {
            FileOutputStream out = new FileOutputStream(this.resourceFile);
            out.write(resource);
        }
        catch (IOException e) {
            throw new ResourceException("Unable to write resource to backing file " + this.resourceFile.getAbsolutePath(), e);
        }
    }
}

