/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.repository;

import java.io.File;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.repository.HashUtil;

public class LocalDeploymentFileRepository
implements DeploymentFileRepository {
    final File deploymentRoot;

    public LocalDeploymentFileRepository(File deploymentRoot) {
        this.deploymentRoot = deploymentRoot;
    }

    @Override
    public File[] getDeploymentFiles(byte[] deploymentHash) {
        return this.getDeploymentRoot(deploymentHash).listFiles();
    }

    @Override
    public File getDeploymentRoot(byte[] deploymentHash) {
        if (deploymentHash == null || deploymentHash.length == 0) {
            return this.deploymentRoot;
        }
        String hex = HashUtil.bytesToHexString(deploymentHash);
        File first = new File(this.deploymentRoot, hex.substring(0, 2));
        return new File(first, hex.substring(2));
    }

    @Override
    public void deleteDeployment(byte[] deploymentHash) {
        File deployment = this.getDeploymentRoot(deploymentHash);
        if (deployment != this.deploymentRoot) {
            this.deleteRecursively(deployment);
            if (deployment.getParentFile().list().length == 0) {
                deployment.getParentFile().delete();
            }
        }
    }

    private void deleteRecursively(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (String name : file.list()) {
                    this.deleteRecursively(new File(file, name));
                }
            }
            file.delete();
        }
    }
}

