/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.logging;

import java.io.File;
import java.net.URL;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.annotations.Param;
import org.jboss.vfs.VirtualFile;

@MessageBundle(projectCode="JBAS")
public interface AppClientMessages {
    public static final AppClientMessages MESSAGES = (AppClientMessages)Messages.getBundle(AppClientMessages.class);

    @Message(id=0, value="Name of the app client configuration file to use (default is \"appclient.xml\")")
    public String argAppClientConfig();

    @Message(id=0, value="Display this message and exit")
    public String argHelp();

    @Message(id=0, value="Set the url of the application server instance to connect to")
    public String argHost();

    @Message(id=0, value="Load ejb-client.properties file from the given url")
    public String argConnectionProperties();

    @Message(id=0, value="Load system properties from the given url")
    public String argProperties();

    @Message(id=0, value="Set a system property")
    public String argSystemProperty();

    @Message(id=0, value="Usage: ./appclient.sh [args...] myear.ear#appClient.jar [client args...]%n%nwhere args include:%n")
    public String argUsage();

    @Message(id=0, value="Print version and exit")
    public String argVersion();

    @Message(id=13220, value="You must specify the application client to execute")
    public String appClientNotSpecified();

    @Message(id=13221, value="Argument expected for option %s")
    public String argumentExpected(String var1);

    @Message(id=13222, value="Could not find application client jar in deployment")
    public RuntimeException cannotFindAppClient();

    @Message(id=13223, value="Could not find application client %s")
    public DeploymentUnitProcessingException cannotFindAppClient(String var1);

    @Message(id=13224, value="Could not load application client main class")
    public RuntimeException cannotLoadAppClientMainClass(@Cause Throwable var1);

    @Message(id=13225, value="Could not load component class")
    public DeploymentUnitProcessingException cannotLoadComponentClass(@Cause Throwable var1);

    @Message(id=13226, value="Unable to load properties from URL %s")
    public String cannotLoadProperties(URL var1);

    @Message(id=13227, value="Could not start app client %s as no main class was found")
    public RuntimeException cannotStartAppClient(String var1);

    @Message(id=13228, value="Could not start app client %s as no main method was found on main class %s")
    public RuntimeException cannotStartAppClient(String var1, Class<?> var2);

    @Message(id=13229, value="Duplicate subsystem declaration")
    public XMLStreamException duplicateSubsystemDeclaration(@Param Location var1);

    @Message(id=13230, value="%s %s already declared")
    public XMLStreamException elementAlreadyDeclared(String var1, Object var2, @Param Location var3);

    @Message(id=13231, value="Failed to parse %s")
    public DeploymentUnitProcessingException failedToParseXml(@Cause Throwable var1, VirtualFile var2);

    @Message(id=13232, value="Failed to parse %s at [%d,%d]")
    public DeploymentUnitProcessingException failedToParseXml(@Cause Throwable var1, VirtualFile var2, int var3, int var4);

    @Message(id=13233, value="Malformed URL provided for option %s")
    public String malformedUrl(String var1);

    @Message(id=13234, value="More than one application client found and no app client name specified")
    public RuntimeException multipleAppClientsFound();

    @Message(id=13235, value="Model contains multiple %s nodes")
    public IllegalStateException multipleNodesFound(String var1);

    @Message(id=13236, value="Unknown option %s")
    public String unknownOption(String var1);

    @Message(id=13237, value="Could not load callback-handler class %s")
    public DeploymentUnitProcessingException couldNotLoadCallbackClass(String var1);

    @Message(id=13238, value="Could not create instance of callback-handler class %s")
    public DeploymentUnitProcessingException couldNotCreateCallbackHandler(String var1);

    @Message(id=13239, value="Could find application client %s")
    public RuntimeException cannotFindAppClientFile(File var1);

    @Message(id=13240, value="Cannot specify both a host to connect to and an ejb-client.properties file. ")
    public RuntimeException cannotSpecifyBothHostAndPropertiesFile();

    @Message(id=13241, value="Unable to load ejb-client.properties URL: %s ")
    public DeploymentUnitProcessingException exceptionLoadingEjbClientPropertiesURL(String var1, @Cause Throwable var2);
}

