/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.event;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.claims.RequestClaim;
import org.apache.cxf.sts.event.AbstractSTSEvent;
import org.apache.cxf.sts.event.AbstractSTSFailureEvent;
import org.apache.cxf.sts.event.STSEventListener;
import org.apache.cxf.sts.event.StacktraceDefaultFormatter;
import org.apache.cxf.sts.event.StacktraceFormatter;
import org.apache.cxf.sts.event.TokenCancellerParametersSupport;
import org.apache.cxf.sts.event.TokenProviderParametersSupport;
import org.apache.cxf.sts.event.TokenRenewerParametersSupport;
import org.apache.cxf.sts.event.TokenValidatorParametersSupport;
import org.apache.cxf.sts.token.canceller.TokenCancellerParameters;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.sts.token.renewer.TokenRenewerParameters;
import org.apache.cxf.sts.token.validator.TokenValidatorParameters;

public class LoggerListener
implements STSEventListener {
    private static final Logger LOG = LogUtils.getL7dLogger(LoggerListener.class);
    private List<String> fieldOrder = new ArrayList<String>();
    private boolean logStacktrace;
    private boolean logFieldname;
    private Level logLevel = Level.FINE;
    private DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
    private StacktraceFormatter stacktraceFormatter = new StacktraceDefaultFormatter();

    public LoggerListener() {
        this.fieldOrder.add(KEYS.TIME.name());
        this.fieldOrder.add(KEYS.STATUS.name());
        this.fieldOrder.add(KEYS.DURATION.name());
        this.fieldOrder.add(KEYS.REMOTE_HOST.name());
        this.fieldOrder.add(KEYS.REMOTE_PORT.name());
        this.fieldOrder.add(KEYS.OPERATION.name());
        this.fieldOrder.add(KEYS.URL.name());
        this.fieldOrder.add(KEYS.REALM.name());
        this.fieldOrder.add(KEYS.WS_SEC_PRINCIPAL.name());
        this.fieldOrder.add(KEYS.ONBEHALFOF_PRINCIPAL.name());
        this.fieldOrder.add(KEYS.ACTAS_PRINCIPAL.name());
        this.fieldOrder.add(KEYS.VALIDATE_PRINCIPAL.name());
        this.fieldOrder.add(KEYS.CANCEL_PRINCIPAL.name());
        this.fieldOrder.add(KEYS.RENEW_PRINCIPAL.name());
        this.fieldOrder.add(KEYS.TOKENTYPE.name());
        this.fieldOrder.add(KEYS.APPLIESTO.name());
        this.fieldOrder.add(KEYS.CLAIMS_PRIMARY.name());
        this.fieldOrder.add(KEYS.CLAIMS_SECONDARY.name());
        this.fieldOrder.add(KEYS.EXCEPTION.name());
        this.fieldOrder.add(KEYS.STACKTRACE.name());
    }

    @Override
    public void handleSTSEvent(AbstractSTSEvent event) {
        if (event instanceof TokenProviderParametersSupport) {
            this.handleEvent((TokenProviderParametersSupport)((Object)event));
        } else if (event instanceof TokenValidatorParametersSupport) {
            this.handleEvent((TokenValidatorParametersSupport)((Object)event));
        } else if (event instanceof TokenCancellerParametersSupport) {
            this.handleEvent((TokenCancellerParametersSupport)((Object)event));
        } else if (event instanceof TokenRenewerParametersSupport) {
            this.handleEvent((TokenRenewerParametersSupport)((Object)event));
        } else {
            LOG.warning("Unknown STS event: " + event.getClass());
        }
    }

    public void handleEvent(TokenProviderParametersSupport event) {
        try {
            ArrayList<String> claims;
            HashMap<String, String> map = new HashMap<String, String>();
            AbstractSTSEvent baseEvent = (AbstractSTSEvent)((Object)event);
            map.put(KEYS.TIME.name(), this.dateFormat.format(new Date(baseEvent.getTimestamp())));
            map.put(KEYS.OPERATION.name(), baseEvent.getOperation());
            map.put(KEYS.DURATION.name(), String.valueOf(baseEvent.getDuration()) + "ms");
            TokenProviderParameters params = event.getTokenParameters();
            try {
                HttpServletRequest req = (HttpServletRequest)params.getWebServiceContext().getMessageContext().get((Object)"HTTP.REQUEST");
                map.put(KEYS.REMOTE_HOST.name(), req.getRemoteHost());
                map.put(KEYS.REMOTE_PORT.name(), String.valueOf(req.getRemotePort()));
                map.put(KEYS.URL.name(), (String)params.getWebServiceContext().getMessageContext().get((Object)"org.apache.cxf.request.url"));
            }
            catch (NullPointerException ex) {
                map.put(KEYS.REMOTE_HOST.name(), "N.A.");
                map.put(KEYS.REMOTE_PORT.name(), "N.A.");
                map.put(KEYS.URL.name(), "N.A.");
            }
            try {
                map.put(KEYS.TOKENTYPE.name(), params.getTokenRequirements().getTokenType());
            }
            catch (NullPointerException ex) {
                map.put(KEYS.TOKENTYPE.name(), "N.A.");
            }
            try {
                if (params.getTokenRequirements().getOnBehalfOf() != null) {
                    map.put(KEYS.ONBEHALFOF_PRINCIPAL.name(), params.getTokenRequirements().getOnBehalfOf().getPrincipal().getName());
                }
                if (params.getTokenRequirements().getActAs() != null) {
                    map.put(KEYS.ACTAS_PRINCIPAL.name(), params.getTokenRequirements().getActAs().getPrincipal().getName());
                }
                if (params.getPrincipal() != null) {
                    map.put(KEYS.WS_SEC_PRINCIPAL.name(), params.getPrincipal().getName());
                }
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
            map.put(KEYS.REALM.name(), params.getRealm());
            map.put(KEYS.APPLIESTO.name(), params.getAppliesToAddress());
            if (params.getRequestedPrimaryClaims() != null && this.fieldOrder.indexOf(KEYS.CLAIMS_PRIMARY.name()) != -1) {
                claims = new ArrayList<String>();
                for (RequestClaim claim : params.getRequestedPrimaryClaims()) {
                    claims.add(claim.getClaimType().toString());
                }
                map.put(KEYS.CLAIMS_PRIMARY.name(), ((Object)claims).toString());
            }
            if (params.getRequestedSecondaryClaims() != null && this.fieldOrder.indexOf(KEYS.CLAIMS_SECONDARY.name()) != -1) {
                claims = new ArrayList();
                for (RequestClaim claim : params.getRequestedSecondaryClaims()) {
                    claims.add(claim.getClaimType().toString());
                }
                map.put(KEYS.CLAIMS_SECONDARY.name(), ((Object)claims).toString());
            }
            if (event instanceof AbstractSTSFailureEvent) {
                map.put(KEYS.STATUS.name(), "FAILURE");
                Exception ex = ((AbstractSTSFailureEvent)((Object)event)).getException();
                map.put(KEYS.EXCEPTION.name(), ex.getMessage());
                if (this.isLogStacktrace() && this.stacktraceFormatter != null) {
                    map.put(KEYS.STACKTRACE.name(), this.stacktraceFormatter.format(ex));
                }
            } else {
                map.put(KEYS.STATUS.name(), "SUCCESS");
            }
            this.writeLog(map);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to capture or write logging details", ex);
        }
    }

    public void handleEvent(TokenValidatorParametersSupport event) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            AbstractSTSEvent baseEvent = (AbstractSTSEvent)((Object)event);
            map.put(KEYS.TIME.name(), this.dateFormat.format(new Date(baseEvent.getTimestamp())));
            map.put(KEYS.OPERATION.name(), baseEvent.getOperation());
            map.put(KEYS.DURATION.name(), String.valueOf(baseEvent.getDuration()) + "ms");
            TokenValidatorParameters params = event.getTokenParameters();
            HttpServletRequest req = (HttpServletRequest)params.getWebServiceContext().getMessageContext().get((Object)"HTTP.REQUEST");
            map.put(KEYS.REMOTE_HOST.name(), req.getRemoteHost());
            map.put(KEYS.REMOTE_PORT.name(), String.valueOf(req.getRemotePort()));
            map.put(KEYS.URL.name(), (String)params.getWebServiceContext().getMessageContext().get((Object)"org.apache.cxf.request.url"));
            map.put(KEYS.TOKENTYPE.name(), params.getTokenRequirements().getTokenType());
            if (params.getTokenRequirements().getActAs() != null) {
                map.put(KEYS.VALIDATE_PRINCIPAL.name(), params.getTokenRequirements().getValidateTarget().getPrincipal().getName());
            }
            if (params.getPrincipal() != null) {
                map.put(KEYS.WS_SEC_PRINCIPAL.name(), params.getPrincipal().getName());
            }
            map.put(KEYS.REALM.name(), params.getRealm());
            if (event instanceof AbstractSTSFailureEvent) {
                map.put(KEYS.STATUS.name(), "FAILURE");
                Exception ex = ((AbstractSTSFailureEvent)((Object)event)).getException();
                map.put(KEYS.EXCEPTION.name(), ex.getMessage());
                if (this.isLogStacktrace() && this.stacktraceFormatter != null) {
                    map.put(KEYS.STACKTRACE.name(), this.stacktraceFormatter.format(ex));
                }
            } else {
                map.put(KEYS.STATUS.name(), "SUCCESS");
            }
            this.writeLog(map);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to capture or write logging details", ex);
        }
    }

    public void handleEvent(TokenCancellerParametersSupport event) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            AbstractSTSEvent baseEvent = (AbstractSTSEvent)((Object)event);
            map.put(KEYS.TIME.name(), this.dateFormat.format(new Date(baseEvent.getTimestamp())));
            map.put(KEYS.OPERATION.name(), baseEvent.getOperation());
            map.put(KEYS.DURATION.name(), String.valueOf(baseEvent.getDuration()) + "ms");
            TokenCancellerParameters params = event.getTokenParameters();
            HttpServletRequest req = (HttpServletRequest)params.getWebServiceContext().getMessageContext().get((Object)"HTTP.REQUEST");
            map.put(KEYS.REMOTE_HOST.name(), req.getRemoteHost());
            map.put(KEYS.REMOTE_PORT.name(), String.valueOf(req.getRemotePort()));
            map.put(KEYS.URL.name(), (String)params.getWebServiceContext().getMessageContext().get((Object)"org.apache.cxf.request.url"));
            map.put(KEYS.TOKENTYPE.name(), params.getTokenRequirements().getTokenType());
            if (params.getTokenRequirements().getActAs() != null) {
                map.put(KEYS.CANCEL_PRINCIPAL.name(), params.getTokenRequirements().getCancelTarget().getPrincipal().getName());
            }
            if (params.getPrincipal() != null) {
                map.put(KEYS.WS_SEC_PRINCIPAL.name(), params.getPrincipal().getName());
            }
            if (event instanceof AbstractSTSFailureEvent) {
                map.put(KEYS.STATUS.name(), "FAILURE");
                Exception ex = ((AbstractSTSFailureEvent)((Object)event)).getException();
                map.put(KEYS.EXCEPTION.name(), ex.getMessage());
                if (this.isLogStacktrace() && this.stacktraceFormatter != null) {
                    map.put(KEYS.STACKTRACE.name(), this.stacktraceFormatter.format(ex));
                }
            } else {
                map.put(KEYS.STATUS.name(), "SUCCESS");
            }
            this.writeLog(map);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to capture or write logging details", ex);
        }
    }

    public void handleEvent(TokenRenewerParametersSupport event) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            AbstractSTSEvent baseEvent = (AbstractSTSEvent)((Object)event);
            map.put(KEYS.TIME.name(), this.dateFormat.format(new Date(baseEvent.getTimestamp())));
            map.put(KEYS.OPERATION.name(), baseEvent.getOperation());
            map.put(KEYS.DURATION.name(), String.valueOf(baseEvent.getDuration()) + "ms");
            TokenRenewerParameters params = event.getTokenParameters();
            HttpServletRequest req = (HttpServletRequest)params.getWebServiceContext().getMessageContext().get((Object)"HTTP.REQUEST");
            map.put(KEYS.REMOTE_HOST.name(), req.getRemoteHost());
            map.put(KEYS.REMOTE_PORT.name(), String.valueOf(req.getRemotePort()));
            map.put(KEYS.URL.name(), (String)params.getWebServiceContext().getMessageContext().get((Object)"org.apache.cxf.request.url"));
            map.put(KEYS.TOKENTYPE.name(), params.getTokenRequirements().getTokenType());
            if (params.getTokenRequirements().getRenewTarget() != null) {
                map.put(KEYS.RENEW_PRINCIPAL.name(), params.getTokenRequirements().getRenewTarget().getPrincipal().getName());
            }
            if (params.getPrincipal() != null) {
                map.put(KEYS.WS_SEC_PRINCIPAL.name(), params.getPrincipal().getName());
            }
            map.put(KEYS.REALM.name(), params.getRealm());
            map.put(KEYS.APPLIESTO.name(), params.getAppliesToAddress());
            if (event instanceof AbstractSTSFailureEvent) {
                map.put(KEYS.STATUS.name(), "FAILURE");
                Exception ex = ((AbstractSTSFailureEvent)((Object)event)).getException();
                map.put(KEYS.EXCEPTION.name(), ex.getMessage());
                if (this.isLogStacktrace() && this.stacktraceFormatter != null) {
                    map.put(KEYS.STACKTRACE.name(), this.stacktraceFormatter.format(ex));
                }
            } else {
                map.put(KEYS.STATUS.name(), "SUCCESS");
            }
            this.writeLog(map);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to capture or write logging details", ex);
        }
    }

    protected void writeLog(Map<String, String> map) {
        StringBuilder builder = new StringBuilder();
        for (String key : this.fieldOrder) {
            if (this.logFieldname) {
                builder.append(key).append("=").append(map.get(key)).append(";");
                continue;
            }
            builder.append(map.get(key)).append(";");
        }
        LOG.log(this.logLevel, builder.toString());
    }

    public List<String> getFieldOrder() {
        return this.fieldOrder;
    }

    public void setFieldOrder(List<String> fieldOrder) {
        this.fieldOrder = fieldOrder;
    }

    public boolean isLogStacktrace() {
        return this.logStacktrace;
    }

    public void setLogStacktrace(boolean logStacktrace) {
        this.logStacktrace = logStacktrace;
    }

    public boolean isLogFieldname() {
        return this.logFieldname;
    }

    public void setLogFieldname(boolean logFieldname) {
        this.logFieldname = logFieldname;
    }

    public void setDateFormat(String format) {
        this.dateFormat = new SimpleDateFormat(format);
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = Level.parse(logLevel);
    }

    public StacktraceFormatter getStacktraceFormatter() {
        return this.stacktraceFormatter;
    }

    public void setStacktraceFormatter(StacktraceFormatter stacktraceFormatter) {
        this.stacktraceFormatter = stacktraceFormatter;
    }

    public static enum KEYS {
        TIME,
        OPERATION,
        WS_SEC_PRINCIPAL,
        STATUS,
        TOKENTYPE,
        EXCEPTION,
        REALM,
        APPLIESTO,
        CLAIMS_PRIMARY,
        CLAIMS_SECONDARY,
        DURATION,
        ACTAS_PRINCIPAL,
        ONBEHALFOF_PRINCIPAL,
        VALIDATE_PRINCIPAL,
        CANCEL_PRINCIPAL,
        RENEW_PRINCIPAL,
        REMOTE_HOST,
        REMOTE_PORT,
        URL,
        STACKTRACE;

    }
}

