/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.constraint.management.AccessConstraintDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;

public final class TargetAttribute {
    private static final List<AccessConstraintDefinition> NO_CONSTRAINTS = Collections.emptyList();
    private final TargetResource targetResource;
    private final AttributeAccess attributeAccess;
    private final ModelNode currentValue;

    public TargetAttribute(AttributeAccess attributeAccess, ModelNode currentValue, TargetResource targetResource) {
        this.targetResource = targetResource;
        this.currentValue = currentValue;
        this.attributeAccess = attributeAccess;
    }

    public TargetResource getTargetResource() {
        return this.targetResource;
    }

    public AttributeAccess.AccessType getAccessType() {
        return this.attributeAccess == null ? null : this.attributeAccess.getAccessType();
    }

    public AttributeAccess.Storage getStorageType() {
        return this.attributeAccess == null ? null : this.attributeAccess.getStorageType();
    }

    public AttributeDefinition getAttributeDefinition() {
        return this.attributeAccess == null ? null : this.attributeAccess.getAttributeDefinition();
    }

    public Set<AttributeAccess.Flag> getFlags() {
        if (this.attributeAccess == null) {
            return Collections.emptySet();
        }
        return this.attributeAccess.getFlags();
    }

    public ModelNode getCurrentValue() {
        return this.currentValue;
    }

    public Set<String> getServerGroups() {
        return this.targetResource.getServerGroups();
    }

    public Set<String> getHosts() {
        return this.targetResource.getHosts();
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        AttributeDefinition def = this.getAttributeDefinition();
        return def != null ? def.getAccessConstraints() : NO_CONSTRAINTS;
    }
}

