/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.rbac;

import java.security.Permission;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.rbac.RoleMapper;
import org.jboss.as.controller.access.rbac.RunAsRolePermission;
import org.jboss.as.controller.access.rbac.StandardRole;

public class ConfigurableRoleMapper
implements RoleMapper {
    private static final String IN_VM_ROLE = StandardRole.SUPERUSER.toString();
    private static final RunAsRolePermission RUN_AS_IN_VM_ROLE = new RunAsRolePermission(IN_VM_ROLE);
    private volatile HashMap<String, Role> roles = new HashMap();
    private final Map<Object, Role> removedRoles = new WeakHashMap<Object, Role>();
    private volatile boolean useRealmRoles;

    public void addRoleImmediate(String roleName) {
        this.roles.put(roleName, new Role(roleName));
    }

    public synchronized void addRole(String roleName) {
        HashMap<String, Role> newRoles = new HashMap<String, Role>(this.roles);
        if (!newRoles.containsKey(roleName)) {
            newRoles.put(roleName, new Role(roleName));
            this.roles = newRoles;
        }
    }

    public synchronized Object removeRole(String roleName) {
        HashMap<String, Role> newRoles = new HashMap<String, Role>(this.roles);
        if (newRoles.containsKey(roleName)) {
            Role removed = newRoles.remove(roleName);
            Object removalKey = new Object();
            this.removedRoles.put(removalKey, removed);
            this.roles = newRoles;
            return removalKey;
        }
        return null;
    }

    public synchronized boolean undoRemove(Object removalKey) {
        HashMap<String, Role> newRoles = new HashMap<String, Role>(this.roles);
        Role toRestore = this.removedRoles.remove(removalKey);
        if (toRestore != null && !newRoles.containsKey(toRestore.getName())) {
            newRoles.put(toRestore.getName(), toRestore);
            this.roles = newRoles;
            return true;
        }
        return false;
    }

    public boolean addPrincipal(String roleName, PrincipalType principalType, MatchType matchType, String name, String realm, boolean immediate) {
        Role role = this.roles.get(roleName);
        if (role != null) {
            if (immediate) {
                return role.addPrincipalImmediate(this.createPrincipal(principalType, name, realm), matchType);
            }
            return role.addPrincipal(this.createPrincipal(principalType, name, realm), matchType);
        }
        return false;
    }

    public boolean removePrincipal(String roleName, PrincipalType principalType, MatchType matchType, String name, String realm) {
        Role role = this.roles.get(roleName);
        if (role != null) {
            return role.removePrincipal(this.createPrincipal(principalType, name, realm), matchType);
        }
        return false;
    }

    private Principal createPrincipal(PrincipalType principalType, String name, String realm) {
        return new Principal(principalType, name, realm);
    }

    public void setUseRealmRoles(boolean useRealmRoles) {
        this.useRealmRoles = useRealmRoles;
    }

    @Override
    public Set<String> mapRoles(Caller caller, Environment callEnvironment, Action action, TargetAttribute attribute) {
        return this.mapRoles(caller);
    }

    @Override
    public Set<String> mapRoles(Caller caller, Environment callEnvironment, Action action, TargetResource resource) {
        return this.mapRoles(caller);
    }

    private Set<String> mapRoles(Caller caller) {
        HashSet<String> mappedRoles = new HashSet<String>();
        boolean traceEnabled = ControllerLogger.ACCESS_LOGGER.isTraceEnabled();
        if (caller.hasSubject()) {
            HashMap<String, Role> rolesToCheck;
            if (this.useRealmRoles) {
                rolesToCheck = new HashMap<String, Role>(this.roles);
                Set<String> realmRoles = caller.getAssociatedRoles();
                for (String current : realmRoles) {
                    String roleName = current.toUpperCase();
                    if (rolesToCheck.containsKey(roleName)) {
                        Role role = rolesToCheck.remove(roleName);
                        Principal exclusion = role.isExcluded(caller);
                        if (exclusion == null) {
                            if (traceEnabled) {
                                ControllerLogger.ACCESS_LOGGER.tracef("User '%s' assigned role '%s' due to realm assignment and no exclusion in role mapping definition.", caller.getName(), roleName);
                            }
                            mappedRoles.add(roleName);
                            continue;
                        }
                        if (!traceEnabled) continue;
                        ControllerLogger.ACCESS_LOGGER.tracef("User '%s' NOT assigned role '%s' despite realm assignment due to exclusion match against %s.", caller.getName(), roleName, exclusion);
                        continue;
                    }
                    if (traceEnabled) {
                        ControllerLogger.ACCESS_LOGGER.tracef("User '%s' assigned role '%s' due to realm assignment and no role mapping to check for exclusion.", caller.getName(), roleName);
                    }
                    mappedRoles.add(roleName);
                }
            } else {
                rolesToCheck = this.roles;
            }
            for (Role role : rolesToCheck.values()) {
                Principal inclusion = role.isIncluded(caller);
                if (inclusion != null) {
                    Principal exclusion = role.isExcluded(caller);
                    if (exclusion == null) {
                        if (traceEnabled) {
                            ControllerLogger.ACCESS_LOGGER.tracef("User '%s' assiged role '%s' due to match on inclusion %s", caller.getName(), role.getName(), inclusion);
                        }
                        mappedRoles.add(role.getName());
                        continue;
                    }
                    if (!traceEnabled) continue;
                    ControllerLogger.ACCESS_LOGGER.tracef("User '%s' denied membership of role '%s' due to exclusion %s", caller.getName(), role.getName(), exclusion);
                    continue;
                }
                if (!traceEnabled) continue;
                ControllerLogger.ACCESS_LOGGER.tracef("User '%s' not assigned role '%s' as no match on the include definition of the role mapping.", caller.getName(), role.getName());
            }
        } else {
            ConfigurableRoleMapper.checkPermission(RUN_AS_IN_VM_ROLE);
            ControllerLogger.ACCESS_LOGGER.tracef("Assigning role '%s' for call with no assigned Subject (An IN-VM Call).", IN_VM_ROLE);
            mappedRoles.add(IN_VM_ROLE);
        }
        if (traceEnabled) {
            StringBuilder sb = new StringBuilder("User '").append(caller.getName()).append("' Assigned Roles { ");
            for (String string : mappedRoles) {
                sb.append("'").append(string).append("' ");
            }
            sb.append("}");
            ControllerLogger.ACCESS_LOGGER.trace(sb.toString());
        }
        return Collections.unmodifiableSet(mappedRoles);
    }

    private static void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }

    private final class Principal {
        private final PrincipalType type;
        private final String realm;
        private final String name;
        private final int hashCode;

        private Principal(PrincipalType type, String name, String realm) {
            this.type = type;
            this.name = name;
            this.realm = realm;
            this.hashCode = type.ordinal() * name.hashCode() * (realm == null ? 31 : realm.hashCode());
        }

        public PrincipalType getType() {
            return this.type;
        }

        public String getRealm() {
            return this.realm;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            return obj instanceof Principal ? this.equals((Principal)obj) : false;
        }

        public boolean equals(Principal obj) {
            return this.type == obj.type && this.name.equals(obj.name) && (this.realm == null ? obj.realm == null : this.realm.equals(obj.realm));
        }

        public String toString() {
            return "Principal [type=" + (Object)((Object)this.type) + ", realm=" + this.realm + ", name=" + this.name + "]";
        }
    }

    private class Role {
        private final String name;
        private volatile HashSet<Principal> includes = new HashSet();
        private volatile HashSet<Principal> excludes = new HashSet();

        private Role(String name) {
            this.name = name;
        }

        private String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[Role name='" + this.name + "' ");
            sb.append("{Includes = ");
            for (Principal current : this.includes) {
                sb.append(current.toString());
            }
            sb.append("}");
            sb.append("{Excludes = ");
            for (Principal current : this.excludes) {
                sb.append(current.toString());
            }
            sb.append("}");
            sb.append("]");
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addPrincipalImmediate(Principal principal, MatchType matchType) {
            HashSet<Principal> set = this.getSet(matchType, true);
            try {
                boolean bl = set.add(principal);
                return bl;
            }
            finally {
                this.setSet(set, matchType, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean addPrincipal(Principal principal, MatchType matchType) {
            HashSet<Principal> set = this.getSet(matchType, false);
            try {
                boolean bl = set.add(principal);
                return bl;
            }
            finally {
                this.setSet(set, matchType, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean removePrincipal(Principal principal, MatchType matchType) {
            HashSet<Principal> set = this.getSet(matchType, false);
            try {
                boolean bl = set.remove(principal);
                return bl;
            }
            finally {
                this.setSet(set, matchType, false);
            }
        }

        private Principal isIncluded(Caller caller) {
            return this.isInSet(caller, this.includes);
        }

        private Principal isExcluded(Caller caller) {
            return this.isInSet(caller, this.excludes);
        }

        private Principal isInSet(Caller caller, HashSet<Principal> theSet) {
            String accountName = null;
            String realm = null;
            Set<String> groups = null;
            for (Principal current : theSet) {
                String expectedRealm = current.getRealm();
                switch (current.getType()) {
                    case USER: {
                        if (expectedRealm != null) {
                            accountName = this.getAccountName(caller, accountName);
                            if (!current.getName().equals(accountName) || !expectedRealm.equals(realm = this.getRealmName(caller, realm))) break;
                            return current;
                        }
                        accountName = this.getAccountName(caller, accountName);
                        if (!current.getName().equals(accountName)) break;
                        return current;
                    }
                    case GROUP: {
                        if (!(expectedRealm != null ? (groups = this.getGroups(caller, groups)).contains(current.getName()) && expectedRealm.equals(realm = this.getRealmName(caller, realm)) : (groups = this.getGroups(caller, groups)).contains(current.getName()))) break;
                        return current;
                    }
                }
            }
            return null;
        }

        private String getAccountName(Caller caller, String currentValue) {
            return currentValue != null ? currentValue : caller.getName();
        }

        private String getRealmName(Caller caller, String currentValue) {
            return currentValue != null ? currentValue : caller.getRealm();
        }

        private Set<String> getGroups(Caller caller, Set<String> currentValue) {
            return currentValue != null ? currentValue : caller.getAssociatedGroups();
        }

        private HashSet<Principal> getSet(MatchType matchType, boolean immediate) {
            HashSet set;
            switch (matchType) {
                case INCLUDE: {
                    set = this.includes;
                    break;
                }
                default: {
                    set = this.excludes;
                }
            }
            return immediate ? set : new HashSet(set);
        }

        private void setSet(HashSet<Principal> set, MatchType matchType, boolean immediate) {
            if (!immediate) {
                switch (matchType) {
                    case INCLUDE: {
                        this.includes = set;
                        break;
                    }
                    case EXCLUDE: {
                        this.excludes = set;
                    }
                }
            }
        }
    }

    public static enum MatchType {
        EXCLUDE,
        INCLUDE;

    }

    public static enum PrincipalType {
        GROUP,
        USER;

    }
}

