/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.registry.LegacyResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformationUtils;
import org.jboss.dmr.ModelNode;

public abstract class AbstractResourceModelTransformer
implements ResourceTransformer {
    private final ResourceDefinitionLoader loader;

    protected AbstractResourceModelTransformer(ResourceDefinitionLoader loader) {
        this.loader = loader;
    }

    protected abstract ModelNode transformModel(TransformationContext var1, ModelNode var2);

    @Override
    public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) {
        ModelNode recursive = Resource.Tools.readModel(resource);
        ModelNode result = this.transformModel(context, recursive);
        TransformationTarget target = context.getTarget();
        ResourceDefinition definition = this.loader.load(target);
        ManagementResourceRegistration targetDefinition = ManagementResourceRegistration.Factory.create(definition);
        Resource transformed = TransformationUtils.modelToResource(address, targetDefinition, result, false);
        context.addTransformedRecursiveResource(PathAddress.EMPTY_ADDRESS, transformed);
    }

    public static abstract class AbstractDefinitionLoader
    implements ResourceDefinitionLoader {
        abstract InputStream openStream(TransformationTarget var1) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ResourceDefinition load(TransformationTarget target) {
            ModelNode model = null;
            try {
                InputStream is = this.openStream(target);
                try {
                    if (is == null) {
                        ResourceDefinition resourceDefinition = null;
                        return resourceDefinition;
                    }
                    model = ModelNode.fromStream((InputStream)is);
                }
                catch (IOException e) {
                    ControllerLogger.ROOT_LOGGER.cannotReadTargetDefinition(e);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (IOException e) {
                ControllerLogger.ROOT_LOGGER.cannotReadTargetDefinition(e);
            }
            if (model == null) return null;
            return new LegacyResourceDefinition(model);
        }
    }

    public static interface ResourceDefinitionLoader {
        public ResourceDefinition load(TransformationTarget var1);
    }
}

