/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.webservices.service.ClientConfigService;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.wsf.spi.management.ServerConfig;

final class ClientConfigAdd
extends AbstractAddStepHandler {
    static final ClientConfigAdd INSTANCE = new ClientConfigAdd();

    private ClientConfigAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        super.rollbackRuntime(context, operation, model, controllers);
        if (!context.isBooting()) {
            context.revertReloadRequired();
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ClientConfigService clientConfigService = new ClientConfigService(name);
        ServiceTarget target = context.getServiceTarget();
        ServiceBuilder clientServiceBuilder = target.addService(WSServices.CLIENT_CONFIG_SERVICE.append(new String[]{name}), (Service)clientConfigService);
        clientServiceBuilder.addDependency(WSServices.CONFIG_SERVICE, ServerConfig.class, clientConfigService.getServerConfig());
        clientServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        if (!context.isBooting()) {
            context.reloadRequired();
        }
    }
}

