/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.servlet.BaseUrlHelper;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.transports.http.QueryHandlerRegistry;

public class ServletController {
    protected static final String DEFAULT_LISTINGS_CLASSIFIER = "/services";
    private static final Logger LOG = LogUtils.getL7dLogger(ServletController.class);
    private static final String HTTP_PREFIX = "http";
    protected boolean isHideServiceList;
    protected boolean disableAddressUpdates;
    protected String forcedBaseAddress;
    protected String serviceListRelativePath = "/services";
    protected ServletConfig servletConfig;
    protected DestinationRegistry destinationRegistry;
    protected HttpServlet serviceListGenerator;

    public ServletController(DestinationRegistry destinationRegistry, ServletConfig config, HttpServlet serviceListGenerator) {
        this.servletConfig = config;
        this.destinationRegistry = destinationRegistry;
        this.serviceListGenerator = serviceListGenerator;
        this.init();
    }

    public void setServiceListRelativePath(String relativePath) {
        this.serviceListRelativePath = relativePath;
    }

    protected String getBaseURL(HttpServletRequest request) {
        return this.forcedBaseAddress == null ? BaseUrlHelper.getBaseURL(request) : this.forcedBaseAddress;
    }

    protected void setBaseURLAttribute(HttpServletRequest request) {
        request.setAttribute(Message.BASE_PATH, (Object)this.getBaseURL(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDestination(HttpServletRequest request, AbstractHTTPDestination d) {
        String base = this.getBaseURL(request);
        AbstractHTTPDestination abstractHTTPDestination = d;
        synchronized (abstractHTTPDestination) {
            String ad = d.getEndpointInfo().getAddress();
            if (ad == null && d.getAddress() != null && d.getAddress().getAddress() != null && (ad = d.getAddress().getAddress().getValue()) == null) {
                ad = "/";
            }
            if (ad != null && !ad.startsWith(HTTP_PREFIX)) {
                if (this.disableAddressUpdates) {
                    request.setAttribute("org.apache.cxf.transport.endpoint.address", (Object)(base + ad));
                } else {
                    BaseUrlHelper.setAddress((AbstractDestination)d, base + ad);
                }
            }
        }
    }

    private void init() {
        String isForcedBaseAddress;
        String isDisableAddressUpdates;
        if (this.servletConfig == null) {
            return;
        }
        String hideServiceList = this.servletConfig.getInitParameter("hide-service-list-page");
        if (!StringUtils.isEmpty((String)hideServiceList)) {
            this.isHideServiceList = Boolean.valueOf(hideServiceList);
        }
        if (!StringUtils.isEmpty((String)(isDisableAddressUpdates = this.servletConfig.getInitParameter("disable-address-updates")))) {
            this.disableAddressUpdates = Boolean.valueOf(isDisableAddressUpdates);
        }
        if (!StringUtils.isEmpty((String)(isForcedBaseAddress = this.servletConfig.getInitParameter("base-address")))) {
            this.forcedBaseAddress = isForcedBaseAddress;
        }
        try {
            this.serviceListGenerator.init(this.servletConfig);
        }
        catch (ServletException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        String serviceListPath = this.servletConfig.getInitParameter("service-list-path");
        if (!StringUtils.isEmpty((String)serviceListPath)) {
            this.serviceListRelativePath = serviceListPath;
        }
    }

    public boolean filter(HttpServletRequest request, HttpServletResponse res) throws ServletException {
        return this.invoke(request, res, false);
    }

    public void invoke(HttpServletRequest request, HttpServletResponse res) throws ServletException {
        this.invoke(request, res, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean invoke(HttpServletRequest request, HttpServletResponse res, boolean returnErrors) throws ServletException {
        try {
            String pathInfo = request.getPathInfo() == null ? "" : request.getPathInfo();
            AbstractHTTPDestination d = this.destinationRegistry.getDestinationForPath(pathInfo, true);
            if (d == null) {
                if (!this.isHideServiceList && (request.getRequestURI().endsWith(this.serviceListRelativePath) || request.getRequestURI().endsWith(this.serviceListRelativePath + "/") || StringUtils.isEmpty((String)pathInfo) || "/".equals(pathInfo))) {
                    this.setBaseURLAttribute(request);
                    this.serviceListGenerator.service((ServletRequest)request, (ServletResponse)res);
                } else {
                    d = this.destinationRegistry.checkRestfulRequest(pathInfo);
                    if (d == null || d.getMessageObserver() == null) {
                        if (!returnErrors) return false;
                        LOG.warning("Can't find the the request for " + request.getRequestURL() + "'s Observer ");
                        this.generateNotFound(request, res);
                        return false;
                    }
                }
            }
            if (d == null) return true;
            Bus bus = d.getBus();
            ClassLoaderUtils.ClassLoaderHolder orig = null;
            try {
                if (bus != null) {
                    ResourceManager manager;
                    ClassLoader loader = (ClassLoader)bus.getExtension(ClassLoader.class);
                    if (loader == null && (manager = (ResourceManager)bus.getExtension(ResourceManager.class)) != null) {
                        loader = (ClassLoader)manager.resolveResource("", ClassLoader.class);
                    }
                    if (loader != null) {
                        orig = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)loader);
                    }
                }
                this.updateDestination(request, d);
                if (bus != null) {
                    String baseUri;
                    String ctxUri;
                    EndpointInfo ei;
                    QueryHandler selectedHandler;
                    QueryHandlerRegistry queryHandlerRegistry = (QueryHandlerRegistry)bus.getExtension(QueryHandlerRegistry.class);
                    if ("GET".equals(request.getMethod()) && !StringUtils.isEmpty((String)request.getQueryString()) && queryHandlerRegistry != null && (selectedHandler = this.findQueryHandler(queryHandlerRegistry, ei = d.getEndpointInfo(), ctxUri = request.getPathInfo(), baseUri = request.getRequestURL().toString() + "?" + request.getQueryString())) != null) {
                        this.respondUsingQueryHandler(selectedHandler, res, ei, ctxUri, baseUri);
                        boolean bl = true;
                        return bl;
                    }
                }
                this.invokeDestination(request, res, d);
                return true;
            }
            finally {
                if (orig != null) {
                    orig.reset();
                }
            }
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void invokeDestination(HttpServletRequest request, HttpServletResponse response, AbstractHTTPDestination d) throws ServletException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Service http request on thread: " + Thread.currentThread());
        }
        try {
            d.invoke(this.servletConfig, this.servletConfig.getServletContext(), request, response);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Finished servicing http request on thread: " + Thread.currentThread());
            }
        }
    }

    protected QueryHandler findQueryHandler(QueryHandlerRegistry queryHandlerRegistry, EndpointInfo ei, String ctxUri, String baseUri) {
        if (queryHandlerRegistry == null) {
            return null;
        }
        List handlers = queryHandlerRegistry.getHandlers();
        for (QueryHandler qh : handlers) {
            if (!qh.isRecognizedQuery(baseUri, ctxUri, ei)) continue;
            return qh;
        }
        return null;
    }

    protected void respondUsingQueryHandler(QueryHandler selectedHandler, HttpServletResponse res, EndpointInfo ei, String ctxUri, String baseUri) throws IOException, ServletException {
        res.setContentType(selectedHandler.getResponseContentType(baseUri, ctxUri));
        ServletOutputStream out = res.getOutputStream();
        try {
            selectedHandler.writeResponse(baseUri, ctxUri, ei, (OutputStream)out);
            out.flush();
        }
        catch (Exception e) {
            LOG.warning(selectedHandler.getClass().getName() + " Exception caught writing response: " + e.getMessage());
            throw new ServletException((Throwable)e);
        }
    }

    protected void generateNotFound(HttpServletRequest request, HttpServletResponse res) throws IOException {
        res.setStatus(404);
        res.setContentType("text/html");
        res.getWriter().write("<html><body>No service was found.</body></html>");
    }
}

