/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;

public interface Data {
    public void free();

    public void clear();

    public long size();

    public void rewind();

    public DataType next();

    public DataType prev();

    public boolean enter();

    public boolean exit();

    public DataType type();

    public Binary encode();

    public long encode(ByteBuffer var1);

    public long decode(ByteBuffer var1);

    public void putList();

    public void putMap();

    public void putArray(boolean var1, DataType var2);

    public void putDescribed();

    public void putNull();

    public void putBoolean(boolean var1);

    public void putUnsignedByte(UnsignedByte var1);

    public void putByte(byte var1);

    public void putUnsignedShort(UnsignedShort var1);

    public void putShort(short var1);

    public void putUnsignedInteger(UnsignedInteger var1);

    public void putInt(int var1);

    public void putChar(int var1);

    public void putUnsignedLong(UnsignedLong var1);

    public void putLong(long var1);

    public void putTimestamp(Date var1);

    public void putFloat(float var1);

    public void putDouble(double var1);

    public void putDecimal32(Decimal32 var1);

    public void putDecimal64(Decimal64 var1);

    public void putDecimal128(Decimal128 var1);

    public void putUUID(UUID var1);

    public void putBinary(Binary var1);

    public void putBinary(byte[] var1);

    public void putString(String var1);

    public void putSymbol(Symbol var1);

    public void putObject(Object var1);

    public void putJavaMap(Map<Object, Object> var1);

    public void putJavaList(List<Object> var1);

    public void putJavaArray(Object[] var1);

    public void putDescribedType(DescribedType var1);

    public long getList();

    public long getMap();

    public long getArray();

    public boolean isArrayDescribed();

    public DataType getArrayType();

    public boolean isDescribed();

    public boolean isNull();

    public boolean getBoolean();

    public UnsignedByte getUnsignedByte();

    public byte getByte();

    public UnsignedShort getUnsignedShort();

    public short getShort();

    public UnsignedInteger getUnsignedInteger();

    public int getInt();

    public int getChar();

    public UnsignedLong getUnsignedLong();

    public long getLong();

    public Date getTimestamp();

    public float getFloat();

    public double getDouble();

    public Decimal32 getDecimal32();

    public Decimal64 getDecimal64();

    public Decimal128 getDecimal128();

    public UUID getUUID();

    public Binary getBinary();

    public String getString();

    public Symbol getSymbol();

    public Object getObject();

    public Map<Object, Object> getJavaMap();

    public List<Object> getJavaList();

    public Object[] getJavaArray();

    public DescribedType getDescribedType();

    public void copy(Data var1);

    public void append(Data var1);

    public void appendn(Data var1, int var2);

    public void narrow();

    public void widen();

    public static enum DataType {
        NULL,
        BOOL,
        UBYTE,
        BYTE,
        USHORT,
        SHORT,
        UINT,
        INT,
        CHAR,
        ULONG,
        LONG,
        TIMESTAMP,
        FLOAT,
        DOUBLE,
        DECIMAL32,
        DECIMAL64,
        DECIMAL128,
        UUID,
        BINARY,
        STRING,
        SYMBOL,
        DESCRIBED,
        ARRAY,
        LIST,
        MAP;

    }
}

