/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ConnectionPoolConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExecutorFactoryConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.configuration.ServerConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SslConfigurationBuilder;
import org.infinispan.client.hotrod.impl.TypedProperties;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashV1;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashV2;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.RequestBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.configuration.Builder;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.util.Util;

public class ConfigurationBuilder
implements ConfigurationChildBuilder,
Builder<Configuration> {
    private WeakReference<ClassLoader> classLoader;
    private final ExecutorFactoryConfigurationBuilder asyncExecutorFactory;
    private Class<? extends RequestBalancingStrategy> balancingStrategy = RoundRobinBalancingStrategy.class;
    private final ConnectionPoolConfigurationBuilder connectionPool;
    private int connectionTimeout = 60000;
    private Class<? extends ConsistentHash>[] consistentHashImpl = new Class[]{ConsistentHashV1.class, ConsistentHashV2.class};
    private boolean forceReturnValues;
    private int keySizeEstimate = 64;
    private Class<? extends Marshaller> marshallerClass = GenericJBossMarshaller.class;
    private Marshaller marshaller;
    private boolean pingOnStartup = true;
    private String protocolVersion = "1.2";
    private List<ServerConfigurationBuilder> servers = new ArrayList<ServerConfigurationBuilder>();
    private int socketTimeout = 60000;
    private final SslConfigurationBuilder ssl;
    private boolean tcpNoDelay = true;
    private Class<? extends TransportFactory> transportFactory = TcpTransportFactory.class;
    private int valueSizeEstimate = 512;

    public ConfigurationBuilder() {
        this.classLoader = new WeakReference<ClassLoader>(Thread.currentThread().getContextClassLoader());
        this.connectionPool = new ConnectionPoolConfigurationBuilder(this);
        this.asyncExecutorFactory = new ExecutorFactoryConfigurationBuilder(this);
        this.ssl = new SslConfigurationBuilder(this);
    }

    @Override
    public ServerConfigurationBuilder addServer() {
        ServerConfigurationBuilder builder = new ServerConfigurationBuilder(this);
        this.servers.add(builder);
        return builder;
    }

    @Override
    public ConfigurationBuilder addServers(String servers) {
        for (String server : servers.split(";")) {
            String[] components = server.trim().split(":");
            String host = components[0];
            int port = 11222;
            if (components.length > 1) {
                port = Integer.parseInt(components[1]);
            }
            this.addServer().host(host).port(port);
        }
        return this;
    }

    @Override
    public ExecutorFactoryConfigurationBuilder asyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    @Override
    public ConfigurationBuilder balancingStrategy(String balancingStrategy) {
        this.balancingStrategy = Util.loadClass((String)balancingStrategy, (ClassLoader)this.classLoader());
        return this;
    }

    @Override
    public ConfigurationBuilder balancingStrategy(Class<? extends RequestBalancingStrategy> balancingStrategy) {
        this.balancingStrategy = balancingStrategy;
        return this;
    }

    @Override
    public ConfigurationBuilder classLoader(ClassLoader cl) {
        this.classLoader = new WeakReference<ClassLoader>(cl);
        return this;
    }

    ClassLoader classLoader() {
        return this.classLoader != null ? (ClassLoader)this.classLoader.get() : null;
    }

    @Override
    public ConnectionPoolConfigurationBuilder connectionPool() {
        return this.connectionPool;
    }

    @Override
    public ConfigurationBuilder connectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @Override
    public ConfigurationBuilder consistentHashImpl(int version, Class<? extends ConsistentHash> consistentHashClass) {
        this.consistentHashImpl[version - 1] = consistentHashClass;
        return this;
    }

    @Override
    public ConfigurationBuilder consistentHashImpl(int version, String consistentHashClass) {
        this.consistentHashImpl[version - 1] = Util.loadClass((String)consistentHashClass, (ClassLoader)this.classLoader());
        return this;
    }

    @Override
    public ConfigurationBuilder forceReturnValues(boolean forceReturnValues) {
        this.forceReturnValues = forceReturnValues;
        return this;
    }

    @Override
    public ConfigurationBuilder keySizeEstimate(int keySizeEstimate) {
        this.keySizeEstimate = keySizeEstimate;
        return this;
    }

    @Override
    public ConfigurationBuilder marshaller(String marshaller) {
        this.marshallerClass = Util.loadClass((String)marshaller, (ClassLoader)this.classLoader());
        return this;
    }

    @Override
    public ConfigurationBuilder marshaller(Class<? extends Marshaller> marshaller) {
        this.marshallerClass = marshaller;
        return this;
    }

    @Override
    public ConfigurationBuilder marshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
        return this;
    }

    @Override
    public ConfigurationBuilder pingOnStartup(boolean pingOnStartup) {
        this.pingOnStartup = pingOnStartup;
        return this;
    }

    @Override
    public ConfigurationBuilder protocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
        return this;
    }

    @Override
    public ConfigurationBuilder socketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    @Override
    public SslConfigurationBuilder ssl() {
        return this.ssl;
    }

    @Override
    public ConfigurationBuilder tcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    @Override
    public ConfigurationBuilder transportFactory(String transportFactory) {
        this.transportFactory = Util.loadClass((String)transportFactory, (ClassLoader)this.classLoader());
        return this;
    }

    @Override
    public ConfigurationBuilder transportFactory(Class<? extends TransportFactory> transportFactory) {
        this.transportFactory = transportFactory;
        return this;
    }

    @Override
    public ConfigurationBuilder valueSizeEstimate(int valueSizeEstimate) {
        this.valueSizeEstimate = valueSizeEstimate;
        return this;
    }

    @Override
    public ConfigurationBuilder withProperties(Properties properties) {
        TypedProperties typed = TypedProperties.toTypedProperties(properties);
        if (typed.containsKey("infinispan.client.hotrod.async_executor_factory")) {
            this.asyncExecutorFactory().factoryClass(typed.getProperty("infinispan.client.hotrod.async_executor_factory"));
        }
        this.asyncExecutorFactory().withExecutorProperties(typed);
        this.balancingStrategy(typed.getProperty("infinispan.client.hotrod.request_balancing_strategy", this.balancingStrategy.getName()));
        this.connectionPool.withPoolProperties(typed);
        this.connectionTimeout(typed.getIntProperty("infinispan.client.hotrod.connect_timeout", this.connectionTimeout));
        for (int i = 1; i <= this.consistentHashImpl.length; ++i) {
            this.consistentHashImpl(i, typed.getProperty("infinispan.client.hotrod.hash_function_impl." + i, this.consistentHashImpl[i - 1].getName()));
        }
        this.forceReturnValues(typed.getBooleanProperty("infinispan.client.hotrod.force_return_values", this.forceReturnValues));
        this.keySizeEstimate(typed.getIntProperty("infinispan.client.hotrod.key_size_estimate", this.keySizeEstimate));
        if (typed.containsKey("infinispan.client.hotrod.marshaller")) {
            this.marshaller(typed.getProperty("infinispan.client.hotrod.marshaller"));
        }
        this.pingOnStartup(typed.getBooleanProperty("infinispan.client.hotrod.ping_on_startup", this.pingOnStartup));
        this.protocolVersion(typed.getProperty("infinispan.client.hotrod.protocol_version", this.protocolVersion));
        this.servers.clear();
        this.addServers(typed.getProperty("infinispan.client.hotrod.server_list", ""));
        this.socketTimeout(typed.getIntProperty("infinispan.client.hotrod.socket_timeout", this.socketTimeout));
        this.tcpNoDelay(typed.getBooleanProperty("infinispan.client.hotrod.tcp_no_delay", this.tcpNoDelay));
        if (typed.containsKey("infinispan.client.hotrod.transport_factory")) {
            this.transportFactory(typed.getProperty("infinispan.client.hotrod.transport_factory"));
        }
        this.valueSizeEstimate(typed.getIntProperty("infinispan.client.hotrod.value_size_estimate", this.valueSizeEstimate));
        return this;
    }

    public void validate() {
        this.connectionPool.validate();
        this.asyncExecutorFactory.validate();
        this.ssl.validate();
    }

    public Configuration create() {
        ArrayList<ServerConfiguration> servers = new ArrayList<ServerConfiguration>();
        if (this.servers.size() > 0) {
            for (ServerConfigurationBuilder server : this.servers) {
                servers.add(server.create());
            }
        } else {
            servers.add(new ServerConfiguration("127.0.0.1", 11222));
        }
        if (this.marshaller == null) {
            return new Configuration(this.asyncExecutorFactory.create(), this.balancingStrategy, this.classLoader == null ? null : (ClassLoader)this.classLoader.get(), this.connectionPool.create(), this.connectionTimeout, this.consistentHashImpl, this.forceReturnValues, this.keySizeEstimate, this.marshallerClass, this.pingOnStartup, this.protocolVersion, servers, this.socketTimeout, this.ssl.create(), this.tcpNoDelay, this.transportFactory, this.valueSizeEstimate);
        }
        return new Configuration(this.asyncExecutorFactory.create(), this.balancingStrategy, this.classLoader == null ? null : (ClassLoader)this.classLoader.get(), this.connectionPool.create(), this.connectionTimeout, this.consistentHashImpl, this.forceReturnValues, this.keySizeEstimate, this.marshaller, this.pingOnStartup, this.protocolVersion, servers, this.socketTimeout, this.ssl.create(), this.tcpNoDelay, this.transportFactory, this.valueSizeEstimate);
    }

    @Override
    public Configuration build() {
        return this.build(true);
    }

    public Configuration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        return this.create();
    }

    public ConfigurationBuilder read(Configuration template) {
        this.classLoader = new WeakReference<ClassLoader>(template.classLoader());
        this.asyncExecutorFactory.read(template.asyncExecutorFactory());
        this.balancingStrategy = template.balancingStrategy();
        this.connectionPool.read(template.connectionPool());
        this.connectionTimeout = template.connectionTimeout();
        for (int i = 0; i < this.consistentHashImpl.length; ++i) {
            this.consistentHashImpl[i] = template.consistentHashImpl()[i];
        }
        this.forceReturnValues = template.forceReturnValues();
        this.keySizeEstimate = template.keySizeEstimate();
        this.marshaller = template.marshaller();
        this.marshallerClass = template.marshallerClass();
        this.pingOnStartup = template.pingOnStartup();
        this.protocolVersion = template.protocolVersion();
        this.servers.clear();
        for (ServerConfiguration server : template.servers()) {
            this.addServer().host(server.host()).port(server.port());
        }
        this.socketTimeout = template.socketTimeout();
        this.ssl.read(template.ssl());
        this.tcpNoDelay = template.tcpNoDelay();
        this.transportFactory = template.transportFactory();
        this.valueSizeEstimate = template.valueSizeEstimate();
        return this;
    }
}

