/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.ParserNamespaceSupport;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.util.SystemPropertiesUtil;

public abstract class AbstractParser
implements ParserNamespaceSupport {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XMLInputFactory getXMLInputFactory() {
        boolean tccl_jaxp = SystemPropertiesUtil.getSystemProperty("picketlink.jaxp.tccl", "false").equalsIgnoreCase("true");
        ClassLoader prevTCCL = this.getTCCL();
        try {
            if (tccl_jaxp) {
                this.setTCCL(this.getClass().getClassLoader());
            }
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            return xMLInputFactory;
        }
        finally {
            if (tccl_jaxp) {
                this.setTCCL(prevTCCL);
            }
        }
    }

    public Object parse(InputStream configStream) throws ParsingException {
        if (configStream == null) {
            throw logger.nullArgumentError("InputStream");
        }
        XMLInputFactory xmlInputFactory = this.getXMLInputFactory();
        XMLEventReader xmlEventReader = StaxParserUtil.getXMLEventReader(configStream);
        try {
            xmlEventReader = xmlInputFactory.createFilteredReader(xmlEventReader, new EventFilter(){

                public boolean accept(XMLEvent xmlEvent) {
                    if (xmlEvent.isCharacters()) {
                        Characters chars = xmlEvent.asCharacters();
                        String data = chars.getData();
                        data = this.valid(data) ? data.trim() : null;
                        return this.valid(data);
                    }
                    return xmlEvent.isStartElement() || xmlEvent.isEndElement();
                }

                private boolean valid(String str) {
                    return str != null && str.length() > 0;
                }
            });
        }
        catch (XMLStreamException e) {
            throw logger.parserException(e);
        }
        return this.parse(xmlEventReader);
    }

    private ClassLoader getTCCL() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        return Thread.currentThread().getContextClassLoader();
    }

    private void setTCCL(final ClassLoader paramCl) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Thread.currentThread().setContextClassLoader(paramCl);
                    return null;
                }
            });
        } else {
            Thread.currentThread().setContextClassLoader(paramCl);
        }
    }
}

