/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.wsa;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.AbstractParser;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.ws.addressing.AttributedURIType;
import org.picketlink.identity.federation.ws.addressing.EndpointReferenceType;

public class WSAddressingParser
extends AbstractParser {
    public static final String ENDPOINT_REFERENCE = "EndpointReference";
    public static final String ADDRESS = "Address";

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof StartElement) {
                StartElement startElement = (StartElement)xmlEvent;
                String elementName = StaxParserUtil.getStartElementName(startElement);
                if (!elementName.equalsIgnoreCase(ENDPOINT_REFERENCE)) continue;
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                StaxParserUtil.validate(startElement, ENDPOINT_REFERENCE);
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                StaxParserUtil.validate(startElement, ADDRESS);
                if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                    throw logger.parserExpectedTextValue("endpointURI");
                }
                String endpointURI = StaxParserUtil.getElementText(xmlEventReader);
                AttributedURIType attributedURI = new AttributedURIType();
                attributedURI.setValue(endpointURI);
                EndpointReferenceType reference = new EndpointReferenceType();
                reference.setAddress(attributedURI);
                xmlEvent = StaxParserUtil.getNextEvent(xmlEventReader);
                EndElement endElement = (EndElement)xmlEvent;
                StaxParserUtil.validate(endElement, ENDPOINT_REFERENCE);
                return reference;
            }
            StaxParserUtil.getNextEvent(xmlEventReader);
        }
        throw logger.parserFailed("http://www.w3.org/2005/08/addressing");
    }

    public boolean supports(QName qname) {
        return "http://www.w3.org/2005/08/addressing".equals(qname.getNamespaceURI());
    }
}

