/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSAML2HandlerRequest
implements SAML2HandlerRequest {
    private ProtocolContext protocolContext = null;
    private NameIDType issuer;
    private SAMLDocumentHolder documentHolder;
    private SAML2Handler.HANDLER_TYPE handlerType;
    private Map<String, Object> options = new HashMap<String, Object>();
    private SAML2HandlerRequest.GENERATE_REQUEST_TYPE generateRequestType;
    private String relayState;

    public DefaultSAML2HandlerRequest(ProtocolContext protocolContext, NameIDType issuer, SAMLDocumentHolder samlDocumentHolder, SAML2Handler.HANDLER_TYPE handlerType) {
        this.protocolContext = protocolContext;
        this.issuer = issuer;
        this.documentHolder = samlDocumentHolder;
        this.handlerType = handlerType;
    }

    @Override
    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    @Override
    public ProtocolContext getContext() {
        return this.protocolContext;
    }

    @Override
    public NameIDType getIssuer() {
        return this.issuer;
    }

    @Override
    public SAML2Object getSAML2Object() {
        return this.documentHolder.getSamlObject();
    }

    public SAML2Handler.HANDLER_TYPE getType() {
        return this.handlerType;
    }

    @Override
    public void addOption(String key, Object option) {
        this.options.put(key, option);
    }

    @Override
    public Map<String, Object> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    @Override
    public void setTypeOfRequestToBeGenerated(SAML2HandlerRequest.GENERATE_REQUEST_TYPE grt) {
        this.generateRequestType = grt;
    }

    @Override
    public SAML2HandlerRequest.GENERATE_REQUEST_TYPE getTypeOfRequestToBeGenerated() {
        return this.generateRequestType;
    }

    @Override
    public String getRelayState() {
        return this.relayState;
    }

    @Override
    public void setRelayState(String relay) {
        this.relayState = relay;
    }

    @Override
    public Document getRequestDocument() {
        return this.documentHolder.getSamlDocument();
    }
}

