/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.writers;

import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.writers.BaseWriter;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLAssertionWriter;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLRequestWriter;
import org.picketlink.identity.federation.core.util.StaxUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedAssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.protocol.ArtifactResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusCodeType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusDetailType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusType;
import org.w3c.dom.Element;

public class SAMLResponseWriter
extends BaseWriter {
    private final SAMLAssertionWriter assertionWriter;

    public SAMLResponseWriter(XMLStreamWriter writer) {
        super(writer);
        this.assertionWriter = new SAMLAssertionWriter(writer);
    }

    public void write(ResponseType response) throws ProcessingException {
        Element sig;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.RESPONSE.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, PROTOCOL_PREFIX, JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, ASSERTION_PREFIX, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        this.writeBaseAttributes(response);
        NameIDType issuer = response.getIssuer();
        if (issuer != null) {
            this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        }
        if ((sig = response.getSignature()) != null) {
            StaxUtil.writeDOMElement(this.writer, sig);
        }
        StatusType status = response.getStatus();
        this.write(status);
        List<ResponseType.RTChoiceType> choiceTypes = response.getAssertions();
        if (choiceTypes != null) {
            for (ResponseType.RTChoiceType choiceType : choiceTypes) {
                EncryptedAssertionType encryptedAssertion;
                AssertionType assertion = choiceType.getAssertion();
                if (assertion != null) {
                    this.assertionWriter.write(assertion);
                }
                if ((encryptedAssertion = choiceType.getEncryptedAssertion()) == null) continue;
                Element encElement = encryptedAssertion.getEncryptedElement();
                StaxUtil.writeDOMElement(this.writer, encElement);
            }
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(ArtifactResponseType response) throws ProcessingException {
        Object anyObj;
        StatusType status;
        Element sig;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.ARTIFACT_RESPONSE.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, PROTOCOL_PREFIX, JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, ASSERTION_PREFIX, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeDefaultNameSpace(this.writer, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        this.writeBaseAttributes(response);
        NameIDType issuer = response.getIssuer();
        if (issuer != null) {
            this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        }
        if ((sig = response.getSignature()) != null) {
            StaxUtil.writeDOMElement(this.writer, sig);
        }
        if ((status = response.getStatus()) != null) {
            this.write(status);
        }
        if ((anyObj = response.getAny()) instanceof AuthnRequestType) {
            AuthnRequestType authn = (AuthnRequestType)anyObj;
            SAMLRequestWriter requestWriter = new SAMLRequestWriter(this.writer);
            requestWriter.write(authn);
        } else if (anyObj instanceof ResponseType) {
            ResponseType rt = (ResponseType)anyObj;
            this.write(rt);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(StatusResponseType response, QName qname) throws ProcessingException {
        if (qname == null) {
            StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.STATUS_RESPONSE_TYPE.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        } else {
            StaxUtil.writeStartElement(this.writer, qname.getPrefix(), qname.getLocalPart(), qname.getNamespaceURI());
        }
        StaxUtil.writeNameSpace(this.writer, PROTOCOL_PREFIX, JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeDefaultNameSpace(this.writer, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        this.writeBaseAttributes(response);
        NameIDType issuer = response.getIssuer();
        this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        StatusType status = response.getStatus();
        this.write(status);
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(StatusType status) throws ProcessingException {
        StatusDetailType statusDetail;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.STATUS.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StatusCodeType statusCodeType = status.getStatusCode();
        this.write(statusCodeType);
        String statusMessage = status.getStatusMessage();
        if (StringUtil.isNotNull(statusMessage)) {
            StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.STATUS_MESSAGE.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
            StaxUtil.writeEndElement(this.writer);
        }
        if ((statusDetail = status.getStatusDetail()) != null) {
            this.write(statusDetail);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(StatusCodeType statusCodeType) throws ProcessingException {
        StatusCodeType subStatusCode;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.STATUS_CODE.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        URI value = statusCodeType.getValue();
        if (value != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.VALUE.get(), value.toASCIIString());
        }
        if ((subStatusCode = statusCodeType.getStatusCode()) != null) {
            this.write(subStatusCode);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(StatusDetailType statusDetailType) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.STATUS_CODE.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    private void writeBaseAttributes(StatusResponseType statusResponse) throws ProcessingException {
        String inResponseTo;
        String consent;
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ID.get(), statusResponse.getID());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.VERSION.get(), statusResponse.getVersion());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ISSUE_INSTANT.get(), statusResponse.getIssueInstant().toString());
        String destination = statusResponse.getDestination();
        if (StringUtil.isNotNull(destination)) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.DESTINATION.get(), destination);
        }
        if (StringUtil.isNotNull(consent = statusResponse.getConsent())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.CONSENT.get(), consent);
        }
        if (StringUtil.isNotNull(inResponseTo = statusResponse.getInResponseTo())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.IN_RESPONSE_TO.get(), inResponseTo);
        }
    }
}

